/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.header;

import io.inverno.mod.base.Charsets;
import io.inverno.mod.http.base.header.AbstractHeaderCodec;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.internal.header.GenericHeader;
import io.inverno.mod.http.base.internal.header.MalformedHeaderException;
import io.inverno.mod.http.base.internal.header.ParameterizedHeader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class ParameterizedHeaderCodec<A extends ParameterizedHeader, B extends ParameterizedHeader.AbstractBuilder<A, B>>
extends AbstractHeaderCodec<A, B> {
    public static final char DEFAULT_PARAMETER_DELIMITER = ';';
    public static final char DEFAULT_VALUE_DELIMITER = ',';
    protected final char parameterDelimiter;
    protected final char valueDelimiter;
    private final boolean allowEmptyValue;
    private final boolean expectNoValue;
    private final boolean allowFlagParameter;
    private final boolean allowSpaceInValue;
    private final boolean allowQuotedValue;
    private final boolean allowMultiple;

    public ParameterizedHeaderCodec(Supplier<B> builderSupplier, Set<String> supportedHeaderNames, char parameterDelimiter, char valueDelimiter, boolean allowEmptyValue, boolean expectNoValue, boolean allowFlagParameter, boolean allowSpaceInValue, boolean allowQuotedValue, boolean allowMultiple) {
        super(builderSupplier, supportedHeaderNames);
        this.parameterDelimiter = parameterDelimiter;
        this.valueDelimiter = valueDelimiter;
        this.allowEmptyValue = allowEmptyValue;
        this.expectNoValue = expectNoValue;
        this.allowFlagParameter = allowFlagParameter;
        this.allowSpaceInValue = allowSpaceInValue;
        this.allowQuotedValue = allowQuotedValue;
        this.allowMultiple = allowMultiple;
        if (!this.allowEmptyValue && this.expectNoValue) {
            throw new IllegalArgumentException("Can't expect no value and not allow empty value");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public A decode(String name, String rawValue) {
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)rawValue, (Charset)Charsets.DEFAULT);
        buffer.writeByte(10);
        try {
            Header header = this.decode(name, buffer, Charsets.DEFAULT);
            return (A)header;
        }
        finally {
            buffer.release();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public A decode(String name, ByteBuf buffer, Charset charset) {
        int readerIndex = buffer.readerIndex();
        ParameterizedHeader.AbstractBuilder builder = (ParameterizedHeader.AbstractBuilder)((ParameterizedHeader.AbstractBuilder)this.builderSupplier.get()).headerName(name);
        boolean value = false;
        boolean end = false;
        Integer startIndex = null;
        Integer endIndex = null;
        String parameterName = null;
        boolean quoted = false;
        boolean blankValue = true;
        boolean endSingle = false;
        while (buffer.isReadable()) {
            byte nextByte = buffer.readByte();
            if (nextByte == 13) {
                if (!buffer.isReadable()) break;
                if (buffer.getByte(buffer.readerIndex()) != 10) {
                    buffer.readerIndex(readerIndex);
                    throw new MalformedHeaderException(name + ": Bad end of line");
                }
                buffer.readByte();
                if (endIndex == null) {
                    endIndex = buffer.readerIndex() - 2;
                }
                builder.headerValue(buffer.getCharSequence(readerIndex, buffer.readerIndex() - 2 - readerIndex, charset).toString());
                end = true;
            } else if (nextByte == 10) {
                if (endIndex == null) {
                    endIndex = buffer.readerIndex() - 1;
                }
                builder.headerValue(buffer.getCharSequence(readerIndex, buffer.readerIndex() - 1 - readerIndex, charset).toString());
                end = true;
            } else if (nextByte == this.valueDelimiter && this.allowMultiple && !quoted) {
                if (endIndex == null) {
                    endIndex = buffer.readerIndex() - 1;
                }
                endSingle = true;
            } else if (!HeaderService.isContentCharacter((char)nextByte)) {
                throw new MalformedHeaderException(name + ": Invalid character " + (char)nextByte);
            }
            if (end || endSingle) {
                if (!value) {
                    if (startIndex == null) {
                        buffer.readerIndex(readerIndex);
                        throw new MalformedHeaderException(name);
                    }
                    if (this.expectNoValue) {
                        buffer.readerIndex(readerIndex);
                        throw new MalformedHeaderException(name + ": expect no value");
                    }
                    builder.parameterizedValue(buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString());
                } else if (parameterName != null) {
                    if (startIndex == null) {
                        buffer.readerIndex(readerIndex);
                        throw new MalformedHeaderException(name);
                    }
                    builder.parameter(parameterName, buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString());
                } else if (startIndex != null) {
                    if (endIndex == null) {
                        endIndex = buffer.readerIndex() - 1;
                    }
                    if (startIndex == endIndex) {
                        buffer.readerIndex(readerIndex);
                        throw new MalformedHeaderException(name);
                    }
                    if (!this.allowFlagParameter) {
                        buffer.readerIndex(readerIndex);
                        throw new MalformedHeaderException(name + ": flag parameters not allowed");
                    }
                    builder.parameter(buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString(), null);
                }
                if (end) {
                    return (A)((ParameterizedHeader)builder.build());
                }
                value = false;
                end = false;
                startIndex = null;
                endIndex = null;
                parameterName = null;
                quoted = false;
                blankValue = true;
                endSingle = false;
                continue;
            }
            if (!value) {
                if (startIndex == null) {
                    if (!this.allowSpaceInValue && Character.isWhitespace(nextByte)) continue;
                    startIndex = buffer.readerIndex() - 1;
                }
                if (nextByte == 59) {
                    if (this.expectNoValue) {
                        buffer.readerIndex(readerIndex);
                        throw new MalformedHeaderException(name + ": expect no value");
                    }
                    if (endIndex == null) {
                        endIndex = buffer.readerIndex() - 1;
                    }
                    if (startIndex == endIndex) {
                        if (!this.allowEmptyValue) {
                            buffer.readerIndex(readerIndex);
                            throw new MalformedHeaderException(name + ": empty value not allowed");
                        }
                        builder.parameterizedValue("");
                    } else {
                        builder.parameterizedValue(buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString());
                    }
                    value = true;
                    endIndex = null;
                    startIndex = null;
                    continue;
                }
                if (nextByte == 61) {
                    if (!this.allowEmptyValue) {
                        buffer.readerIndex(readerIndex);
                        throw new MalformedHeaderException(name + ": empty value not allowed");
                    }
                    if (endIndex == null) {
                        endIndex = buffer.readerIndex() - 1;
                    }
                    builder.parameterizedValue(null);
                    parameterName = buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString().trim();
                    value = true;
                    endIndex = null;
                    startIndex = null;
                    continue;
                }
                if (Character.isWhitespace(nextByte)) {
                    if (!this.allowSpaceInValue) {
                        if (endIndex != null) continue;
                        endIndex = buffer.readerIndex() - 1;
                        continue;
                    }
                    endIndex = null;
                    continue;
                }
                if (endIndex == null) continue;
                if (!this.allowSpaceInValue) {
                    buffer.readerIndex(readerIndex);
                    throw new MalformedHeaderException(name + ": space not allowed in value");
                }
                endIndex = null;
                continue;
            }
            if (parameterName == null) {
                if (startIndex == null) {
                    if (Character.isWhitespace(nextByte)) continue;
                    startIndex = buffer.readerIndex() - 1;
                }
                if (nextByte == 61) {
                    if (endIndex == null) {
                        endIndex = buffer.readerIndex() - 1;
                    }
                    if (startIndex == endIndex) {
                        buffer.readerIndex(readerIndex);
                        throw new MalformedHeaderException(name);
                    }
                    parameterName = buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString();
                    endIndex = null;
                    startIndex = null;
                    continue;
                }
                if (nextByte == 59) {
                    if (endIndex == null) {
                        endIndex = buffer.readerIndex() - 1;
                    }
                    if (startIndex == endIndex) {
                        buffer.readerIndex(readerIndex);
                        throw new MalformedHeaderException(name);
                    }
                    if (!this.allowFlagParameter) {
                        buffer.readerIndex(readerIndex);
                        throw new MalformedHeaderException(name + ": flag parameters not allowed");
                    }
                    builder.parameter(buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString(), null);
                    parameterName = null;
                    endIndex = null;
                    startIndex = null;
                    continue;
                }
                if (Character.isWhitespace(nextByte)) {
                    endIndex = buffer.readerIndex() - 1;
                    continue;
                }
                if (!HeaderService.isTokenCharacter((char)nextByte)) {
                    buffer.readerIndex(readerIndex);
                    throw new MalformedHeaderException(name + ": invalid character " + (char)nextByte);
                }
                if (endIndex == null) continue;
                buffer.readerIndex(readerIndex);
                throw new MalformedHeaderException(name);
            }
            if (startIndex == null) {
                if (!this.allowSpaceInValue && Character.isWhitespace(nextByte)) continue;
                startIndex = buffer.readerIndex() - 1;
                if (this.allowQuotedValue && nextByte == 34) {
                    quoted = true;
                    Integer n = startIndex;
                    startIndex = startIndex + 1;
                    continue;
                }
            } else if (this.allowQuotedValue && !quoted && nextByte == 34 && blankValue) {
                quoted = true;
                startIndex = buffer.readerIndex();
                blankValue = false;
                continue;
            }
            if (nextByte == this.parameterDelimiter) {
                if (endIndex == null) {
                    endIndex = buffer.readerIndex() - 1;
                }
                if (startIndex == endIndex) {
                    buffer.readerIndex(readerIndex);
                    throw new MalformedHeaderException(name);
                }
                builder.parameter(parameterName, buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString());
                parameterName = null;
                endIndex = null;
                startIndex = null;
                quoted = false;
                blankValue = true;
                continue;
            }
            if (quoted && nextByte == 34 && buffer.getByte(buffer.readerIndex() - 1) != 92) {
                endIndex = buffer.readerIndex() - 1;
                continue;
            }
            if (Character.isWhitespace(nextByte)) {
                if (quoted) continue;
                if (!this.allowSpaceInValue) {
                    if (endIndex != null) continue;
                    endIndex = buffer.readerIndex() - 1;
                    continue;
                }
                endIndex = null;
                continue;
            }
            if (endIndex != null) {
                if (!this.allowSpaceInValue) {
                    buffer.readerIndex(readerIndex);
                    throw new MalformedHeaderException(name + ": space not allowed in value");
                }
                endIndex = null;
                continue;
            }
            if (!blankValue) continue;
            blankValue = false;
        }
        buffer.readerIndex(readerIndex);
        return null;
    }

    @Override
    public String encode(A headerField) {
        StringBuilder result = new StringBuilder();
        result.append(((GenericHeader)headerField).getHeaderName()).append(": ").append(this.encodeValue(headerField));
        return result.toString();
    }

    @Override
    public String encodeValue(A headerField) {
        StringBuilder result = new StringBuilder();
        result.append(((ParameterizedHeader)headerField).getParameterizedValue());
        Map<String, String> parameters = ((ParameterizedHeader)headerField).getParameters();
        if (!parameters.isEmpty()) {
            parameters.entrySet().stream().forEach(e -> result.append(this.parameterDelimiter).append((String)e.getKey()).append("=").append((String)e.getValue()));
        }
        return result.toString();
    }
}

