/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base;

import io.inverno.mod.http.base.Status;

public class HttpException
extends RuntimeException {
    private static final long serialVersionUID = 2847460450871488615L;
    private int statusCode;
    private String statusReasonPhrase;
    private Status.Category statusCategory;

    public HttpException() {
        this(500);
    }

    public HttpException(String message) {
        this(500, message);
    }

    public HttpException(Throwable cause) {
        this(500, cause);
    }

    public HttpException(String message, Throwable cause) {
        this(500, message, cause);
    }

    public HttpException(int statusCode) throws IllegalArgumentException {
        this.setStatusCode(statusCode);
    }

    public HttpException(int statusCode, String message) throws IllegalArgumentException {
        super(message);
        this.setStatusCode(statusCode);
    }

    public HttpException(int statusCode, Throwable cause) throws IllegalArgumentException {
        super(cause);
        this.setStatusCode(statusCode);
    }

    public HttpException(int statusCode, String message, Throwable cause) throws IllegalArgumentException {
        super(message, cause);
        this.setStatusCode(statusCode);
    }

    public HttpException(Status status) {
        this.setStatus(status);
    }

    public HttpException(Status status, String message) {
        super(message);
        this.setStatus(status);
    }

    public HttpException(Status status, Throwable cause) {
        super(cause);
        this.setStatus(status);
    }

    public HttpException(Status status, String message, Throwable cause) {
        super(message, cause);
        this.setStatus(status);
    }

    private void setStatus(Status status) {
        this.statusCode = status.getCode();
        this.statusReasonPhrase = status.getReasonPhrase();
        this.statusCategory = status.getCategory();
    }

    private void setStatusCode(int statusCode) {
        try {
            Status status = Status.valueOf(statusCode);
            this.statusCode = status.getCode();
            this.statusReasonPhrase = status.getReasonPhrase();
        }
        catch (IllegalArgumentException e) {
            this.statusCode = statusCode;
            this.statusCategory = Status.Category.valueOf(statusCode);
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusReasonPhrase() {
        return this.statusReasonPhrase;
    }

    public Status.Category getStatusCategory() {
        return this.statusCategory;
    }
}

