/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.header;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.header.SetCookie;
import io.inverno.mod.http.base.internal.header.ParameterizedHeader;
import io.inverno.mod.http.base.internal.header.ParameterizedHeaderCodec;
import java.util.Map;
import java.util.Set;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class SetCookieCodec
extends ParameterizedHeaderCodec<SetCookie, SetCookie.Builder> {
    public SetCookieCodec() {
        super(SetCookie.Builder::new, Set.of("set-cookie"), ';', ',', true, true, true, true, false, false);
    }

    @Override
    public String encodeValue(SetCookie headerField) {
        StringBuilder result = new StringBuilder();
        result.append(headerField.getName()).append("=").append(headerField.getValue());
        if (headerField.getExpires() != null) {
            result.append("; ").append("Expires").append("=").append(headerField.getExpires());
        }
        if (headerField.getMaxAge() != null) {
            result.append("; ").append("Max-Age").append("=").append(headerField.getMaxAge());
        }
        if (headerField.getDomain() != null) {
            result.append("; ").append("Domain").append("=").append(headerField.getDomain());
        }
        if (headerField.getPath() != null) {
            result.append("; ").append("Path").append("=").append(headerField.getPath());
        }
        if (headerField.isSecure() != null && headerField.isSecure().booleanValue()) {
            result.append("; ").append("Secure");
        }
        if (headerField.isHttpOnly() != null && headerField.isHttpOnly().booleanValue()) {
            result.append("; ").append("HttpOnly");
        }
        return result.toString();
    }

    public static final class SetCookie
    extends ParameterizedHeader
    implements Headers.SetCookie,
    io.inverno.mod.http.base.header.SetCookie,
    SetCookie.Configurator {
        private String name;
        private String value;
        private String expires;
        private Integer maxAge;
        private String domain;
        private String path;
        private Boolean secure;
        private Boolean httpOnly;

        public SetCookie() {
            super("set-cookie", null, null, null);
        }

        private SetCookie(String headerName, String headerValue, String name, String value, String expires, Integer maxAge, String domain, String path, Boolean secure, Boolean httpOnly, Map<String, String> parameters) {
            super("set-cookie", headerValue, null, parameters);
            this.name = name;
            this.value = value;
            this.expires = expires;
            this.maxAge = maxAge;
            this.domain = domain;
            this.path = path;
            this.secure = secure;
            this.httpOnly = httpOnly;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getExpires() {
            return this.expires;
        }

        @Override
        public Integer getMaxAge() {
            return this.maxAge;
        }

        @Override
        public String getDomain() {
            return this.domain;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public Boolean isSecure() {
            return this.secure;
        }

        @Override
        public Boolean isHttpOnly() {
            return this.httpOnly;
        }

        @Override
        public SetCookie.Configurator name(String name) {
            this.name = name;
            return null;
        }

        @Override
        public SetCookie.Configurator value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public SetCookie.Configurator maxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        @Override
        public SetCookie.Configurator domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public SetCookie.Configurator path(String path) {
            this.path = path;
            return this;
        }

        @Override
        public SetCookie.Configurator secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        @Override
        public SetCookie.Configurator httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public static final class Builder
        extends ParameterizedHeader.AbstractBuilder<SetCookie, Builder> {
            private String name;
            private String value;
            private String expires;
            private Integer maxAge;
            private String domain;
            private String path;
            private Boolean secure;
            private Boolean httpOnly;
            private boolean expectCookiePair = true;

            @Override
            public Builder parameter(String name, String value) {
                if (this.expectCookiePair) {
                    this.name = name;
                    this.value = value;
                    this.expectCookiePair = false;
                    return this;
                }
                if (name.equalsIgnoreCase("Expires")) {
                    this.expires = value;
                }
                if (name.equalsIgnoreCase("Max-Age")) {
                    this.maxAge = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("Domain")) {
                    this.domain = value;
                }
                if (name.equalsIgnoreCase("Path")) {
                    this.path = value;
                }
                if (name.equalsIgnoreCase("Secure")) {
                    this.secure = true;
                }
                if (name.equalsIgnoreCase("HttpOnly")) {
                    this.httpOnly = true;
                }
                return (Builder)super.parameter(name, value);
            }

            @Override
            public SetCookie build() {
                return new SetCookie(this.headerName, this.headerValue, this.name, this.value, this.expires, this.maxAge, this.domain, this.path, this.secure, this.httpOnly, this.parameters);
            }
        }
    }
}

