package io.inverno.mod.http.base;

import io.inverno.core.v1.Module;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.header.HeaderCodec;
import io.inverno.mod.http.base.internal.ParameterConverter;
import io.inverno.mod.http.base.internal.header.AcceptCodec;
import io.inverno.mod.http.base.internal.header.AcceptLanguageCodec;
import io.inverno.mod.http.base.internal.header.ContentDispositionCodec;
import io.inverno.mod.http.base.internal.header.ContentTypeCodec;
import io.inverno.mod.http.base.internal.header.CookieCodec;
import io.inverno.mod.http.base.internal.header.GenericHeaderService;
import io.inverno.mod.http.base.internal.header.SetCookieCodec;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.processing.Generated;

@Generated(value= {"io.inverno.core.compiler.InvernoCompiler", "1"}, date = "2021-08-13T16:34:51.846501420+02:00[Europe/Paris]")
public final class Base extends Module {

	private Bean<GenericHeaderService> headerService;
	private Bean<CookieCodec> cookieCodec;
	private Bean<AcceptCodec> acceptCodec;
	private Bean<SetCookieCodec> setCookieCodec;
	private Bean<AcceptLanguageCodec> acceptLanguageCodec;
	private Bean<ContentDispositionCodec> contentDispositionCodec;
	private Bean<ContentTypeCodec> contentTypeCodec;
	private Bean<ObjectConverter<String>> parameterConverter;

	private Base(@Socket(name = "headerCodecs", wiredTo = {"setCookieCodec", "contentTypeCodec", "acceptLanguageCodec", "parameterConverter", "acceptCodec", "cookieCodec", "contentDispositionCodec", "headerService"}) Optional<Supplier<List<HeaderCodec<?>>>> headerCodecs, @Socket(name = "parameterConverter", wiredTo = {"cookieCodec", "headerService"}) Optional<Supplier<ObjectConverter<String>>> parameterConverterOverride) {
		super("io.inverno.mod.http.base");

		this.headerService = this.with(ModuleBeanBuilder
			.singleton("headerService", () -> {
				GenericHeaderService headerService = new GenericHeaderService();
				headerService.setHeaderCodecs(new BeanAggregator<HeaderCodec<?>>()
					.add(this.cookieCodec.get())
					.add(this.acceptCodec.get())
					.add(this.setCookieCodec.get())
					.add(this.acceptLanguageCodec.get())
					.add(this.contentDispositionCodec.get())
					.add(this.contentTypeCodec.get())
					.add(headerCodecs.orElse(() -> null).get())
				.toList());
				return headerService;
			})
		);
		this.cookieCodec = this.with(ModuleBeanBuilder
			.singleton("cookieCodec", () -> {
				CookieCodec cookieCodec = new CookieCodec(
					this.parameterConverter.get()
				);

				return cookieCodec;
			})
		);
		this.acceptCodec = this.with(ModuleBeanBuilder
			.singleton("acceptCodec", () -> {
				AcceptCodec acceptCodec = new AcceptCodec();

				return acceptCodec;
			})
		);
		this.setCookieCodec = this.with(ModuleBeanBuilder
			.singleton("setCookieCodec", () -> {
				SetCookieCodec setCookieCodec = new SetCookieCodec();

				return setCookieCodec;
			})
		);
		this.acceptLanguageCodec = this.with(ModuleBeanBuilder
			.singleton("acceptLanguageCodec", () -> {
				AcceptLanguageCodec acceptLanguageCodec = new AcceptLanguageCodec();

				return acceptLanguageCodec;
			})
		);
		this.contentDispositionCodec = this.with(ModuleBeanBuilder
			.singleton("contentDispositionCodec", () -> {
				ContentDispositionCodec contentDispositionCodec = new ContentDispositionCodec();

				return contentDispositionCodec;
			})
		);
		this.contentTypeCodec = this.with(ModuleBeanBuilder
			.singleton("contentTypeCodec", () -> {
				ContentTypeCodec contentTypeCodec = new ContentTypeCodec();

				return contentTypeCodec;
			})
		);
		this.parameterConverter = this.with(WrapperBeanBuilder
			.singleton("parameterConverter", () -> {
				ParameterConverter parameterConverter = new ParameterConverter();

				return parameterConverter;
			})
			.override(parameterConverterOverride)
		);
	}

	public GenericHeaderService headerService() {
		return this.headerService.get();
	}

	private CookieCodec cookieCodec() {
		return this.cookieCodec.get();
	}

	private AcceptCodec acceptCodec() {
		return this.acceptCodec.get();
	}

	private SetCookieCodec setCookieCodec() {
		return this.setCookieCodec.get();
	}

	private AcceptLanguageCodec acceptLanguageCodec() {
		return this.acceptLanguageCodec.get();
	}

	private ContentDispositionCodec contentDispositionCodec() {
		return this.contentDispositionCodec.get();
	}

	private ContentTypeCodec contentTypeCodec() {
		return this.contentTypeCodec.get();
	}

	private ObjectConverter<String> parameterConverter() {
		return this.parameterConverter.get();
	}

	public static final class Builder extends ModuleBuilder<Base> {

		private Optional<Supplier<List<HeaderCodec<?>>>> headerCodecs = Optional.empty();
		private Optional<Supplier<ObjectConverter<String>>> parameterConverter = Optional.empty();

		protected Base doBuild() {
			return new Base(this.headerCodecs, this.parameterConverter);
		}

		public Builder setHeaderCodecs(List<HeaderCodec<?>> headerCodecs) {
			this.headerCodecs = Optional.ofNullable(headerCodecs != null ? () -> headerCodecs : null);
			return this;
		}

		public Builder setParameterConverter(ObjectConverter<String> parameterConverter) {
			this.parameterConverter = Optional.ofNullable(parameterConverter != null ? () -> parameterConverter : null);
			return this;
		}
	}

	public static final class Linker extends ModuleLinker<Base> {

		public Linker(Map<String, Object> sockets) {
			super(sockets);
		}

		@SuppressWarnings("unchecked")
		protected Base link() {
			return new Base(
				(Optional<Supplier<List<HeaderCodec<?>>>>)this.sockets.get("headerCodecs"),
				(Optional<Supplier<ObjectConverter<String>>>)this.sockets.get("parameterConverter")
			);
		}
	}
}
