/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.ws;

import io.inverno.mod.http.base.ws.WebSocketException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;

public interface WebSocketFrame {
    public Kind getKind();

    public boolean isFinal();

    public ByteBuf getBinaryData();

    public String getTextData();

    public WebSocketFrame retainedDuplicate();

    public WebSocketFrame retain();

    public WebSocketFrame release();

    public int refCnt();

    public static interface Factory {
        default public WebSocketFrame binary(ByteBuf data) throws WebSocketException {
            return this.binary(data, true);
        }

        public WebSocketFrame binary(ByteBuf var1, boolean var2) throws WebSocketException;

        default public WebSocketFrame text(String text) throws WebSocketException {
            return this.text(text, true);
        }

        default public WebSocketFrame text(String text, boolean finalFragment) throws WebSocketException {
            ByteBuf data = text == null || text.isEmpty() ? Unpooled.EMPTY_BUFFER : Unpooled.copiedBuffer((CharSequence)text, (Charset)CharsetUtil.UTF_8);
            return this.text(data, finalFragment);
        }

        default public WebSocketFrame text(ByteBuf data) throws WebSocketException {
            return this.text(data, true);
        }

        public WebSocketFrame text(ByteBuf var1, boolean var2) throws WebSocketException;

        public WebSocketFrame continuation(ByteBuf var1, boolean var2) throws WebSocketException;

        public WebSocketFrame ping(ByteBuf var1) throws WebSocketException;

        public WebSocketFrame pong(ByteBuf var1) throws WebSocketException;
    }

    public static enum Kind {
        PING,
        PONG,
        CLOSE,
        CONTINUATION,
        TEXT,
        BINARY;

    }
}

