/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.ws;

import io.inverno.mod.base.Charsets;
import io.inverno.mod.http.base.ws.WebSocketException;
import io.inverno.mod.http.base.ws.WebSocketFrame;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;

public class GenericWebSocketFrame
implements WebSocketFrame {
    private final WebSocketFrame.Kind kind;
    private final io.netty.handler.codec.http.websocketx.WebSocketFrame underlyingFrame;

    public GenericWebSocketFrame(io.netty.handler.codec.http.websocketx.WebSocketFrame underlyingFrame) {
        this(underlyingFrame, GenericWebSocketFrame.getKind(underlyingFrame));
    }

    public GenericWebSocketFrame(io.netty.handler.codec.http.websocketx.WebSocketFrame underlyingFrame, WebSocketFrame.Kind kind) {
        this.underlyingFrame = underlyingFrame;
        this.kind = kind;
    }

    private static WebSocketFrame.Kind getKind(io.netty.handler.codec.http.websocketx.WebSocketFrame underlyingFrame) throws IllegalArgumentException {
        if (underlyingFrame instanceof TextWebSocketFrame) {
            return WebSocketFrame.Kind.TEXT;
        }
        if (underlyingFrame instanceof BinaryWebSocketFrame) {
            return WebSocketFrame.Kind.BINARY;
        }
        if (underlyingFrame instanceof ContinuationWebSocketFrame) {
            return WebSocketFrame.Kind.CONTINUATION;
        }
        if (underlyingFrame instanceof PingWebSocketFrame) {
            return WebSocketFrame.Kind.PING;
        }
        if (underlyingFrame instanceof PongWebSocketFrame) {
            return WebSocketFrame.Kind.PONG;
        }
        if (underlyingFrame instanceof CloseWebSocketFrame) {
            return WebSocketFrame.Kind.CLOSE;
        }
        throw new IllegalArgumentException("Unsupported frame type: " + String.valueOf(underlyingFrame.getClass()));
    }

    public io.netty.handler.codec.http.websocketx.WebSocketFrame getUnderlyingFrame() {
        return this.underlyingFrame;
    }

    @Override
    public WebSocketFrame.Kind getKind() {
        return this.kind;
    }

    @Override
    public boolean isFinal() {
        return this.underlyingFrame.isFinalFragment();
    }

    @Override
    public ByteBuf getBinaryData() {
        return this.underlyingFrame.content();
    }

    @Override
    public String getTextData() {
        return this.underlyingFrame.content().toString(Charsets.UTF_8);
    }

    @Override
    public WebSocketFrame retain() {
        this.underlyingFrame.retain();
        return this;
    }

    @Override
    public WebSocketFrame retainedDuplicate() {
        return new GenericWebSocketFrame(this.underlyingFrame.retainedDuplicate(), this.kind);
    }

    @Override
    public WebSocketFrame release() {
        this.underlyingFrame.release();
        return this;
    }

    @Override
    public int refCnt() {
        return this.underlyingFrame.refCnt();
    }

    public static class GenericFactory
    implements WebSocketFrame.Factory {
        private final int maxFrameSize;

        public GenericFactory(int maxFrameSize) {
            this.maxFrameSize = maxFrameSize;
        }

        private ByteBuf checkPayload(ByteBuf payload, WebSocketFrame.Kind kind) throws WebSocketException {
            if (payload == null) {
                return Unpooled.EMPTY_BUFFER;
            }
            int payloadLength = payload.readableBytes();
            if (payloadLength > this.maxFrameSize) {
                throw new WebSocketException("Max frame size exceeded: " + this.maxFrameSize);
            }
            if ((kind == WebSocketFrame.Kind.PING || kind == WebSocketFrame.Kind.PONG || kind == WebSocketFrame.Kind.CLOSE) && payloadLength > 125) {
                throw new WebSocketException("Max control frame size exceeded: 125");
            }
            return payload;
        }

        @Override
        public WebSocketFrame binary(ByteBuf data, boolean finalFragment) throws WebSocketException {
            return new GenericWebSocketFrame((io.netty.handler.codec.http.websocketx.WebSocketFrame)new BinaryWebSocketFrame(finalFragment, 0, this.checkPayload(data, WebSocketFrame.Kind.BINARY)), WebSocketFrame.Kind.BINARY);
        }

        @Override
        public WebSocketFrame text(ByteBuf data, boolean finalFragment) throws WebSocketException {
            return new GenericWebSocketFrame((io.netty.handler.codec.http.websocketx.WebSocketFrame)new TextWebSocketFrame(finalFragment, 0, this.checkPayload(data, WebSocketFrame.Kind.TEXT)), WebSocketFrame.Kind.TEXT);
        }

        @Override
        public WebSocketFrame continuation(ByteBuf data, boolean finalFragment) throws WebSocketException {
            return new GenericWebSocketFrame((io.netty.handler.codec.http.websocketx.WebSocketFrame)new ContinuationWebSocketFrame(finalFragment, 0, this.checkPayload(data, WebSocketFrame.Kind.CONTINUATION)), WebSocketFrame.Kind.CONTINUATION);
        }

        @Override
        public WebSocketFrame ping(ByteBuf data) throws WebSocketException {
            return new GenericWebSocketFrame((io.netty.handler.codec.http.websocketx.WebSocketFrame)new PingWebSocketFrame(this.checkPayload(data, WebSocketFrame.Kind.PING)), WebSocketFrame.Kind.PING);
        }

        @Override
        public WebSocketFrame pong(ByteBuf data) throws WebSocketException {
            return new GenericWebSocketFrame((io.netty.handler.codec.http.websocketx.WebSocketFrame)new PongWebSocketFrame(this.checkPayload(data, WebSocketFrame.Kind.PONG)), WebSocketFrame.Kind.PONG);
        }

        public io.netty.handler.codec.http.websocketx.WebSocketFrame toUnderlyingWebSocketFrame(WebSocketFrame webSocketFrame) throws WebSocketException {
            if (webSocketFrame instanceof GenericWebSocketFrame) {
                return ((GenericWebSocketFrame)webSocketFrame).getUnderlyingFrame();
            }
            switch (webSocketFrame.getKind()) {
                case TEXT: {
                    String text = webSocketFrame.getTextData();
                    ByteBuf data = text == null || text.isEmpty() ? Unpooled.EMPTY_BUFFER : this.checkPayload(Unpooled.copiedBuffer((CharSequence)text, (Charset)CharsetUtil.UTF_8), WebSocketFrame.Kind.TEXT);
                    return new TextWebSocketFrame(webSocketFrame.isFinal(), 0, data);
                }
                case BINARY: {
                    return new BinaryWebSocketFrame(webSocketFrame.isFinal(), 0, this.checkPayload(webSocketFrame.getBinaryData(), WebSocketFrame.Kind.BINARY));
                }
                case CONTINUATION: {
                    return new ContinuationWebSocketFrame(webSocketFrame.isFinal(), 0, this.checkPayload(webSocketFrame.getBinaryData(), WebSocketFrame.Kind.CONTINUATION));
                }
                case PING: {
                    return new PingWebSocketFrame(this.checkPayload(webSocketFrame.getBinaryData(), WebSocketFrame.Kind.PING));
                }
                case PONG: {
                    return new PongWebSocketFrame(this.checkPayload(webSocketFrame.getBinaryData(), WebSocketFrame.Kind.PONG));
                }
            }
            throw new WebSocketException("Unsupported frame kind: " + String.valueOf((Object)webSocketFrame.getKind()));
        }
    }
}

