/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.netty;

import io.inverno.mod.http.base.internal.header.HeadersValidator;
import io.inverno.mod.http.base.internal.netty.LinkedHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;

public class ValidatingHttpHeadersFactory
implements HttpHeadersFactory {
    public static final HttpHeadersFactory VALIDATING_HEADERS_FACTORY = new DefaultValidatingHttpHeadersFactory();
    public static final HttpHeadersFactory NON_VALIDATING_HEADERS_FACTORY = new DefaultNonValidatingHttpHeadersFactory();
    private final HeadersValidator headersValidator;

    public ValidatingHttpHeadersFactory(HeadersValidator headersValidator) {
        this.headersValidator = headersValidator;
    }

    public HttpHeaders newHeaders() {
        return new LinkedHttpHeaders(this.headersValidator);
    }

    public HttpHeaders newEmptyHeaders() {
        return new LinkedHttpHeaders(this.headersValidator);
    }

    private static class DefaultValidatingHttpHeadersFactory
    implements HttpHeadersFactory {
        private DefaultValidatingHttpHeadersFactory() {
        }

        public HttpHeaders newHeaders() {
            return new LinkedHttpHeaders(HeadersValidator.DEFAULT_HTTP1X_HEADERS_VALIDATOR);
        }

        public HttpHeaders newEmptyHeaders() {
            return new LinkedHttpHeaders(HeadersValidator.DEFAULT_HTTP1X_HEADERS_VALIDATOR);
        }
    }

    private static class DefaultNonValidatingHttpHeadersFactory
    implements HttpHeadersFactory {
        private DefaultNonValidatingHttpHeadersFactory() {
        }

        public HttpHeaders newHeaders() {
            return new LinkedHttpHeaders(null);
        }

        public HttpHeaders newEmptyHeaders() {
            return new LinkedHttpHeaders(null);
        }
    }
}

