/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.netty;

import io.inverno.mod.http.base.internal.netty.FlatHttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;

public class FlatFullHttpRequest
extends FlatHttpRequest
implements FullHttpRequest {
    private final HttpHeaders trailingHeaders;

    public FlatFullHttpRequest(HttpVersion version, HttpMethod method, String uri, HttpHeaders headers, ByteBuf content, HttpHeaders trailingHeaders) {
        super(version, method, uri, headers, content);
        this.trailingHeaders = trailingHeaders;
    }

    @Override
    public FlatFullHttpRequest copy() {
        return this.replace(this.content.copy());
    }

    @Override
    public FlatFullHttpRequest duplicate() {
        return this.replace(this.content.duplicate());
    }

    @Override
    public FlatFullHttpRequest retainedDuplicate() {
        return this.replace(this.content.retainedDuplicate());
    }

    @Override
    public FlatFullHttpRequest replace(ByteBuf content) {
        return new FlatFullHttpRequest(this.version, this.method, this.uri, this.headers.copy(), content, this.trailingHeaders);
    }

    @Override
    public FlatFullHttpRequest retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public FlatFullHttpRequest retain() {
        super.retain();
        return this;
    }

    @Override
    public FlatFullHttpRequest touch() {
        super.touch();
        return this;
    }

    @Override
    public FlatFullHttpRequest touch(Object hint) {
        super.touch(hint);
        return this;
    }

    @Override
    public FlatFullHttpRequest setProtocolVersion(HttpVersion version) {
        super.setProtocolVersion(version);
        return this;
    }

    @Override
    public FlatFullHttpRequest setMethod(HttpMethod method) {
        super.setMethod(method);
        return this;
    }

    @Override
    public FlatFullHttpRequest setUri(String uri) {
        super.setUri(uri);
        return this;
    }

    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }
}

