/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.header;

import io.inverno.mod.http.base.internal.header.HeadersValidator;
import io.netty.handler.codec.http.HttpHeaderValidationUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.internal.PlatformDependent;

class DefaultHttp2HeadersValidator
implements HeadersValidator {
    DefaultHttp2HeadersValidator() {
    }

    @Override
    public void accept(CharSequence name, CharSequence value) {
        DefaultHttp2HeadersValidator.validateName(name);
        if (value != null) {
            this.validateValue(value);
        }
    }

    private static void validateName(CharSequence name) {
        if (name == null || name.length() == 0) {
            PlatformDependent.throwException((Throwable)Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"empty headers are not allowed [%s]", (Object[])new Object[]{name}));
        }
        if (Http2Headers.PseudoHeaderName.hasPseudoHeaderFormat((CharSequence)name)) {
            if (!Http2Headers.PseudoHeaderName.isPseudoHeader((CharSequence)name)) {
                PlatformDependent.throwException((Throwable)Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Invalid HTTP/2 pseudo-header '%s' encountered.", (Object[])new Object[]{name}));
            }
            return;
        }
        if (name instanceof AsciiString) {
            int index;
            try {
                index = ((AsciiString)name).forEachByte(b -> !AsciiString.isUpperCase((byte)b));
            }
            catch (Http2Exception e) {
                PlatformDependent.throwException((Throwable)e);
                return;
            }
            catch (Throwable t) {
                PlatformDependent.throwException((Throwable)Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (Throwable)t, (String)"unexpected error. invalid header name [%s]", (Object[])new Object[]{name}));
                return;
            }
            if (index != -1) {
                PlatformDependent.throwException((Throwable)Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"invalid header name [%s]", (Object[])new Object[]{name}));
            }
        } else {
            for (int i = 0; i < name.length(); ++i) {
                if (!AsciiString.isUpperCase((char)name.charAt(i))) continue;
                PlatformDependent.throwException((Throwable)Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"invalid header name [%s]", (Object[])new Object[]{name}));
            }
        }
    }

    private void validateValue(CharSequence value) {
        int index = HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)value);
        if (index != -1) {
            throw new IllegalArgumentException("a header value contains prohibited character 0x" + Integer.toHexString(value.charAt(index)) + " at index " + index + ".");
        }
    }
}

