/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.header;

import io.inverno.mod.http.base.internal.header.HeadersValidator;
import io.netty.handler.codec.http.HttpHeaderValidationUtil;

class DefaultHttp1xHeadersValidator
implements HeadersValidator {
    DefaultHttp1xHeadersValidator() {
    }

    @Override
    public void accept(CharSequence name, CharSequence value) {
        DefaultHttp1xHeadersValidator.validateName(name);
        if (value != null) {
            this.validateValue(value);
        }
    }

    private static void validateName(CharSequence name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("empty headers are not allowed [" + String.valueOf(name) + "]");
        }
        int index = HttpHeaderValidationUtil.validateToken((CharSequence)name);
        if (index != -1) {
            throw new IllegalArgumentException("a header name can only contain \"token\" characters, but found invalid character 0x" + Integer.toHexString(name.charAt(index)) + " at index " + index + " of header '" + String.valueOf(name) + "'.");
        }
    }

    private void validateValue(CharSequence value) {
        int index = HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)value);
        if (index != -1) {
            throw new IllegalArgumentException("a header value contains prohibited character 0x" + Integer.toHexString(value.charAt(index)) + " at index " + index + ".");
        }
    }
}

