/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.header;

import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.BeanSocket;
import io.inverno.mod.http.base.NotAcceptableException;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.header.ParameterizedHeader;
import io.inverno.mod.http.base.internal.header.ParameterizedHeaderCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class AcceptCodec
extends ParameterizedHeaderCodec<Accept, Accept.Builder> {
    @BeanSocket
    public AcceptCodec() {
        this(true);
    }

    public AcceptCodec(boolean allowMultiple) {
        super(Accept.Builder::new, Set.of("accept"), ';', ',', false, false, false, false, true, allowMultiple);
    }

    @Override
    public String encodeValue(Accept headerField) {
        return headerField.getMediaRanges().stream().map(range -> {
            StringBuilder result = new StringBuilder();
            result.append(range.getType()).append("/").append(range.getSubType());
            result.append(";q=").append(String.format("%.3f", Float.valueOf(range.getWeight())));
            Map<String, String> parameters = range.getParameters();
            if (!parameters.isEmpty()) {
                parameters.entrySet().stream().forEach(e -> result.append(this.parameterDelimiter).append((String)e.getKey()).append("=").append((String)e.getValue()));
            }
            return result.toString();
        }).collect(Collectors.joining(Character.toString(this.valueDelimiter)));
    }

    public static final class Accept
    extends ParameterizedHeader
    implements Headers.Accept {
        private List<Headers.Accept.MediaRange> ranges;

        public Accept(List<Headers.Accept.MediaRange> ranges) {
            super("accept", null, null, null);
            this.ranges = ranges != null && !ranges.isEmpty() ? ranges.stream().sorted(Headers.Accept.MediaRange.COMPARATOR).collect(Collectors.toList()) : List.of(new MediaRange("*/*", 1.0f, null));
        }

        private Accept(String headerName, String headerValue, List<Headers.Accept.MediaRange> ranges) {
            super(headerName, headerValue, null, null);
            this.ranges = ranges != null && !ranges.isEmpty() ? ranges.stream().sorted(Headers.Accept.MediaRange.COMPARATOR).collect(Collectors.toList()) : List.of(new MediaRange("*/*", 1.0f, null));
        }

        @Override
        public List<Headers.Accept.MediaRange> getMediaRanges() {
            return this.ranges;
        }

        public static class MediaRange
        implements Headers.Accept.MediaRange {
            private String mediaType;
            private String type;
            private String subType;
            private float weight;
            private Map<String, String> parameters;
            private int score;

            public MediaRange(String mediaType, float weight, Map<String, String> parameters) {
                this.setMediaType(mediaType);
                this.weight = (float)((int)(weight * 1000.0f)) / 1000.0f;
                this.parameters = parameters != null ? Collections.unmodifiableMap(parameters) : Map.of();
                this.score = Headers.Accept.MediaRange.super.getScore();
            }

            public MediaRange(String type, String subType, float weight, Map<String, String> parameters) {
                this.setType(type.toLowerCase());
                this.setSubType(subType.toLowerCase());
                this.weight = (float)((int)(weight * 1000.0f)) / 1000.0f;
                this.parameters = parameters != null ? Collections.unmodifiableMap(parameters) : Map.of();
                this.score = Headers.Accept.MediaRange.super.getScore();
            }

            @Override
            public String getMediaType() {
                if (this.mediaType == null) {
                    this.mediaType = this.type + "/" + this.subType;
                }
                return this.mediaType;
            }

            private void setMediaType(String mediaType) {
                this.mediaType = mediaType.toLowerCase();
                String[] splitMediaType = this.mediaType.split("/");
                if (splitMediaType.length == 2) {
                    this.setType(splitMediaType[0]);
                    this.setSubType(splitMediaType[1]);
                } else if (splitMediaType.length == 1) {
                    this.setType(splitMediaType[0]);
                    this.setSubType("*");
                } else {
                    throw new NotAcceptableException("Empty media type");
                }
            }

            @Override
            public String getType() {
                return this.type;
            }

            private void setType(String type) {
                if (!type.equals("*") && !HeaderService.isToken(type)) {
                    throw new NotAcceptableException("Invalid media Type: " + type);
                }
                this.type = type;
            }

            @Override
            public String getSubType() {
                return this.subType;
            }

            private void setSubType(String subType) {
                if (!subType.equals("*") && !HeaderService.isToken(subType)) {
                    throw new NotAcceptableException("Invalid media Type: " + this.type);
                }
                this.subType = subType;
            }

            @Override
            public float getWeight() {
                return this.weight;
            }

            @Override
            public int getScore() {
                return this.score;
            }

            @Override
            public Map<String, String> getParameters() {
                return this.parameters;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.mediaType == null ? 0 : this.mediaType.hashCode());
                result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
                result = 31 * result + Float.floatToIntBits(this.weight);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                MediaRange other = (MediaRange)obj;
                if (this.mediaType == null ? other.mediaType != null : !this.mediaType.equals(other.mediaType)) {
                    return false;
                }
                if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
                    return false;
                }
                return Float.floatToIntBits(this.weight) == Float.floatToIntBits(other.weight);
            }
        }

        public static final class Builder
        extends ParameterizedHeader.AbstractBuilder<Accept, Builder> {
            private List<Headers.Accept.MediaRange> ranges;
            private float weight = 1.0f;

            private void addCurrentRange() {
                if (this.parameterizedValue != null) {
                    if (this.ranges == null) {
                        this.ranges = new ArrayList<Headers.Accept.MediaRange>();
                    }
                    this.ranges.add(new MediaRange(this.parameterizedValue, this.weight, this.parameters));
                }
                this.parameters = null;
                this.weight = 1.0f;
            }

            @Override
            public Builder parameterizedValue(String parameterizedValue) {
                this.addCurrentRange();
                this.parameterizedValue = parameterizedValue;
                return this;
            }

            @Override
            public Builder parameter(String name, String value) {
                if (name.equals("q")) {
                    this.weight = Float.parseFloat(value);
                    if (this.weight == 0.0f) {
                        throw new NotAcceptableException("Invalid weight: " + this.weight);
                    }
                } else {
                    super.parameter(name, value);
                }
                return this;
            }

            @Override
            public Accept build() {
                this.addCurrentRange();
                return new Accept(this.headerName, this.headerValue, this.ranges);
            }
        }
    }
}

