/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.configuration.compiler.internal;

import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.QualifiedNameFormatException;
import io.inverno.core.compiler.spi.ReporterInfo;
import io.inverno.core.compiler.spi.plugin.CompilerPlugin;
import io.inverno.core.compiler.spi.plugin.PluginContext;
import io.inverno.core.compiler.spi.plugin.PluginExecution;
import io.inverno.core.compiler.spi.plugin.PluginExecutionException;
import io.inverno.mod.configuration.Configuration;
import io.inverno.mod.configuration.compiler.internal.ConfigurationLoaderClassGenerationContext;
import io.inverno.mod.configuration.compiler.internal.ConfigurationLoaderClassGenerator;
import io.inverno.mod.configuration.compiler.internal.GenericConfigurationInfo;
import io.inverno.mod.configuration.compiler.internal.GenericConfigurationPropertyInfo;
import io.inverno.mod.configuration.compiler.internal.GenericNestedConfigurationProperty;
import io.inverno.mod.configuration.compiler.spi.ConfigurationInfo;
import io.inverno.mod.configuration.compiler.spi.PropertyQualifiedName;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class ConfigurationCompilerPlugin
implements CompilerPlugin {
    private final ConfigurationLoaderClassGenerator configurationLoaderClassGenerator = new ConfigurationLoaderClassGenerator();
    private PluginContext pluginContext;
    private TypeMirror configurationAnnotationType;
    private boolean enabled = true;

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(Configuration.class.getCanonicalName());
    }

    public void init(PluginContext pluginContext) {
        this.pluginContext = pluginContext;
        TypeElement configurationAnnotationElement = this.pluginContext.getElementUtils().getTypeElement(Configuration.class.getCanonicalName());
        if (configurationAnnotationElement == null) {
            this.enabled = false;
            if (pluginContext.getOptions().isDebug()) {
                System.err.println("Plugin " + ConfigurationCompilerPlugin.class.getCanonicalName() + " disabled due to missing dependencies");
            }
            return;
        }
        this.configurationAnnotationType = configurationAnnotationElement.asType();
    }

    public boolean canExecute(ModuleElement moduleElement) {
        return this.enabled && this.pluginContext.getElementUtils().getTypeElement(moduleElement, Configuration.class.getCanonicalName()) != null;
    }

    /*
     * WARNING - void declaration
     */
    public void execute(PluginExecution execution) throws PluginExecutionException {
        for (TypeElement element : execution.getElementsAnnotatedWith(Configuration.class)) {
            BeanQualifiedName configurationQName;
            void var7_10;
            if (!TypeElement.class.isAssignableFrom(element.getClass())) {
                throw new PluginExecutionException("The specified element must be a TypeElement");
            }
            DeclaredType configurationType = (DeclaredType)element.asType();
            AnnotationMirror configurationAnnotation = null;
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!this.pluginContext.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), this.configurationAnnotationType)) continue;
                configurationAnnotation = annotationMirror;
                break;
            }
            if (configurationAnnotation == null) {
                throw new PluginExecutionException("The specified element is not annotated with " + Configuration.class.getSimpleName());
            }
            if (!this.pluginContext.getElementUtils().getModuleOf(element).getQualifiedName().toString().equals(execution.getModuleQualifiedName().toString())) {
                throw new PluginExecutionException("The specified element doesn't belong to module " + String.valueOf(execution.getModuleQualifiedName()));
            }
            ReporterInfo beanReporter = execution.getReporter((Element)element, configurationAnnotation);
            if (!element.getKind().equals((Object)ElementKind.INTERFACE)) {
                beanReporter.error("A configuration must be an interface");
                continue;
            }
            Object var7_9 = null;
            boolean generateBean = false;
            boolean overridable = false;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> value : this.pluginContext.getElementUtils().getElementValuesWithDefaults(configurationAnnotation).entrySet()) {
                switch (value.getKey().getSimpleName().toString()) {
                    case "name": {
                        String string = (String)value.getValue().getValue();
                        break;
                    }
                    case "generateBean": {
                        generateBean = Boolean.valueOf(value.getValue().getValue().toString());
                        break;
                    }
                    case "overridable": {
                        overridable = Boolean.valueOf(value.getValue().getValue().toString());
                    }
                }
            }
            if (var7_10 == null || var7_10.equals("")) {
                String string2 = element.getSimpleName().toString();
                string2 = Character.toLowerCase(string2.charAt(0)) + string2.substring(1);
            }
            try {
                void var7_14;
                configurationQName = new BeanQualifiedName(execution.getModuleQualifiedName(), (String)var7_14);
            }
            catch (QualifiedNameFormatException e) {
                beanReporter.error("Invalid bean qualified name: " + e.getMessage());
                continue;
            }
            List configurationProperties = this.pluginContext.getElementUtils().getAllMembers(element).stream().filter(el -> el.getKind().equals((Object)ElementKind.METHOD) && !this.pluginContext.getTypeUtils().isSameType(this.pluginContext.getElementUtils().getTypeElement(Object.class.getCanonicalName()).asType(), el.getEnclosingElement().asType())).map(el -> {
                ExecutableElement propertyMethod = (ExecutableElement)el;
                PropertyQualifiedName propertyQName = new PropertyQualifiedName(configurationQName, propertyMethod.getSimpleName().toString());
                ReporterInfo propertyReporter = execution.getReporter((Element)propertyMethod);
                boolean invalid = false;
                if (propertyMethod.getParameters().size() > 0) {
                    execution.getReporter((Element)propertyMethod.getParameters().get(0)).error("Configuration property must be declared as a no-argument method");
                    invalid = true;
                }
                if (propertyMethod.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                    propertyReporter.error("Configuration property must be declared as a non-void method");
                    invalid = true;
                }
                if (invalid) {
                    return null;
                }
                if (this.isNestedConfiguration(propertyMethod, execution.getModuleQualifiedName())) {
                    return new GenericNestedConfigurationProperty(propertyQName, propertyReporter, propertyMethod, this.extractNestedConfigurationInfo(propertyReporter, propertyQName, (TypeElement)this.pluginContext.getTypeUtils().asElement(propertyMethod.getReturnType())));
                }
                return new GenericConfigurationPropertyInfo(propertyQName, propertyReporter, propertyMethod);
            }).filter(Objects::nonNull).collect(Collectors.toList());
            GenericConfigurationInfo configurationInfo = new GenericConfigurationInfo(configurationQName, beanReporter, configurationType, configurationProperties, generateBean, overridable);
            try {
                execution.createSourceFile(configurationInfo.getType().toString() + "Loader", new Element[]{element}, () -> configurationInfo.accept(this.configurationLoaderClassGenerator, new ConfigurationLoaderClassGenerationContext(this.pluginContext.getTypeUtils(), this.pluginContext.getElementUtils(), ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_LOADER_CLASS)).toString());
            }
            catch (IOException e) {
                throw new PluginExecutionException("Unable to generate configuration loader class " + configurationInfo.getType().toString() + "Loader", (Throwable)e);
            }
        }
    }

    private ConfigurationInfo extractNestedConfigurationInfo(ReporterInfo rootPropertyReporter, PropertyQualifiedName nestedPropertyName, TypeElement nestedTypeElement) {
        List configurationProperties = this.pluginContext.getElementUtils().getAllMembers(nestedTypeElement).stream().filter(el -> el.getKind().equals((Object)ElementKind.METHOD) && !this.pluginContext.getTypeUtils().isSameType(this.pluginContext.getElementUtils().getTypeElement(Object.class.getCanonicalName()).asType(), el.getEnclosingElement().asType())).map(el -> {
            ExecutableElement propertyMethod = (ExecutableElement)el;
            PropertyQualifiedName propertyQName = new PropertyQualifiedName(nestedPropertyName, propertyMethod.getSimpleName().toString());
            boolean invalid = false;
            if (propertyMethod.getParameters().size() > 0) {
                rootPropertyReporter.warning("Ignoring invalid nested property " + propertyQName.getBeanName() + " which should be defined as a no-argument method");
                invalid = true;
            }
            if (propertyMethod.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                rootPropertyReporter.warning("Ignoring invalid nested property " + propertyQName.getBeanName() + " which should be defined as a non-void method");
                invalid = true;
            }
            if (invalid) {
                return null;
            }
            if (this.isNestedConfiguration(propertyMethod, nestedPropertyName.getModuleQName())) {
                return new GenericNestedConfigurationProperty(propertyQName, rootPropertyReporter, propertyMethod, this.extractNestedConfigurationInfo(rootPropertyReporter, propertyQName, (TypeElement)this.pluginContext.getTypeUtils().asElement(propertyMethod.getReturnType())));
            }
            return new GenericConfigurationPropertyInfo(propertyQName, rootPropertyReporter, propertyMethod);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return new GenericConfigurationInfo(nestedPropertyName, rootPropertyReporter, (DeclaredType)nestedTypeElement.asType(), configurationProperties);
    }

    private boolean isNestedConfiguration(ExecutableElement propertyMethod, ModuleQualifiedName module) {
        TypeMirror type = propertyMethod.getReturnType();
        if (type.getKind().equals((Object)TypeKind.DECLARED)) {
            TypeElement typeElement = (TypeElement)this.pluginContext.getTypeUtils().asElement(type);
            return typeElement.getAnnotationMirrors().stream().anyMatch(annotation -> this.pluginContext.getTypeUtils().isSameType(annotation.getAnnotationType(), this.configurationAnnotationType));
        }
        return false;
    }
}

