/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.configuration.compiler.internal;

import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.NestedBean;
import io.inverno.core.annotation.Overridable;
import io.inverno.core.annotation.Wrapper;
import io.inverno.mod.configuration.ConfigurationKey;
import io.inverno.mod.configuration.ConfigurationLoaderSupport;
import io.inverno.mod.configuration.ConfigurationSource;
import io.inverno.mod.configuration.compiler.internal.ConfigurationLoaderClassGenerationContext;
import io.inverno.mod.configuration.compiler.spi.ConfigurationInfo;
import io.inverno.mod.configuration.compiler.spi.ConfigurationInfoVisitor;
import io.inverno.mod.configuration.compiler.spi.ConfigurationPropertyInfo;
import io.inverno.mod.configuration.compiler.spi.NestedConfigurationPropertyInfo;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;

class ConfigurationLoaderClassGenerator
implements ConfigurationInfoVisitor<StringBuilder, ConfigurationLoaderClassGenerationContext> {
    private static final String CONFIGURATION_INNER_CLASS = "Configuration";
    private static final String CONFIGURATOR_INNER_CLASS = "Configurator";
    private static final String CONFIGURATION_BEAN_INNER_CLASS = "Bean";

    ConfigurationLoaderClassGenerator() {
    }

    @Override
    public StringBuilder visit(ConfigurationInfo configurationInfo, ConfigurationLoaderClassGenerationContext context) {
        String configurationClassName = configurationInfo.getType().toString();
        String packageName = configurationClassName.lastIndexOf(".") != -1 ? configurationClassName.substring(0, configurationClassName.lastIndexOf(".")) : "";
        configurationClassName = configurationClassName.substring(packageName.length() + 1);
        StringBuilder configurationLoaderClassName = new StringBuilder(configurationClassName).append("Loader");
        if (context.getMode() == ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_LOADER_CLASS) {
            TypeMirror configurationLoaderSupportType = context.getTypeUtils().erasure(context.getElementUtils().getTypeElement(ConfigurationLoaderSupport.class.getCanonicalName()).asType());
            TypeMirror consumerType = context.getTypeUtils().erasure(context.getElementUtils().getTypeElement(Consumer.class.getCanonicalName()).asType());
            context.addImport(CONFIGURATION_INNER_CLASS, configurationClassName + "Loader.Configuration");
            context.addImport(CONFIGURATOR_INNER_CLASS, configurationClassName + "Loader.Configurator");
            context.addImport(CONFIGURATION_BEAN_INNER_CLASS, configurationClassName + "Loader.Bean");
            StringBuilder configurationLoader_constructor = new StringBuilder(context.indent(1)).append("public ").append((CharSequence)configurationLoaderClassName).append("() {\n");
            configurationLoader_constructor.append(context.indent(2)).append("super(\n");
            configurationLoader_constructor.append(context.indent(3)).append("new String[] {\n");
            configurationLoader_constructor.append((CharSequence)this.visit(configurationInfo, context.withIndentDepth(4).withMode(ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_PROPERTIES))).append("\n");
            configurationLoader_constructor.append(context.indent(3)).append("},\n");
            context.getResultIndex().set(0);
            configurationLoader_constructor.append(context.indent(3)).append("results -> ");
            configurationLoader_constructor.append((CharSequence)this.visit(configurationInfo, context.withIndentDepth(3).withMode(ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_CONFIGURER)));
            configurationLoader_constructor.append(",\n");
            configurationLoader_constructor.append(context.indent(3)).append((CharSequence)configurationLoaderClassName).append("::load").append(",\n");
            configurationLoader_constructor.append(context.indent(3)).append((CharSequence)configurationLoaderClassName).append(".").append(CONFIGURATION_INNER_CLASS).append("::new\n");
            configurationLoader_constructor.append(context.indent(2)).append(");\n");
            configurationLoader_constructor.append(context.indent(1)).append("}");
            StringBuilder configurationLoader_load_method = new StringBuilder(context.indent(1)).append("public static ").append(context.getTypeName(configurationInfo.getType())).append(" load(").append(context.getTypeName(consumerType)).append("<").append((CharSequence)configurationLoaderClassName).append(".").append(CONFIGURATOR_INNER_CLASS).append("> configurer) {\n");
            configurationLoader_load_method.append(context.indent(2)).append((CharSequence)configurationLoaderClassName).append(".").append(CONFIGURATOR_INNER_CLASS).append(" configurator = new ").append((CharSequence)configurationLoaderClassName).append(".").append(CONFIGURATOR_INNER_CLASS).append("();\n");
            configurationLoader_load_method.append(context.indent(2)).append("configurer.accept(configurator);\n");
            configurationLoader_load_method.append(context.indent(2)).append("return new ").append((CharSequence)configurationLoaderClassName).append(".").append(CONFIGURATION_INNER_CLASS).append("(");
            configurationLoader_load_method.append((CharSequence)Arrays.stream(configurationInfo.getProperties()).map(propertyInfo -> "configurator." + propertyInfo.getQualifiedName().getPropertyName()).collect(context.joining(", ")));
            configurationLoader_load_method.append(");\n");
            configurationLoader_load_method.append(context.indent(1)).append("}");
            StringBuilder configurationLoader_configuration_class = this.visit(configurationInfo, context.withIndentDepth(1).withMode(ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_IMPL_CLASS));
            StringBuilder configurationLoader_configurator_class = this.visit(configurationInfo, context.withIndentDepth(1).withMode(ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_CONFIGURATOR_CLASS));
            StringBuilder configurationLoader_class = new StringBuilder().append(context.indent(0)).append("public final class ").append((CharSequence)configurationLoaderClassName).append(" extends ").append(context.getTypeName(configurationLoaderSupportType)).append("<").append(context.getTypeName(configurationInfo.getType())).append(", ").append((CharSequence)configurationLoaderClassName).append(".").append(CONFIGURATOR_INNER_CLASS).append(", ").append((CharSequence)configurationLoaderClassName).append("> {\n\n");
            configurationLoader_class.append((CharSequence)configurationLoader_constructor).append("\n\n");
            configurationLoader_class.append((CharSequence)configurationLoader_load_method).append("\n\n");
            configurationLoader_class.append((CharSequence)configurationLoader_configuration_class).append("\n\n");
            configurationLoader_class.append((CharSequence)configurationLoader_configurator_class).append("\n");
            if (configurationInfo.isGenerateBean()) {
                configurationLoader_class.append("\n");
                configurationLoader_class.append((CharSequence)this.visit(configurationInfo, context.withIndentDepth(1).withMode(ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_BEAN_CLASS))).append("\n");
            }
            configurationLoader_class.append(context.indent(0)).append("}");
            context.removeImport(CONFIGURATION_INNER_CLASS);
            context.removeImport(CONFIGURATOR_INNER_CLASS);
            context.removeImport(CONFIGURATION_BEAN_INNER_CLASS);
            configurationLoader_class.insert(0, "\n\n").insert(0, (CharSequence)context.getImports().stream().sorted().filter(i -> i.lastIndexOf(".") > 0 && !i.substring(0, i.lastIndexOf(".")).equals(packageName)).map(i -> new StringBuilder().append("import ").append((String)i).append(";")).collect(context.joining("\n")));
            if (!packageName.equals("")) {
                configurationLoader_class.insert(0, ";\n\n").insert(0, packageName).insert(0, "package ");
            }
            return configurationLoader_class;
        }
        if (context.getMode() == ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_PROPERTIES) {
            return (StringBuilder)Arrays.stream(configurationInfo.getProperties()).map(propertyInfo -> this.visit((ConfigurationPropertyInfo)propertyInfo, context.withConfiguration(configurationInfo).withMode(ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_PROPERTY_NAME))).collect(context.joining(",\n"));
        }
        if (context.getMode() == ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_CONFIGURER) {
            StringBuilder configurer = new StringBuilder().append(configurationInfo.getQualifiedName().normalize()).append("_configurator -> {\n");
            configurer.append((CharSequence)Arrays.stream(configurationInfo.getProperties()).map(propertyInfo -> this.visit((ConfigurationPropertyInfo)propertyInfo, ((ConfigurationLoaderClassGenerationContext)context.withIndentDepthAdd(1)).withConfiguration(configurationInfo).withMode(ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_PROPERTY_CONFIGURER))).collect(context.joining("\n"))).append("\n");
            configurer.append(context.indent(0)).append("}");
            return configurer;
        }
        if (context.getMode() == ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_IMPL_CLASS) {
            StringBuilder configurationImpl_field_properties = (StringBuilder)Arrays.stream(configurationInfo.getProperties()).map(propertyInfo -> this.visit((ConfigurationPropertyInfo)propertyInfo, context.withConfiguration(configurationInfo).withMode(ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_IMPL_PROPERTY_FIELD))).collect(context.joining("\n"));
            StringBuilder configurationImpl_default_constructor = new StringBuilder().append(context.indent(1)).append("private ").append(CONFIGURATION_INNER_CLASS).append("() {}");
            StringBuilder configurationImpl_constructor = new StringBuilder();
            if (configurationInfo.getProperties().length > 0) {
                configurationImpl_constructor.append(context.indent(1)).append("public ").append(CONFIGURATION_INNER_CLASS).append("(");
                configurationImpl_constructor.append((CharSequence)Arrays.stream(configurationInfo.getProperties()).map(propertyInfo -> this.visit((ConfigurationPropertyInfo)propertyInfo, context.withMode(ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_IMPL_PROPERTY_PARAMETER))).collect(context.joining(", ")));
                configurationImpl_constructor.append(") {\n");
                configurationImpl_constructor.append((CharSequence)Arrays.stream(configurationInfo.getProperties()).map(propertyInfo -> this.visit((ConfigurationPropertyInfo)propertyInfo, context.withMode(ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_IMPL_PROPERTY_ASSIGNMENT))).collect(context.joining("\n")));
                configurationImpl_constructor.append("\n");
                configurationImpl_constructor.append(context.indent(1)).append("}");
            }
            StringBuilder configurationImpl_property_accessors = (StringBuilder)Arrays.stream(configurationInfo.getProperties()).map(propertyInfo -> this.visit((ConfigurationPropertyInfo)propertyInfo, context.withMode(ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_IMPL_PROPERTY_ACCESSOR))).collect(context.joining("\n"));
            StringBuilder configurationImplClass = new StringBuilder().append(context.indent(0)).append("private static final class ").append(CONFIGURATION_INNER_CLASS).append(" implements ").append(context.getTypeName(configurationInfo.getType())).append(" {\n\n");
            configurationImplClass.append((CharSequence)configurationImpl_field_properties).append("\n\n");
            configurationImplClass.append((CharSequence)configurationImpl_default_constructor).append("\n\n");
            if (configurationImpl_constructor.length() > 0) {
                configurationImplClass.append((CharSequence)configurationImpl_constructor).append("\n\n");
            }
            configurationImplClass.append((CharSequence)configurationImpl_property_accessors);
            configurationImplClass.append(context.indent(0)).append("}");
            return configurationImplClass;
        }
        if (context.getMode() == ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_CONFIGURATOR_CLASS) {
            StringBuilder configurationConfigurator_field_properties = (StringBuilder)Arrays.stream(configurationInfo.getProperties()).map(propertyInfo -> this.visit((ConfigurationPropertyInfo)propertyInfo, context.withMode(ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_CONFIGURATOR_PROPERTY_FIELD))).collect(context.joining("\n"));
            StringBuilder configurationConfigurator_default_constructor = new StringBuilder().append(context.indent(1)).append("private ").append(CONFIGURATOR_INNER_CLASS).append("() {}");
            StringBuilder configurationConfigurator_property_injectors = (StringBuilder)Arrays.stream(configurationInfo.getProperties()).map(propertyInfo -> this.visit((ConfigurationPropertyInfo)propertyInfo, context.withMode(ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_CONFIGURATOR_PROPERTY_INJECTOR))).collect(context.joining("\n"));
            StringBuilder configurationConfiguratorClass = new StringBuilder().append(context.indent(0)).append("public static final class ").append(CONFIGURATOR_INNER_CLASS).append(" {\n\n");
            configurationConfiguratorClass.append((CharSequence)configurationConfigurator_field_properties).append("\n\n");
            configurationConfiguratorClass.append((CharSequence)configurationConfigurator_default_constructor).append("\n\n");
            configurationConfiguratorClass.append((CharSequence)configurationConfigurator_property_injectors);
            configurationConfiguratorClass.append(context.indent(0)).append("}");
            return configurationConfiguratorClass;
        }
        if (context.getMode() == ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_BEAN_CLASS) {
            TypeMirror beanAnnotationType = context.getElementUtils().getTypeElement(Bean.class.getCanonicalName()).asType();
            TypeMirror wrapperAnnotationType = context.getElementUtils().getTypeElement(Wrapper.class.getCanonicalName()).asType();
            TypeMirror configurationLoaderSupportType = context.getTypeUtils().erasure(context.getElementUtils().getTypeElement(ConfigurationLoaderSupport.class.getCanonicalName()).asType());
            DeclaredType configurationSupplierType = context.getTypeUtils().getDeclaredType(context.getElementUtils().getTypeElement(Supplier.class.getCanonicalName()), configurationInfo.getType());
            TypeMirror consumerType = context.getTypeUtils().erasure(context.getElementUtils().getTypeElement(Consumer.class.getCanonicalName()).asType());
            WildcardType unknownWildcardType = context.getTypeUtils().getWildcardType(null, null);
            DeclaredType configurationSourceType = context.getTypeUtils().getDeclaredType(context.getElementUtils().getTypeElement(ConfigurationSource.class.getCanonicalName()), unknownWildcardType, unknownWildcardType, unknownWildcardType);
            TypeMirror parameterType = context.getElementUtils().getTypeElement(ConfigurationKey.Parameter.class.getCanonicalName()).asType();
            StringBuilder configurationBeanClass = new StringBuilder().append(context.indent(0)).append("@").append(context.getTypeName(beanAnnotationType)).append("(name = \"").append(configurationInfo.getQualifiedName().getBeanName()).append("\")\n");
            configurationBeanClass.append(context.indent(0)).append("@").append(context.getTypeName(wrapperAnnotationType)).append("\n");
            if (configurationInfo.isOverridable()) {
                TypeMirror overridableAnnotationType = context.getElementUtils().getTypeElement(Overridable.class.getCanonicalName()).asType();
                configurationBeanClass.append(context.indent(0)).append("@").append(context.getTypeName(overridableAnnotationType)).append("\n");
            }
            configurationBeanClass.append(context.indent(0)).append("public static final class ").append(CONFIGURATION_BEAN_INNER_CLASS).append(" extends ").append(context.getTypeName(configurationLoaderSupportType)).append(".ConfigurationBeanSupport<").append(context.getTypeName(configurationInfo.getType())).append(", ").append((CharSequence)configurationLoaderClassName).append(".").append(CONFIGURATOR_INNER_CLASS).append(", ").append((CharSequence)configurationLoaderClassName).append("> implements ").append(context.getTypeName(configurationSupplierType)).append(" {\n\n");
            configurationBeanClass.append(context.indent(1)).append("public ").append(CONFIGURATION_BEAN_INNER_CLASS).append("() {\n");
            configurationBeanClass.append(context.indent(2)).append("super(new ").append((CharSequence)configurationLoaderClassName).append("());\n");
            configurationBeanClass.append(context.indent(1)).append("}\n\n");
            configurationBeanClass.append(context.indent(1)).append("public void setConfigurationSource(").append(context.getTypeName(configurationSourceType)).append(" source) {\n");
            configurationBeanClass.append(context.indent(2)).append("this.loader.withSource(source);\n");
            configurationBeanClass.append(context.indent(1)).append("}\n\n");
            configurationBeanClass.append(context.indent(1)).append("public void setParameters(").append(context.getTypeName(parameterType)).append("[] parameters) {\n");
            configurationBeanClass.append(context.indent(2)).append("this.loader.withParameters(parameters);\n");
            configurationBeanClass.append(context.indent(1)).append("}\n\n");
            configurationBeanClass.append(context.indent(1)).append("public void setConfigurer(").append(context.getTypeName(consumerType)).append("<").append((CharSequence)configurationLoaderClassName).append(".").append(CONFIGURATOR_INNER_CLASS).append("> configurer) {\n");
            configurationBeanClass.append(context.indent(2)).append("this.loader.withConfigurer(configurer);\n");
            configurationBeanClass.append(context.indent(1)).append("}\n");
            configurationBeanClass.append(context.indent(0)).append("}");
            return configurationBeanClass;
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(ConfigurationPropertyInfo configurationPropertyInfo, ConfigurationLoaderClassGenerationContext context) {
        block23: {
            StringBuilder result;
            block25: {
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                block24: {
                                    if (context.getMode() == ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_IMPL_PROPERTY_FIELD) {
                                        StringBuilder result2 = new StringBuilder().append(context.indent(1)).append("private ").append(context.getTypeName(configurationPropertyInfo.getType())).append(" ").append(configurationPropertyInfo.getQualifiedName().getPropertyName());
                                        if (configurationPropertyInfo.isDefault()) {
                                            result2.append(" = ").append(context.getTypeName(context.getConfiguration().getType())).append(".super.").append(configurationPropertyInfo.getQualifiedName().getPropertyName()).append("()");
                                        } else if (configurationPropertyInfo instanceof NestedConfigurationPropertyInfo) {
                                            result2.append(" = ").append(context.getTypeName(((NestedConfigurationPropertyInfo)configurationPropertyInfo).getConfiguration().getType())).append("Loader.load(configurator -> {})");
                                        }
                                        result2.append(";");
                                        return result2;
                                    }
                                    if (context.getMode() == ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_IMPL_PROPERTY_PARAMETER) {
                                        TypeMirror boxedType = configurationPropertyInfo.getType() instanceof PrimitiveType ? context.getTypeUtils().boxedClass((PrimitiveType)configurationPropertyInfo.getType()).asType() : configurationPropertyInfo.getType();
                                        return new StringBuilder().append(context.getTypeName(context.getTypeUtils().getDeclaredType(context.getElementUtils().getTypeElement(Supplier.class.getCanonicalName()), boxedType))).append(" ").append(configurationPropertyInfo.getQualifiedName().getPropertyName());
                                    }
                                    if (context.getMode() == ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_IMPL_PROPERTY_ASSIGNMENT) {
                                        TypeMirror optionalType = context.getTypeUtils().erasure(context.getElementUtils().getTypeElement(Optional.class.getCanonicalName()).asType());
                                        return new StringBuilder().append(context.indent(2)).append(context.getTypeName(optionalType)).append(".ofNullable(").append(configurationPropertyInfo.getQualifiedName().getPropertyName()).append(").ifPresent(s -> this.").append(configurationPropertyInfo.getQualifiedName().getPropertyName()).append(" = s.get());");
                                    }
                                    if (context.getMode() == ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_IMPL_PROPERTY_ACCESSOR) {
                                        StringBuilder result3 = new StringBuilder();
                                        if (configurationPropertyInfo instanceof NestedConfigurationPropertyInfo) {
                                            TypeMirror nestedAnnotationType = context.getElementUtils().getTypeElement(NestedBean.class.getCanonicalName()).asType();
                                            result3.append(context.indent(1)).append("@").append(context.getTypeName(nestedAnnotationType)).append("\n");
                                        }
                                        result3.append(context.indent(1)).append("public ").append(context.getTypeName(configurationPropertyInfo.getType())).append(" ").append(configurationPropertyInfo.getQualifiedName().getPropertyName()).append("() {\n");
                                        result3.append(context.indent(2)).append(" return this.").append(configurationPropertyInfo.getQualifiedName().getPropertyName()).append(";\n");
                                        result3.append(context.indent(1)).append("}\n");
                                        return result3;
                                    }
                                    if (context.getMode() == ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_CONFIGURATOR_PROPERTY_FIELD) {
                                        TypeMirror boxedType = configurationPropertyInfo.getType() instanceof PrimitiveType ? context.getTypeUtils().boxedClass((PrimitiveType)configurationPropertyInfo.getType()).asType() : configurationPropertyInfo.getType();
                                        return new StringBuilder().append(context.indent(1)).append("private ").append(context.getTypeName(context.getTypeUtils().getDeclaredType(context.getElementUtils().getTypeElement(Supplier.class.getCanonicalName()), boxedType))).append(" ").append(configurationPropertyInfo.getQualifiedName().getPropertyName()).append(";");
                                    }
                                    if (context.getMode() == ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_CONFIGURATOR_PROPERTY_INJECTOR) {
                                        StringBuilder result4 = new StringBuilder().append(context.indent(1)).append("public ").append(CONFIGURATOR_INNER_CLASS).append(" ").append(configurationPropertyInfo.getQualifiedName().getPropertyName()).append("(").append(context.getTypeName(configurationPropertyInfo.getType())).append(" ").append(configurationPropertyInfo.getQualifiedName().getPropertyName()).append(") {\n");
                                        result4.append(context.indent(2)).append("this.").append(configurationPropertyInfo.getQualifiedName().getPropertyName()).append(" = () -> ").append(configurationPropertyInfo.getQualifiedName().getPropertyName()).append(";\n");
                                        result4.append(context.indent(2)).append("return this;\n");
                                        result4.append(context.indent(1)).append("}\n");
                                        if (configurationPropertyInfo instanceof NestedConfigurationPropertyInfo) {
                                            result4.append("\n").append((CharSequence)this.visit((NestedConfigurationPropertyInfo)configurationPropertyInfo, context));
                                        }
                                        return result4;
                                    }
                                    if (configurationPropertyInfo instanceof NestedConfigurationPropertyInfo) {
                                        return this.visit((NestedConfigurationPropertyInfo)configurationPropertyInfo, context);
                                    }
                                    if (context.getMode() == ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_PROPERTY_NAME) {
                                        return new StringBuilder().append(context.indent(0)).append("\"").append(context.getConfiguration().getQualifiedName().getModuleQName()).append(".").append(configurationPropertyInfo.getQualifiedName().getBeanName()).append("\"");
                                    }
                                    if (context.getMode() != ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_PROPERTY_CONFIGURER) break block23;
                                    result = new StringBuilder().append(context.indent(0)).append("results.get(").append(context.getResultIndex().getAndIncrement()).append(").getResult().ifPresent(property -> ").append(context.getConfiguration().getQualifiedName().normalize()).append("_configurator.").append(configurationPropertyInfo.getQualifiedName().getPropertyName()).append("(property.");
                                    if (configurationPropertyInfo.getType().getKind() != TypeKind.ARRAY) break block24;
                                    result.append("asArrayOf(").append(context.getTypeName(((ArrayType)configurationPropertyInfo.getType()).getComponentType())).append(".class).orElse(null)");
                                    break block25;
                                }
                                if (!context.getTypeUtils().isSameType(context.getCollectionType(), context.getTypeUtils().erasure(configurationPropertyInfo.getType()))) break block26;
                                result.append("asListOf(").append(context.getTypeName(((DeclaredType)configurationPropertyInfo.getType()).getTypeArguments().get(0))).append(".class).orElse(null)");
                                break block25;
                            }
                            if (!context.getTypeUtils().isSameType(context.getListType(), context.getTypeUtils().erasure(configurationPropertyInfo.getType()))) break block27;
                            result.append("asListOf(").append(context.getTypeName(((DeclaredType)configurationPropertyInfo.getType()).getTypeArguments().get(0))).append(".class).orElse(null)");
                            break block25;
                        }
                        if (!context.getTypeUtils().isSameType(context.getSetType(), context.getTypeUtils().erasure(configurationPropertyInfo.getType()))) break block28;
                        result.append("asSetOf(").append(context.getTypeName(((DeclaredType)configurationPropertyInfo.getType()).getTypeArguments().get(0))).append(".class).orElse(null)");
                        break block25;
                    }
                    if (!(configurationPropertyInfo.getType() instanceof PrimitiveType)) break block29;
                    switch (configurationPropertyInfo.getType().getKind()) {
                        case BOOLEAN: {
                            result.append("asBoolean().orElseGet(() -> (new boolean[1])[0])");
                            break block25;
                        }
                        case BYTE: {
                            result.append("asByte().orElseGet(() -> (new byte[1])[0])");
                            break block25;
                        }
                        case SHORT: {
                            result.append("asShort().orElseGet(() -> (new short[1])[0])");
                            break block25;
                        }
                        case INT: {
                            result.append("asInteger().orElseGet(() -> (new int[1])[0])");
                            break block25;
                        }
                        case LONG: {
                            result.append("asLong().orElseGet(() -> (new long[1])[0])");
                            break block25;
                        }
                        case CHAR: {
                            result.append("asCharacter().orElseGet(() -> (new char[1])[0])");
                            break block25;
                        }
                        case FLOAT: {
                            result.append("asFloat().orElseGet(() -> (new float[1])[0])");
                            break block25;
                        }
                        case DOUBLE: {
                            result.append("asDouble().orElseGet(() -> (new double[1])[0])");
                            break block25;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported primitive type: " + configurationPropertyInfo.getType());
                        }
                    }
                }
                result.append("as(").append(context.getTypeName(configurationPropertyInfo.getType())).append(".class).orElse(null)");
            }
            result.append("));");
            return result;
        }
        return new StringBuilder();
    }

    @Override
    public StringBuilder visit(NestedConfigurationPropertyInfo nestedConfigurationPropertyInfo, ConfigurationLoaderClassGenerationContext context) {
        if (context.getMode() == ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_PROPERTY_NAME) {
            return this.visit(nestedConfigurationPropertyInfo.getConfiguration(), context.withMode(ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_PROPERTIES));
        }
        if (context.getMode() == ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_PROPERTY_CONFIGURER) {
            StringBuilder result = new StringBuilder().append(context.indent(0)).append(context.getConfiguration().getQualifiedName().normalize()).append("_configurator.").append(nestedConfigurationPropertyInfo.getQualifiedName().getPropertyName()).append("(");
            result.append((CharSequence)this.visit(nestedConfigurationPropertyInfo.getConfiguration(), context.withMode(ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_CONFIGURER)));
            result.append(");");
            return result;
        }
        if (context.getMode() == ConfigurationLoaderClassGenerationContext.GenerationMode.CONFIGURATION_CONFIGURATOR_PROPERTY_INJECTOR) {
            TypeMirror consumerType = context.getTypeUtils().erasure(context.getElementUtils().getTypeElement(Consumer.class.getCanonicalName()).asType());
            TypeMirror nestedConfigurationLoaderType = context.getElementUtils().getTypeElement(nestedConfigurationPropertyInfo.getConfiguration().getType().toString() + "Loader").asType();
            StringBuilder result = new StringBuilder().append(context.indent(1)).append("public ").append(CONFIGURATOR_INNER_CLASS).append(" ").append(nestedConfigurationPropertyInfo.getQualifiedName().getPropertyName()).append("(").append(context.getTypeName(consumerType)).append("<").append(context.getTypeName(nestedConfigurationLoaderType)).append(".").append(CONFIGURATOR_INNER_CLASS).append("> ").append(nestedConfigurationPropertyInfo.getQualifiedName().getPropertyName()).append("_configurer) {\n");
            result.append(context.indent(2)).append("this.").append(nestedConfigurationPropertyInfo.getQualifiedName().getPropertyName()).append(" = () -> ").append(context.getTypeName(nestedConfigurationLoaderType)).append(".load(").append(nestedConfigurationPropertyInfo.getQualifiedName().getPropertyName()).append("_configurer);\n");
            result.append(context.indent(2)).append("return this;\n");
            result.append(context.indent(1)).append("}\n");
            return result;
        }
        return new StringBuilder();
    }
}

