/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.configuration.compiler.internal;

import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.support.AbstractSourceGenerationContext;
import io.inverno.mod.configuration.compiler.spi.ConfigurationInfo;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class ConfigurationLoaderClassGenerationContext
extends AbstractSourceGenerationContext<ConfigurationLoaderClassGenerationContext, GenerationMode> {
    private TypeMirror collectionType;
    private TypeMirror listType;
    private TypeMirror setType;
    private ConfigurationInfo configuration;
    private AtomicInteger resultIndex;

    public ConfigurationLoaderClassGenerationContext(Types typeUtils, Elements elementUtils, GenerationMode mode) {
        super(typeUtils, elementUtils, (Enum)mode);
        this.resultIndex = new AtomicInteger();
        this.collectionType = this.getTypeUtils().erasure(this.getElementUtils().getTypeElement(Collection.class.getCanonicalName()).asType());
        this.setType = this.getTypeUtils().erasure(this.getElementUtils().getTypeElement(Set.class.getCanonicalName()).asType());
        this.listType = this.getTypeUtils().erasure(this.getElementUtils().getTypeElement(List.class.getCanonicalName()).asType());
    }

    private ConfigurationLoaderClassGenerationContext(ConfigurationLoaderClassGenerationContext parentGeneration) {
        super((AbstractSourceGenerationContext)parentGeneration);
        this.configuration = parentGeneration.configuration;
        this.resultIndex = parentGeneration.resultIndex;
    }

    public ConfigurationLoaderClassGenerationContext withMode(GenerationMode mode) {
        ConfigurationLoaderClassGenerationContext context = new ConfigurationLoaderClassGenerationContext(this);
        context.mode = mode;
        return context;
    }

    public ConfigurationLoaderClassGenerationContext withIndentDepth(int indentDepth) {
        ConfigurationLoaderClassGenerationContext context = new ConfigurationLoaderClassGenerationContext(this);
        context.indentDepth = indentDepth;
        return context;
    }

    public ConfigurationLoaderClassGenerationContext withModule(ModuleQualifiedName moduleQualifiedName) {
        ConfigurationLoaderClassGenerationContext context = new ConfigurationLoaderClassGenerationContext(this);
        context.moduleQualifiedName = moduleQualifiedName;
        return context;
    }

    public ConfigurationLoaderClassGenerationContext withConfiguration(ConfigurationInfo configuration) {
        ConfigurationLoaderClassGenerationContext context = new ConfigurationLoaderClassGenerationContext(this);
        context.configuration = configuration;
        return context;
    }

    public ConfigurationInfo getConfiguration() {
        return this.configuration;
    }

    public AtomicInteger getResultIndex() {
        return this.resultIndex;
    }

    public TypeMirror getCollectionType() {
        return this.collectionType != null ? this.collectionType : ((ConfigurationLoaderClassGenerationContext)this.parentGeneration).getCollectionType();
    }

    public TypeMirror getListType() {
        return this.listType != null ? this.listType : ((ConfigurationLoaderClassGenerationContext)this.parentGeneration).getListType();
    }

    public TypeMirror getSetType() {
        return this.setType != null ? this.setType : ((ConfigurationLoaderClassGenerationContext)this.parentGeneration).getSetType();
    }

    public static enum GenerationMode {
        CONFIGURATION_LOADER_CLASS,
        CONFIGURATION_PROPERTIES,
        CONFIGURATION_CONFIGURER,
        CONFIGURATION_PROPERTY_NAME,
        CONFIGURATION_PROPERTY_CONFIGURER,
        CONFIGURATION_IMPL_CLASS,
        CONFIGURATION_IMPL_PROPERTY_FIELD,
        CONFIGURATION_IMPL_PROPERTY_PARAMETER,
        CONFIGURATION_IMPL_PROPERTY_ASSIGNMENT,
        CONFIGURATION_IMPL_PROPERTY_ACCESSOR,
        CONFIGURATION_CONFIGURATOR_CLASS,
        CONFIGURATION_CONFIGURATOR_PROPERTY_FIELD,
        CONFIGURATION_CONFIGURATOR_PROPERTY_INJECTOR,
        CONFIGURATION_BEAN_CLASS;

    }
}

