/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.configuration.compiler.spi;

import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.QualifiedNameFormatException;

public class PropertyQualifiedName
extends BeanQualifiedName {
    private BeanQualifiedName beanQName;
    private String name;

    public PropertyQualifiedName(BeanQualifiedName beanQName, String name) throws QualifiedNameFormatException {
        super(beanQName.getModuleQName(), beanQName.getBeanName() + "." + name);
        this.beanQName = beanQName;
        this.name = name;
        this.validateQualifiedNamePart(this.name);
    }

    public BeanQualifiedName getBeanQName() {
        return this.beanQName;
    }

    public String getPropertyName() {
        return this.name;
    }

    public static PropertyQualifiedName valueOf(String qname) throws QualifiedNameFormatException {
        int lastSeparatorIndex = qname.lastIndexOf(".");
        if (lastSeparatorIndex == -1) {
            throw new QualifiedNameFormatException("Invalid qname " + qname + ", was expecting: BeanQualifiedName().<propertyName>");
        }
        return new PropertyQualifiedName(BeanQualifiedName.valueOf((String)qname.substring(0, lastSeparatorIndex)), qname.substring(lastSeparatorIndex + 1));
    }

    public static PropertyQualifiedName valueOf(ModuleQualifiedName moduleQName, String qname) throws QualifiedNameFormatException {
        String[] qnameParts = qname.split(".");
        if (qnameParts.length < 2) {
            throw new QualifiedNameFormatException("Invalid qname " + qname + ", was expecting: <beanName>.<propertyName>");
        }
        return new PropertyQualifiedName(new BeanQualifiedName(moduleQName, qnameParts[0]), qnameParts[1]);
    }
}

