/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.configuration.compiler.internal;

import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.QualifiedName;
import io.inverno.core.compiler.spi.ReporterInfo;
import io.inverno.core.compiler.spi.support.AbstractInfo;
import io.inverno.mod.configuration.compiler.spi.ConfigurationInfo;
import io.inverno.mod.configuration.compiler.spi.ConfigurationInfoVisitor;
import io.inverno.mod.configuration.compiler.spi.ConfigurationPropertyInfo;
import java.util.Collections;
import java.util.List;
import javax.lang.model.type.DeclaredType;

class GenericConfigurationInfo
extends AbstractInfo<BeanQualifiedName>
implements ConfigurationInfo {
    private List<? extends ConfigurationPropertyInfo> properties;
    private DeclaredType type;
    private boolean generateBean;
    private boolean overridable;

    public GenericConfigurationInfo(BeanQualifiedName name, ReporterInfo reporter, DeclaredType type, List<? extends ConfigurationPropertyInfo> properties) {
        this(name, reporter, type, properties, false, false);
    }

    public GenericConfigurationInfo(BeanQualifiedName name, ReporterInfo reporter, DeclaredType type, List<? extends ConfigurationPropertyInfo> properties, boolean generateBean, boolean overridable) {
        super((QualifiedName)name, reporter);
        this.type = type;
        this.properties = properties != null ? Collections.unmodifiableList(properties) : List.of();
        this.generateBean = generateBean;
        this.overridable = overridable;
    }

    @Override
    public DeclaredType getType() {
        return this.type;
    }

    @Override
    public ConfigurationPropertyInfo[] getProperties() {
        return (ConfigurationPropertyInfo[])this.properties.stream().toArray(ConfigurationPropertyInfo[]::new);
    }

    @Override
    public boolean isGenerateBean() {
        return this.generateBean;
    }

    @Override
    public boolean isOverridable() {
        return this.overridable;
    }

    @Override
    public <R, P> R accept(ConfigurationInfoVisitor<R, P> visitor, P p) {
        return visitor.visit(this, p);
    }
}

