/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.wire;

import io.inverno.core.annotation.AnnotationSelector;
import io.inverno.core.compiler.spi.BeanInfo;
import io.inverno.core.compiler.spi.SocketInfo;
import io.inverno.core.compiler.spi.WiringStrategy;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

public class AnnotationSelectorWiringStrategy
implements WiringStrategy {
    private final ProcessingEnvironment processingEnvironment;
    private final TypeMirror annotationSelectorAnnotationType;

    public AnnotationSelectorWiringStrategy(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.annotationSelectorAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement(AnnotationSelector.class.getCanonicalName()).asType();
    }

    @Override
    public boolean isWirable(BeanInfo bean, SocketInfo socket) {
        return Arrays.stream(socket.getSelectors()).filter(selector -> this.processingEnvironment.getTypeUtils().isSameType(selector.getAnnotationType(), this.annotationSelectorAnnotationType)).allMatch(annotationSelector -> {
            TypeMirror annotionTypeToSelect = this.getAnnotationTypeToSelect((AnnotationMirror)annotationSelector);
            return this.processingEnvironment.getTypeUtils().asElement(bean.getType()).getAnnotationMirrors().stream().anyMatch(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), annotionTypeToSelect));
        });
    }

    private TypeMirror getAnnotationTypeToSelect(AnnotationMirror annotationSelector) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> value : this.processingEnvironment.getElementUtils().getElementValuesWithDefaults(annotationSelector).entrySet()) {
            switch (value.getKey().getSimpleName().toString()) {
                case "value": {
                    return (TypeMirror)value.getValue().getValue();
                }
            }
        }
        throw new RuntimeException("Fatal error extracting annotation type to select");
    }
}

