/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.plugin;

import io.inverno.core.compiler.GenericCompilerOptions;
import io.inverno.core.compiler.InvernoCompiler;
import io.inverno.core.compiler.plugin.GenericPluginContext;
import io.inverno.core.compiler.plugin.PluginsExecutionTask;
import io.inverno.core.compiler.spi.BeanInfo;
import io.inverno.core.compiler.spi.ModuleInfo;
import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.plugin.CompilerPlugin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ModuleElement;

public class PluginsExecutor {
    private final ProcessingEnvironment processingEnvironment;
    private final GenericCompilerOptions options;
    private Set<CompilerPlugin> plugins;
    private Map<ModuleQualifiedName, PluginsExecutionTask> executionByModule;

    public PluginsExecutor(ProcessingEnvironment processingEnvironment, GenericCompilerOptions options) {
        this.processingEnvironment = processingEnvironment;
        this.options = options;
        this.executionByModule = new HashMap<ModuleQualifiedName, PluginsExecutionTask>();
        this.loadPlugins();
    }

    private void loadPlugins() {
        ServiceLoader<CompilerPlugin> loader = InvernoCompiler.class.getModule().isNamed() ? ServiceLoader.load(InvernoCompiler.class.getModule().getLayer(), CompilerPlugin.class) : ServiceLoader.load(CompilerPlugin.class, PluginsExecutor.class.getClassLoader());
        this.plugins = loader.stream().map(provider -> {
            CompilerPlugin plugin = (CompilerPlugin)provider.get();
            plugin.init(new GenericPluginContext(this.processingEnvironment, this.options.withFilter(name -> plugin.getSupportedOptions() != null && plugin.getSupportedOptions().contains(name))));
            return plugin;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<CompilerPlugin> getPlugins() {
        return this.plugins;
    }

    public PluginsExecutionTask getTask(ModuleElement moduleElement, ModuleQualifiedName moduleQualifiedName, List<? extends BeanInfo> beans, List<? extends ModuleInfo> modules) {
        if (!this.executionByModule.containsKey(moduleQualifiedName)) {
            this.executionByModule.put(moduleQualifiedName, new PluginsExecutionTask(this.processingEnvironment, moduleElement, moduleQualifiedName, this.options, this.plugins, beans, modules));
        }
        return this.executionByModule.get(moduleQualifiedName);
    }
}

