/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.module;

import io.inverno.core.annotation.Bean;
import io.inverno.core.compiler.common.AbstractInfo;
import io.inverno.core.compiler.spi.ModuleBeanInfo;
import io.inverno.core.compiler.spi.ModuleInfo;
import io.inverno.core.compiler.spi.ModuleInfoVisitor;
import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.SocketBeanInfo;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;

class BinaryModuleInfo
extends AbstractInfo<ModuleQualifiedName>
implements ModuleInfo {
    private final int version;
    private final List<SocketBeanInfo> socketInfos;
    private List<ModuleBeanInfo> beanInfos;
    private boolean faulty;

    public BinaryModuleInfo(ProcessingEnvironment processingEnvironment, ModuleElement element, ModuleQualifiedName qname, int version, List<ModuleBeanInfo> beanInfos, List<SocketBeanInfo> socketInfos) {
        super(processingEnvironment, (Element)element, qname);
        this.version = version;
        if (beanInfos != null) {
            if (beanInfos.stream().anyMatch(beanInfo -> !beanInfo.getVisibility().equals((Object)Bean.Visibility.PUBLIC))) {
                throw new IllegalArgumentException("Only public beans can be injected to a required module");
            }
            this.beanInfos = Collections.unmodifiableList(beanInfos);
        } else {
            this.beanInfos = Collections.emptyList();
        }
        this.socketInfos = socketInfos != null ? Collections.unmodifiableList(socketInfos) : Collections.emptyList();
    }

    void setFaulty(boolean faulty) {
        this.faulty = faulty;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean isFaulty() {
        return this.faulty;
    }

    @Override
    public ModuleQualifiedName getQualifiedName() {
        return (ModuleQualifiedName)this.qname;
    }

    @Override
    public ModuleInfo[] getModules() {
        return new ModuleInfo[0];
    }

    @Override
    public SocketBeanInfo[] getSockets() {
        return (SocketBeanInfo[])this.socketInfos.stream().toArray(SocketBeanInfo[]::new);
    }

    @Override
    public Optional<ModuleBeanInfo> getBean(String name) {
        return this.beanInfos.stream().filter(bean -> bean.getQualifiedName().getSimpleValue().equals(name)).findFirst();
    }

    @Override
    public ModuleBeanInfo[] getBeans() {
        return (ModuleBeanInfo[])this.beanInfos.stream().toArray(ModuleBeanInfo[]::new);
    }

    @Override
    public ModuleBeanInfo[] getPrivateBeans() {
        return new ModuleBeanInfo[0];
    }

    @Override
    public ModuleBeanInfo[] getPublicBeans() {
        return this.getBeans();
    }

    @Override
    public <R, P> R accept(ModuleInfoVisitor<R, P> visitor, P p) {
        return visitor.visit(this, p);
    }

    @Override
    public ModuleElement getElement() {
        return (ModuleElement)super.getElement();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

