/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.cycle;

import io.inverno.core.compiler.spi.BeanInfo;
import io.inverno.core.compiler.spi.ModuleBeanInfo;
import io.inverno.core.compiler.spi.ModuleBeanSocketInfo;
import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.MultiSocketInfo;
import io.inverno.core.compiler.spi.NestedBeanInfo;
import io.inverno.core.compiler.spi.OverridableBeanInfo;
import io.inverno.core.compiler.spi.OverridingSocketBeanInfo;
import io.inverno.core.compiler.spi.SingleSocketInfo;
import io.inverno.core.compiler.spi.SocketBeanInfo;
import io.inverno.core.compiler.spi.SocketInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BeanCycleDetector {
    private final ModuleQualifiedName moduleQName;
    private final List<BeanInfo> beans;

    public BeanCycleDetector(ModuleQualifiedName moduleQName, List<BeanInfo> beans) {
        this.moduleQName = moduleQName;
        this.beans = beans;
    }

    public List<List<CycleInfo>> findCycles() {
        CycleDetectionContext context = new CycleDetectionContext();
        for (BeanInfo bean : this.beans) {
            this.visitBean(bean, context);
        }
        return context.getCycles();
    }

    private void visitBean(BeanInfo bean, CycleDetectionContext context) {
        if (bean != null && !context.isVisited(bean)) {
            if (context.isOnStack(bean)) {
                context.addCycle(bean);
            } else {
                context.pushBean(bean);
                if (NestedBeanInfo.class.isAssignableFrom(bean.getClass())) {
                    context.pushSocket(null);
                    this.visitBean(((NestedBeanInfo)bean).getProvidingBean(), context);
                    context.popSocket();
                } else if (ModuleBeanInfo.class.isAssignableFrom(bean.getClass())) {
                    for (ModuleBeanSocketInfo socket : ((ModuleBeanInfo)bean).getSockets()) {
                        context.pushSocket(socket);
                        if (SingleSocketInfo.class.isAssignableFrom(socket.getClass())) {
                            this.visitBean(((SingleSocketInfo)((Object)socket)).getBean(), context);
                        } else if (MultiSocketInfo.class.isAssignableFrom(socket.getClass()) && ((MultiSocketInfo)((Object)socket)).getBeans() != null) {
                            Arrays.stream(((MultiSocketInfo)((Object)socket)).getBeans()).forEach(b -> this.visitBean((BeanInfo)b, context));
                        }
                        context.popSocket();
                    }
                    if (OverridableBeanInfo.class.isAssignableFrom(bean.getClass())) {
                        OverridingSocketBeanInfo socket = ((OverridableBeanInfo)bean).getOverridingSocket();
                        context.pushSocket(socket);
                        this.visitBean(socket.getBean(), context);
                        context.popSocket();
                    }
                } else if (SocketBeanInfo.class.isAssignableFrom(bean.getClass())) {
                    context.pushSocket((SocketBeanInfo)bean);
                    if (!bean.getQualifiedName().getModuleQName().equals(this.moduleQName)) {
                        if (SingleSocketInfo.class.isAssignableFrom(bean.getClass())) {
                            this.visitBean(((SingleSocketInfo)((Object)bean)).getBean(), context);
                        } else if (MultiSocketInfo.class.isAssignableFrom(bean.getClass()) && ((MultiSocketInfo)((Object)bean)).getBeans() != null) {
                            Arrays.stream(((MultiSocketInfo)((Object)bean)).getBeans()).forEach(b -> this.visitBean((BeanInfo)b, context));
                        }
                    }
                    context.popSocket();
                }
                context.popBean();
                context.setVisited(bean);
            }
        }
    }

    private class CycleDetectionContext {
        private final LinkedList<BeanInfo> beanStack = new LinkedList();
        private final LinkedList<SocketInfo> socketStack = new LinkedList();
        private final List<List<CycleInfo>> cycles = new ArrayList<List<CycleInfo>>();
        private final Map<BeanInfo, List<BeanInfo>> visitedBeans = new HashMap<BeanInfo, List<BeanInfo>>();

        private CycleDetectionContext() {
        }

        public void addCycle(BeanInfo bean) {
            LinkedList<CycleInfo> cycle = new LinkedList<CycleInfo>();
            for (int i = 0; i < this.beanStack.size(); ++i) {
                cycle.addFirst(new CycleInfo(BeanCycleDetector.this, this.beanStack.get(i), this.socketStack.get(i)));
                if (bean.equals(this.beanStack.get(i))) break;
            }
            this.cycles.add(cycle);
        }

        public List<List<CycleInfo>> getCycles() {
            return this.cycles;
        }

        public void pushBean(BeanInfo bean) {
            this.beanStack.push(bean);
        }

        public void pushSocket(SocketInfo socket) {
            this.socketStack.push(socket);
        }

        public void popBean() {
            this.beanStack.pop();
        }

        public void popSocket() {
            this.socketStack.pop();
        }

        public boolean isOnStack(BeanInfo bean) {
            return this.beanStack.contains(bean);
        }

        public boolean isVisited(BeanInfo bean) {
            if (this.visitedBeans.containsKey(bean) && !this.beanStack.isEmpty()) {
                return this.visitedBeans.get(bean).contains(this.beanStack.peek());
            }
            return false;
        }

        public void setVisited(BeanInfo bean) {
            if (!this.beanStack.isEmpty()) {
                List<BeanInfo> fromBeans = this.visitedBeans.get(bean);
                if (fromBeans == null) {
                    fromBeans = new ArrayList<BeanInfo>();
                    this.visitedBeans.put(bean, fromBeans);
                }
                fromBeans.add(this.beanStack.peek());
            }
        }
    }

    public class CycleInfo {
        private final BeanInfo beanInfo;
        private final SocketInfo socketInfo;

        private CycleInfo(BeanCycleDetector this$0, BeanInfo beanInfo, SocketInfo socketInfo) {
            this.beanInfo = beanInfo;
            this.socketInfo = socketInfo;
        }

        public BeanInfo getBeanInfo() {
            return this.beanInfo;
        }

        public SocketInfo getSocketInfo() {
            return this.socketInfo;
        }
    }
}

