/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.common;

import io.inverno.core.compiler.TypeErrorException;
import io.inverno.core.compiler.common.AbstractInfoFactory;
import io.inverno.core.compiler.spi.MultiSocketType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;

public abstract class AbstractSocketInfoFactory
extends AbstractInfoFactory {
    private final TypeMirror collectionType;
    private final TypeMirror setType;
    private final TypeMirror listType;

    public AbstractSocketInfoFactory(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement) {
        super(processingEnvironment, moduleElement);
        this.collectionType = this.processingEnvironment.getTypeUtils().erasure(this.processingEnvironment.getElementUtils().getTypeElement(Collection.class.getCanonicalName()).asType());
        this.setType = this.processingEnvironment.getTypeUtils().erasure(this.processingEnvironment.getElementUtils().getTypeElement(Set.class.getCanonicalName()).asType());
        this.listType = this.processingEnvironment.getTypeUtils().erasure(this.processingEnvironment.getElementUtils().getTypeElement(List.class.getCanonicalName()).asType());
    }

    protected MultiSocketType getMultiType(TypeMirror type) {
        if (type.getKind().equals((Object)TypeKind.ARRAY)) {
            return MultiSocketType.ARRAY;
        }
        if (this.processingEnvironment.getTypeUtils().isSameType(this.collectionType, this.processingEnvironment.getTypeUtils().erasure(type))) {
            return MultiSocketType.COLLECTION;
        }
        if (this.processingEnvironment.getTypeUtils().isSameType(this.setType, this.processingEnvironment.getTypeUtils().erasure(type))) {
            return MultiSocketType.SET;
        }
        if (this.processingEnvironment.getTypeUtils().isSameType(this.listType, this.processingEnvironment.getTypeUtils().erasure(type))) {
            return MultiSocketType.LIST;
        }
        return null;
    }

    protected TypeMirror getComponentType(TypeMirror multiTypeType) {
        if (multiTypeType.getKind().equals((Object)TypeKind.ARRAY)) {
            return ((ArrayType)multiTypeType).getComponentType();
        }
        if (this.processingEnvironment.getTypeUtils().isSameType(this.processingEnvironment.getTypeUtils().erasure(multiTypeType), this.collectionType) || this.processingEnvironment.getTypeUtils().isSameType(this.processingEnvironment.getTypeUtils().erasure(multiTypeType), this.setType) || this.processingEnvironment.getTypeUtils().isSameType(this.processingEnvironment.getTypeUtils().erasure(multiTypeType), this.listType)) {
            return ((DeclaredType)multiTypeType).getTypeArguments().get(0);
        }
        return null;
    }

    protected void validateType(TypeMirror type) throws TypeErrorException {
        if (type == null) {
            return;
        }
        if (type.getKind().equals((Object)TypeKind.ERROR)) {
            throw new TypeErrorException(type);
        }
        if (type.getKind().equals((Object)TypeKind.DECLARED)) {
            for (TypeMirror typeMirror : ((DeclaredType)type).getTypeArguments()) {
                this.validateType(typeMirror);
            }
        }
        if (type.getKind().equals((Object)TypeKind.WILDCARD)) {
            this.validateType(((WildcardType)type).getExtendsBound());
            this.validateType(((WildcardType)type).getSuperBound());
        }
    }
}

