/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.common;

import io.inverno.core.annotation.Module;
import io.inverno.core.compiler.common.GenericReporterInfo;
import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.ReporterInfo;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.type.TypeMirror;

public abstract class AbstractInfoFactory {
    protected ProcessingEnvironment processingEnvironment;
    protected ModuleElement moduleElement;
    protected AnnotationMirror moduleAnnotation;
    protected ModuleQualifiedName moduleQName;

    protected AbstractInfoFactory(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement) {
        this.processingEnvironment = processingEnvironment;
        this.moduleElement = moduleElement;
        TypeMirror moduleAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement(Module.class.getCanonicalName()).asType();
        Optional<AnnotationMirror> moduleAnnotationOpt = this.processingEnvironment.getElementUtils().getAllAnnotationMirrors(moduleElement).stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), moduleAnnotationType)).findFirst();
        if (!moduleAnnotationOpt.isPresent()) {
            throw new IllegalArgumentException("The specified element is not annotated with " + Module.class.getSimpleName());
        }
        this.moduleAnnotation = moduleAnnotationOpt.get();
        String packageName = "";
        String moduleName = "";
        String moduleClassName = null;
        String moduleSourcePackageName = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> value : this.processingEnvironment.getElementUtils().getElementValuesWithDefaults(this.moduleAnnotation).entrySet()) {
            switch (value.getKey().getSimpleName().toString()) {
                case "className": {
                    moduleClassName = (String)value.getValue().getValue();
                    break;
                }
                case "sourcePackage": {
                    moduleSourcePackageName = (String)value.getValue().getValue();
                }
            }
        }
        if (moduleElement.isUnnamed()) {
            moduleName = "DefaultModule";
        } else {
            moduleName = this.moduleElement.getQualifiedName().toString();
            int moduleNameIndex = moduleName.lastIndexOf(".");
            if (moduleNameIndex > 0) {
                packageName = moduleName.substring(0, moduleNameIndex);
                moduleName = moduleName.substring(moduleNameIndex + 1);
            }
        }
        this.moduleQName = new ModuleQualifiedName(packageName, moduleName, moduleClassName, moduleSourcePackageName);
    }

    protected ReporterInfo getReporter(Element element) {
        return new GenericReporterInfo(this.processingEnvironment, element);
    }

    protected ReporterInfo getReporter(Element element, AnnotationMirror annotation) {
        return new GenericReporterInfo(this.processingEnvironment, element, annotation);
    }
}

