/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.bean;

import io.inverno.core.compiler.bean.BeanCompilationException;
import io.inverno.core.compiler.bean.BinaryModuleBeanInfoFactory;
import io.inverno.core.compiler.bean.CompiledModuleBeanInfoFactory;
import io.inverno.core.compiler.common.AbstractInfoFactory;
import io.inverno.core.compiler.spi.ModuleBeanInfo;
import io.inverno.core.compiler.spi.SocketBeanInfo;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;

public abstract class ModuleBeanInfoFactory
extends AbstractInfoFactory {
    protected ModuleBeanInfoFactory(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement) {
        super(processingEnvironment, moduleElement);
    }

    public static ModuleBeanInfoFactory create(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement) {
        return new CompiledModuleBeanInfoFactory(processingEnvironment, moduleElement);
    }

    public static ModuleBeanInfoFactory create(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement, ModuleElement requiredModuleElement, Supplier<List<? extends SocketBeanInfo>> moduleSocketInfosSupplier, Integer version) {
        if (moduleElement.getDirectives().stream().noneMatch(directive -> directive.getKind().equals((Object)ModuleElement.DirectiveKind.REQUIRES) && ((ModuleElement.RequiresDirective)directive).getDependency().equals(requiredModuleElement))) {
            throw new IllegalArgumentException("The specified element is not required in module " + moduleElement.getQualifiedName().toString());
        }
        if (version == null) {
            throw new IllegalStateException("Version of binary module can't be null");
        }
        switch (version) {
            case 1: {
                return new BinaryModuleBeanInfoFactory(processingEnvironment, requiredModuleElement, moduleElement, moduleSocketInfosSupplier);
            }
        }
        throw new IllegalStateException("Unsupported version: " + version);
    }

    public abstract ModuleBeanInfo createBean(Element var1) throws BeanCompilationException;
}

