/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.bean;

import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.BeanSocket;
import io.inverno.core.annotation.Destroy;
import io.inverno.core.annotation.Init;
import io.inverno.core.annotation.Overridable;
import io.inverno.core.annotation.Provide;
import io.inverno.core.annotation.Wrapper;
import io.inverno.core.compiler.TypeErrorException;
import io.inverno.core.compiler.bean.BeanCompilationException;
import io.inverno.core.compiler.bean.CommonModuleBeanInfo;
import io.inverno.core.compiler.bean.CompiledOverridableBeanInfo;
import io.inverno.core.compiler.bean.CompiledOverridingSocketBeanInfo;
import io.inverno.core.compiler.bean.CompiledWrapperBeanInfo;
import io.inverno.core.compiler.bean.ModuleBeanInfoFactory;
import io.inverno.core.compiler.bean.ModuleBeanSocketInfoFactory;
import io.inverno.core.compiler.bean.NestedBeanInfoFactory;
import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.BeanSocketQualifiedName;
import io.inverno.core.compiler.spi.ModuleBeanInfo;
import io.inverno.core.compiler.spi.ModuleBeanSocketInfo;
import io.inverno.core.compiler.spi.QualifiedNameFormatException;
import io.inverno.core.compiler.spi.ReporterInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

class CompiledModuleBeanInfoFactory
extends ModuleBeanInfoFactory {
    private final TypeMirror beanAnnotationType;
    private final TypeMirror beanSocketAnnotationType;
    private final TypeMirror provideAnnotationType;
    private final TypeMirror wrapperAnnotationType;
    private final TypeMirror overridableAnnotationType;
    private final TypeMirror supplierType;
    private final NestedBeanInfoFactory nestedBeanFactory;

    CompiledModuleBeanInfoFactory(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement) {
        super(processingEnvironment, moduleElement);
        this.beanAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement(Bean.class.getCanonicalName()).asType();
        this.beanSocketAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement(BeanSocket.class.getCanonicalName()).asType();
        this.provideAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement(Provide.class.getCanonicalName()).asType();
        this.wrapperAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement(Wrapper.class.getCanonicalName()).asType();
        this.overridableAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement(Overridable.class.getCanonicalName()).asType();
        this.supplierType = this.processingEnvironment.getTypeUtils().erasure(this.processingEnvironment.getElementUtils().getTypeElement(Supplier.class.getCanonicalName()).asType());
        this.nestedBeanFactory = new NestedBeanInfoFactory(this.processingEnvironment);
    }

    @Override
    public ModuleBeanInfo createBean(Element element) throws BeanCompilationException {
        CommonModuleBeanInfo moduleBeanInfo;
        BeanQualifiedName beanQName;
        TypeElement typeElement;
        if (!TypeElement.class.isAssignableFrom(element.getClass())) {
            throw new IllegalArgumentException("Element must be a TypeElement");
        }
        if (!element.getKind().equals((Object)ElementKind.CLASS)) {
            throw new IllegalArgumentException("Element must be a Class");
        }
        for (Element currentModuleElement = typeElement = (TypeElement)element; currentModuleElement != null; currentModuleElement = currentModuleElement.getEnclosingElement()) {
            if (!(currentModuleElement instanceof ModuleElement) || currentModuleElement.equals(this.moduleElement)) continue;
            throw new IllegalArgumentException("The specified element doesn't belong to module " + String.valueOf(this.moduleQName));
        }
        Optional<AnnotationMirror> beanAnnotation = typeElement.getAnnotationMirrors().stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.beanAnnotationType)).findFirst();
        if (!beanAnnotation.isPresent()) {
            throw new IllegalArgumentException("The specified element is not annotated with " + Bean.class.getSimpleName());
        }
        ReporterInfo beanReporter = this.getReporter(typeElement, beanAnnotation.get());
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            beanReporter.error("A bean must be a concrete class");
            throw new BeanCompilationException();
        }
        Object name = null;
        Bean.Visibility visibility = null;
        Bean.Strategy strategy = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> value : this.processingEnvironment.getElementUtils().getElementValuesWithDefaults(beanAnnotation.get()).entrySet()) {
            switch (value.getKey().getSimpleName().toString()) {
                case "name": {
                    name = (String)value.getValue().getValue();
                    break;
                }
                case "visibility": {
                    visibility = Bean.Visibility.valueOf((String)value.getValue().getValue().toString());
                    break;
                }
                case "strategy": {
                    strategy = Bean.Strategy.valueOf((String)value.getValue().getValue().toString());
                }
            }
        }
        if (name == null || ((String)name).equals("")) {
            name = typeElement.getSimpleName().toString();
            name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
        }
        try {
            beanQName = new BeanQualifiedName(this.moduleQName, (String)name);
        }
        catch (QualifiedNameFormatException e) {
            beanReporter.error("Invalid bean qualified name: " + e.getMessage());
            throw new BeanCompilationException();
        }
        List<ExecutableElement> initElements = this.getInitMethods(typeElement);
        List<ExecutableElement> destroyElements = this.getDestroyMethods(typeElement);
        ArrayList<ModuleBeanSocketInfo> beanSocketInfos = new ArrayList<ModuleBeanSocketInfo>();
        ModuleBeanSocketInfoFactory beanSocketFactory = ModuleBeanSocketInfoFactory.create(this.processingEnvironment, this.moduleElement, beanQName);
        List<ModuleBeanSocketInfo> requiredBeanSocketInfos = this.getRequiredBeanSocketInfos(typeElement, beanReporter, beanSocketFactory, beanQName);
        beanSocketInfos.addAll(requiredBeanSocketInfos);
        List<ModuleBeanSocketInfo> optionalBeanSocketInfos = this.getOptionalBeanSocketInfos(typeElement, beanSocketFactory, requiredBeanSocketInfos);
        beanSocketInfos.addAll(optionalBeanSocketInfos);
        Optional<AnnotationMirror> wrapperAnnotation = this.processingEnvironment.getElementUtils().getAllAnnotationMirrors(typeElement).stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.wrapperAnnotationType)).findFirst();
        TypeMirror beanType = typeElement.asType();
        if (wrapperAnnotation.isPresent()) {
            TypeMirror wrapperType = beanType;
            Optional<TypeMirror> beanSupplierType = typeElement.getInterfaces().stream().filter(t -> this.processingEnvironment.getTypeUtils().isSameType(this.processingEnvironment.getTypeUtils().erasure((TypeMirror)t), this.supplierType)).findFirst();
            if (beanSupplierType.isPresent()) {
                beanType = ((DeclaredType)beanSupplierType.get()).getTypeArguments().isEmpty() ? this.processingEnvironment.getElementUtils().getTypeElement(Object.class.getCanonicalName()).asType() : ((DeclaredType)beanSupplierType.get()).getTypeArguments().get(0);
            } else {
                beanReporter.error("A wrapper bean element must extend " + Supplier.class.getCanonicalName());
            }
            TypeMirror providedType = this.getProvidedType(typeElement, beanReporter, beanQName, beanType);
            moduleBeanInfo = new CompiledWrapperBeanInfo(this.processingEnvironment, typeElement, beanAnnotation.get(), beanQName, wrapperType, beanType, providedType, visibility, strategy, initElements, destroyElements, beanSocketInfos);
        } else {
            TypeMirror providedType = this.getProvidedType(typeElement, beanReporter, beanQName, beanType);
            moduleBeanInfo = new CommonModuleBeanInfo(this.processingEnvironment, typeElement, beanAnnotation.get(), beanQName, beanType, providedType, visibility, strategy, initElements, destroyElements, beanSocketInfos);
        }
        ModuleBeanInfo resultModuleBeanInfo = moduleBeanInfo;
        Optional<AnnotationMirror> overridableAnnotation = this.processingEnvironment.getElementUtils().getAllAnnotationMirrors(typeElement).stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.overridableAnnotationType)).findFirst();
        if (overridableAnnotation.isPresent()) {
            CompiledOverridingSocketBeanInfo socketInfo = new CompiledOverridingSocketBeanInfo(this.processingEnvironment, typeElement, overridableAnnotation.get(), (BeanQualifiedName)moduleBeanInfo.getQualifiedName(), moduleBeanInfo.getProvidedType() != null ? moduleBeanInfo.getProvidedType() : moduleBeanInfo.getType());
            resultModuleBeanInfo = new CompiledOverridableBeanInfo(moduleBeanInfo, socketInfo);
        }
        moduleBeanInfo.setNestedBeanInfos(this.nestedBeanFactory.create(resultModuleBeanInfo));
        if (beanReporter.hasError()) {
            throw new BeanCompilationException();
        }
        return resultModuleBeanInfo;
    }

    private TypeMirror getProvidedType(TypeElement typeElement, ReporterInfo beanReporter, BeanQualifiedName beanQName, TypeMirror beanType) throws BeanCompilationException {
        TypeMirror providedType = null;
        Optional<AnnotationMirror> provideAnnotation = typeElement.getAnnotationMirrors().stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.provideAnnotationType)).findFirst();
        if (provideAnnotation.isPresent()) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> value : this.processingEnvironment.getElementUtils().getElementValuesWithDefaults(provideAnnotation.get()).entrySet()) {
                switch (value.getKey().getSimpleName().toString()) {
                    case "value": {
                        providedType = (TypeMirror)value.getValue().getValue();
                    }
                }
            }
        }
        List provideAnnotatedSuperTypes = this.processingEnvironment.getTypeUtils().directSupertypes(typeElement.asType()).stream().filter(superType -> superType.getAnnotationMirrors().stream().anyMatch(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.provideAnnotationType))).collect(Collectors.toList());
        if (providedType != null && provideAnnotatedSuperTypes.size() == 1 || provideAnnotatedSuperTypes.size() > 1) {
            beanReporter.error("Bean " + String.valueOf(beanQName) + " can't provide multiple types");
        } else if (provideAnnotatedSuperTypes.size() == 1) {
            TypeMirror[] superTypeArguments = (TypeMirror[])((DeclaredType)provideAnnotatedSuperTypes.get(0)).getTypeArguments().stream().toArray(TypeMirror[]::new);
            TypeElement superTypeElement = (TypeElement)((DeclaredType)this.processingEnvironment.getTypeUtils().erasure((TypeMirror)provideAnnotatedSuperTypes.get(0))).asElement();
            providedType = this.processingEnvironment.getTypeUtils().getDeclaredType(superTypeElement, superTypeArguments);
            provideAnnotation = ((TypeMirror)provideAnnotatedSuperTypes.get(0)).getAnnotationMirrors().stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.provideAnnotationType)).findFirst();
        }
        if (providedType != null && !this.processingEnvironment.getTypeUtils().isAssignable(beanType, providedType)) {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Type " + String.valueOf(providedType) + " is incompatible with bean type " + String.valueOf(beanType), typeElement, provideAnnotation.get());
            throw new BeanCompilationException();
        }
        return providedType;
    }

    private List<ExecutableElement> getInitMethods(TypeElement typeElement) {
        return typeElement.getEnclosedElements().stream().filter(e -> e.getAnnotation(Init.class) != null).map(e -> (ExecutableElement)e).filter(e -> {
            if (!e.getParameters().isEmpty()) {
                this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Invalid " + Init.class.getSimpleName() + " method which should be a no-argument method, it will be ignored", (Element)e);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private List<ExecutableElement> getDestroyMethods(TypeElement typeElement) {
        return typeElement.getEnclosedElements().stream().filter(e -> e.getAnnotation(Destroy.class) != null).map(e -> (ExecutableElement)e).filter(e -> {
            if (!e.getParameters().isEmpty()) {
                this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Invalid " + Destroy.class.getSimpleName() + " method which should be a no-argument method, it will be ignored", (Element)e);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private List<ModuleBeanSocketInfo> getRequiredBeanSocketInfos(TypeElement typeElement, ReporterInfo beanReporter, ModuleBeanSocketInfoFactory beanSocketFactory, BeanQualifiedName beanQName) {
        ExecutableElement constructorSocketElement = null;
        List constructorSocketElements = typeElement.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.CONSTRUCTOR)).filter(e -> e.getModifiers().stream().anyMatch(m -> m.equals((Object)Modifier.PUBLIC))).map(e -> (ExecutableElement)e).collect(Collectors.toList());
        if (constructorSocketElements.stream().anyMatch(e -> e.getAnnotation(BeanSocket.class) != null)) {
            if ((constructorSocketElements = constructorSocketElements.stream().filter(e -> e.getAnnotationMirrors().stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.beanSocketAnnotationType)).findFirst().map(beanSocketAnnotation -> {
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> value : this.processingEnvironment.getElementUtils().getElementValuesWithDefaults((AnnotationMirror)beanSocketAnnotation).entrySet()) {
                    switch (value.getKey().getSimpleName().toString()) {
                        case "enabled": {
                            return (boolean)((Boolean)value.getValue().getValue());
                        }
                    }
                }
                return true;
            }).orElse(false)).collect(Collectors.toList())).isEmpty()) {
                beanReporter.error("No constructor annotated with " + BeanSocket.class.getSimpleName() + " is enabled in module bean " + String.valueOf(beanQName) + ", consider enabling one constructor");
            } else if (constructorSocketElements.size() == 1) {
                constructorSocketElement = (ExecutableElement)constructorSocketElements.get(0);
            } else {
                beanReporter.error("Multiple constructors annotated with " + BeanSocket.class.getSimpleName() + " are enabled in module bean " + String.valueOf(beanQName) + ", consider keeping only one enabled constructor");
            }
        } else if (constructorSocketElements.isEmpty()) {
            beanReporter.error("No public constructor defined in bean " + String.valueOf(beanQName));
        } else if (constructorSocketElements.size() == 1) {
            constructorSocketElement = (ExecutableElement)constructorSocketElements.get(0);
        } else {
            beanReporter.error("Multiple constructors are defined in module bean " + String.valueOf(beanQName) + ", consider specifying a " + BeanSocket.class.getSimpleName() + " on the one to select");
        }
        if (constructorSocketElement != null) {
            return constructorSocketElement.getParameters().stream().map(ve -> {
                try {
                    return beanSocketFactory.createBeanSocket((VariableElement)ve).orElse(null);
                }
                catch (TypeErrorException e1) {
                    beanReporter.error("Invalid required socket " + ve.getSimpleName().toString() + " : Type " + String.valueOf(e1.getType()) + " could not be resolved");
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return List.of();
    }

    private List<ModuleBeanSocketInfo> getOptionalBeanSocketInfos(TypeElement typeElement, ModuleBeanSocketInfoFactory beanSocketFactory, List<ModuleBeanSocketInfo> requiredBeanSocketInfos) {
        List optionalSocketElements = typeElement.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.METHOD) && e.getSimpleName().toString().startsWith("set")).filter(e -> e.getModifiers().stream().anyMatch(m -> m.equals((Object)Modifier.PUBLIC))).map(e -> (ExecutableElement)e).filter(e -> e.getParameters().size() == 1).collect(Collectors.toList());
        if (optionalSocketElements.stream().anyMatch(e -> e.getAnnotation(BeanSocket.class) != null)) {
            optionalSocketElements = optionalSocketElements.stream().filter(e -> e.getAnnotationMirrors().stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.beanSocketAnnotationType)).findFirst().map(beanSocketAnnotation -> {
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> value : this.processingEnvironment.getElementUtils().getElementValuesWithDefaults((AnnotationMirror)beanSocketAnnotation).entrySet()) {
                    switch (value.getKey().getSimpleName().toString()) {
                        case "enabled": {
                            return (boolean)((Boolean)value.getValue().getValue());
                        }
                    }
                }
                return true;
            }).orElse(false)).collect(Collectors.toList());
        }
        Map requiredSocketByName = requiredBeanSocketInfos.stream().collect(Collectors.toMap(beanSocket -> beanSocket.getQualifiedName().getName(), Function.identity()));
        Predicate<ModuleBeanSocketInfo> requiredSocketConflictPredicate = optionalBeanSocketInfo -> {
            if (requiredSocketByName.containsKey(optionalBeanSocketInfo.getQualifiedName().getName())) {
                ((ModuleBeanSocketInfo)requiredSocketByName.get(optionalBeanSocketInfo.getQualifiedName().getName())).error("Required socket name is conflicting with an optional socket: " + optionalBeanSocketInfo.getQualifiedName().getName());
                optionalBeanSocketInfo.error("Optional socket name is conflicting with a required socket: " + optionalBeanSocketInfo.getQualifiedName().getName());
                return false;
            }
            return true;
        };
        ArrayList<ModuleBeanSocketInfo> optionalBeanSocketInfos = new ArrayList<ModuleBeanSocketInfo>();
        for (List<ExecutableElement> socketElementsBySocketName : optionalSocketElements.stream().collect(Collectors.groupingBy(ExecutableElement::getSimpleName)).values()) {
            if (socketElementsBySocketName.size() > 1) {
                ArrayList optionalModuleSocketInfos = new ArrayList();
                for (ExecutableElement socketElement : socketElementsBySocketName) {
                    try {
                        beanSocketFactory.createBeanSocket(socketElement.getParameters().get(0)).ifPresent(optionalModuleSocketInfos::add);
                    }
                    catch (TypeErrorException e1) {
                        this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Ignoring invalid optional socket: Type " + String.valueOf(e1.getType()) + " could not be resolved", socketElement);
                    }
                }
                Map<BeanSocketQualifiedName, List<ModuleBeanSocketInfo>> socketInfosByName = optionalModuleSocketInfos.stream().collect(Collectors.groupingBy(ModuleBeanSocketInfo::getQualifiedName));
                socketInfosByName.values().stream().filter(socketInfos -> socketInfos.size() > 1).forEach(socketInfos -> socketInfos.forEach(socketInfo -> socketInfo.error("Optional socket name is conflicting with another optional socket: " + socketInfo.getQualifiedName().getName())));
                socketInfosByName.values().stream().filter(socketInfos -> socketInfos.size() == 1).map(socketInfos -> (ModuleBeanSocketInfo)socketInfos.get(0)).filter(requiredSocketConflictPredicate).forEach(optionalBeanSocketInfos::add);
                continue;
            }
            try {
                beanSocketFactory.createBeanSocket(socketElementsBySocketName.get(0).getParameters().get(0)).filter(requiredSocketConflictPredicate).ifPresent(optionalBeanSocketInfos::add);
            }
            catch (TypeErrorException e1) {
                this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Ignoring invalid optional socket: Type " + String.valueOf(e1.getType()) + " could not be resolved", socketElementsBySocketName.get(0));
            }
        }
        return optionalBeanSocketInfos;
    }
}

