/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.bean;

import io.inverno.core.annotation.NestedBean;
import io.inverno.core.compiler.common.AbstractBeanInfo;
import io.inverno.core.compiler.spi.BeanInfo;
import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.ModuleBeanInfo;
import io.inverno.core.compiler.spi.NestedBeanInfo;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;

public class CommonNestedBeanInfo
extends AbstractBeanInfo
implements NestedBeanInfo {
    private final List<? extends NestedBeanInfo> nestedBeans;
    private ExecutableElement accessorelement;
    private BeanInfo providingBean;

    public CommonNestedBeanInfo(ProcessingEnvironment processingEnvironment, ExecutableElement element, BeanInfo providingBean, DeclaredType type) {
        super(processingEnvironment, (Element)element, new BeanQualifiedName(providingBean.getQualifiedName().getModuleQName(), providingBean.getQualifiedName().getBeanName() + "." + element.getSimpleName().toString()), type);
        this.accessorelement = element;
        this.providingBean = providingBean;
        this.nestedBeans = this.processingEnvironment.getElementUtils().getAllMembers((TypeElement)type.asElement()).stream().filter(e -> e.getAnnotation(NestedBean.class) != null).map(e -> (ExecutableElement)e).filter(e -> {
            boolean valid = true;
            if (!e.getParameters().isEmpty()) {
                this.warning("Ignoring invalid " + NestedBean.class.getSimpleName() + " " + ((BeanQualifiedName)this.qname).getBeanName() + ", " + e.getEnclosingElement().toString() + "#" + String.valueOf(e) + " should be a no-argument method");
                valid = false;
            }
            if (e.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                this.warning("Ignoring invalid " + NestedBean.class.getSimpleName() + " " + ((BeanQualifiedName)this.qname).getBeanName() + ", " + e.getEnclosingElement().toString() + "#" + String.valueOf(e) + " should be a non-void method");
                valid = false;
            }
            return valid;
        }).map(e -> {
            ExecutableType ras;
            CommonNestedBeanInfo nestedBeanInfo = null;
            DeclaredType nestedBeanType = null;
            if (e.getReturnType() instanceof DeclaredType) {
                nestedBeanType = (DeclaredType)e.getReturnType();
            } else if (e.getReturnType() instanceof TypeVariable && (ras = (ExecutableType)this.processingEnvironment.getTypeUtils().asMemberOf(type, (Element)e)).getReturnType() instanceof DeclaredType) {
                nestedBeanType = (DeclaredType)ras.getReturnType();
            }
            if (nestedBeanType != null) {
                nestedBeanInfo = new CommonNestedBeanInfo(this.processingEnvironment, (ExecutableElement)e, this, nestedBeanType);
            }
            return nestedBeanInfo;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void error(String message) {
        if (this.providingBean instanceof ModuleBeanInfo) {
            super.error(message);
        } else {
            this.providingBean.error(message);
        }
    }

    @Override
    public void warning(String message) {
        if (this.providingBean instanceof ModuleBeanInfo) {
            super.warning(message);
        } else {
            this.providingBean.warning(message);
        }
    }

    @Override
    public NestedBeanInfo[] getNestedBeans() {
        return (NestedBeanInfo[])this.nestedBeans.stream().toArray(NestedBeanInfo[]::new);
    }

    @Override
    public String getName() {
        return this.accessorelement.getSimpleName().toString();
    }

    @Override
    public BeanInfo getProvidingBean() {
        return this.providingBean;
    }

    @Override
    public ExecutableElement getAccessorElement() {
        return this.accessorelement;
    }
}

