/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.bean;

import io.inverno.core.compiler.bean.BeanCompilationException;
import io.inverno.core.compiler.bean.CommonModuleBeanInfo;
import io.inverno.core.compiler.bean.CommonModuleBeanSingleSocketInfo;
import io.inverno.core.compiler.bean.ModuleBeanInfoFactory;
import io.inverno.core.compiler.bean.ModuleBeanSocketInfoFactory;
import io.inverno.core.compiler.spi.BeanInfo;
import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.ModuleBeanInfo;
import io.inverno.core.compiler.spi.SocketBeanInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;

class BinaryModuleBeanInfoFactory
extends ModuleBeanInfoFactory {
    private final ModuleElement compiledModuleElement;
    private Map<BeanQualifiedName, List<SocketBeanInfo>> moduleSocketInfosByWiredBeanQName;

    public BinaryModuleBeanInfoFactory(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement, ModuleElement compiledModuleElement, Supplier<List<? extends SocketBeanInfo>> moduleSocketInfosSupplier) {
        super(processingEnvironment, moduleElement);
        this.compiledModuleElement = compiledModuleElement;
        this.moduleSocketInfosByWiredBeanQName = new HashMap<BeanQualifiedName, List<SocketBeanInfo>>();
        Optional.ofNullable(moduleSocketInfosSupplier.get()).ifPresent(moduleSocketInfos -> {
            for (SocketBeanInfo moduleSocketInfo : moduleSocketInfos) {
                for (BeanQualifiedName wiredBeanQName : moduleSocketInfo.getWiredBeans()) {
                    if (this.moduleSocketInfosByWiredBeanQName.get(wiredBeanQName) == null) {
                        this.moduleSocketInfosByWiredBeanQName.put(wiredBeanQName, new ArrayList());
                    }
                    this.moduleSocketInfosByWiredBeanQName.get(wiredBeanQName).add(moduleSocketInfo);
                }
            }
        });
    }

    @Override
    public ModuleBeanInfo createBean(Element element) throws BeanCompilationException {
        if (!element.getKind().equals((Object)ElementKind.METHOD)) {
            throw new IllegalArgumentException("Element must be a Method");
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        if (!((TypeElement)executableElement.getEnclosingElement()).getQualifiedName().toString().equals(this.moduleQName.getClassName())) {
            throw new IllegalArgumentException("The specified element doesn't belong to module " + String.valueOf(this.moduleQName));
        }
        if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || !executableElement.getParameters().isEmpty()) {
            throw new IllegalArgumentException("Module bean " + String.valueOf(new BeanQualifiedName(this.moduleQName, executableElement.getSimpleName().toString())) + " must be referenced as a public no-argument method");
        }
        BeanQualifiedName beanQName = new BeanQualifiedName(this.moduleQName, executableElement.getSimpleName().toString());
        ModuleBeanSocketInfoFactory beanSocketInfoFactory = ModuleBeanSocketInfoFactory.create(this.processingEnvironment, this.moduleElement, beanQName);
        List beanSocketInfos = null;
        if (this.moduleSocketInfosByWiredBeanQName.containsKey(beanQName)) {
            beanSocketInfos = this.moduleSocketInfosByWiredBeanQName.get(beanQName).stream().map(moduleSocketInfo -> {
                CommonModuleBeanSingleSocketInfo beanSingleSocketInfo = (CommonModuleBeanSingleSocketInfo)beanSocketInfoFactory.createBeanSocket(beanQName, (SocketBeanInfo)moduleSocketInfo);
                beanSingleSocketInfo.setBean((BeanInfo)moduleSocketInfo);
                return beanSingleSocketInfo;
            }).collect(Collectors.toList());
        }
        return new CommonModuleBeanInfo(this.processingEnvironment, this.compiledModuleElement, null, beanQName, executableElement.getReturnType(), null, beanSocketInfos);
    }
}

