/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler;

import io.inverno.core.compiler.GenericCompilerOptions;
import io.inverno.core.compiler.ModuleClassGenerationContext;
import io.inverno.core.compiler.ModuleClassGenerator;
import io.inverno.core.compiler.ModuleDescriptorGenerator;
import io.inverno.core.compiler.plugin.PluginsExecutionResult;
import io.inverno.core.compiler.plugin.PluginsExecutionTask;
import io.inverno.core.compiler.plugin.PluginsExecutor;
import io.inverno.core.compiler.spi.ModuleBeanInfo;
import io.inverno.core.compiler.spi.ModuleInfo;
import io.inverno.core.compiler.spi.ModuleInfoBuilder;
import io.inverno.core.compiler.spi.SocketBeanInfo;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

class ModuleGenerator {
    private final GenericCompilerOptions options;
    private final Map<String, ModuleInfo> generatedModules;
    private final Map<String, ModuleInfo> componentModules;
    private final Set<String> faultyModules;
    private final Map<String, PluginsExecutionResult> pluginsExecutedModules;
    private final ProcessingEnvironment processingEnvironment;
    private final ModuleClassGenerator moduleClassGenerator;
    private final ModuleDescriptorGenerator moduleDescriptorGenerator;
    private final Map<String, ModuleInfoBuilder> moduleBuilders;
    private final Map<String, Set<Element>> moduleOriginatingElements;
    private final Map<String, List<ModuleBeanInfo>> moduleBeans;
    private final Map<String, List<SocketBeanInfo>> moduleSockets;
    private final Map<String, List<ModuleInfoBuilder>> componentModuleBuilders;
    private final PluginsExecutor pluginsExecutor;

    public ModuleGenerator(ProcessingEnvironment processingEnv, GenericCompilerOptions options) {
        this.processingEnvironment = processingEnv;
        this.options = options;
        this.moduleClassGenerator = new ModuleClassGenerator();
        this.moduleDescriptorGenerator = new ModuleDescriptorGenerator();
        this.generatedModules = new HashMap<String, ModuleInfo>();
        this.componentModules = new HashMap<String, ModuleInfo>();
        this.faultyModules = new HashSet<String>();
        this.pluginsExecutedModules = new HashMap<String, PluginsExecutionResult>();
        this.moduleBuilders = new HashMap<String, ModuleInfoBuilder>();
        this.moduleOriginatingElements = new HashMap<String, Set<Element>>();
        this.moduleBeans = new HashMap<String, List<ModuleBeanInfo>>();
        this.moduleSockets = new HashMap<String, List<SocketBeanInfo>>();
        this.componentModuleBuilders = new HashMap<String, List<ModuleInfoBuilder>>();
        this.pluginsExecutor = new PluginsExecutor(this.processingEnvironment, this.options);
    }

    public PluginsExecutor getPluginsExecutor() {
        return this.pluginsExecutor;
    }

    public ModuleGenerator putModules(Map<String, ModuleInfoBuilder> moduleBuilders) {
        this.moduleBuilders.putAll(moduleBuilders);
        return this;
    }

    public Map<String, ModuleInfoBuilder> modules() {
        return Collections.unmodifiableMap(this.moduleBuilders);
    }

    public ModuleGenerator putOriginatingElements(Map<String, Set<Element>> moduleOriginatingElements) {
        moduleOriginatingElements.entrySet().stream().forEach(e -> {
            if (this.moduleOriginatingElements.containsKey(e.getKey())) {
                this.moduleOriginatingElements.put((String)e.getKey(), Stream.concat(this.moduleOriginatingElements.get(e.getKey()).stream(), ((Set)e.getValue()).stream()).collect(Collectors.toSet()));
            } else {
                this.moduleOriginatingElements.put((String)e.getKey(), Collections.unmodifiableSet((Set)e.getValue()));
            }
        });
        return this;
    }

    public Map<String, Set<Element>> originatingElements() {
        return Collections.unmodifiableMap(this.moduleOriginatingElements);
    }

    public ModuleGenerator putModuleBeans(Map<String, List<ModuleBeanInfo>> moduleBeans) {
        moduleBeans.entrySet().stream().forEach(e -> {
            if (this.moduleBeans.containsKey(e.getKey())) {
                this.moduleBeans.put((String)e.getKey(), Stream.concat(this.moduleBeans.get(e.getKey()).stream(), ((List)e.getValue()).stream()).collect(Collectors.toList()));
            } else {
                this.moduleBeans.put((String)e.getKey(), Collections.unmodifiableList((List)e.getValue()));
            }
        });
        return this;
    }

    public Map<String, List<ModuleBeanInfo>> moduleBeans() {
        return Collections.unmodifiableMap(this.moduleBeans);
    }

    public ModuleGenerator putModuleSockets(Map<String, List<SocketBeanInfo>> moduleSockets) {
        moduleSockets.entrySet().stream().forEach(e -> {
            if (this.moduleSockets.containsKey(e.getKey())) {
                this.moduleSockets.put((String)e.getKey(), Stream.concat(this.moduleSockets.get(e.getKey()).stream(), ((List)e.getValue()).stream()).collect(Collectors.toList()));
            } else {
                this.moduleSockets.put((String)e.getKey(), Collections.unmodifiableList((List)e.getValue()));
            }
        });
        return this;
    }

    public Map<String, List<SocketBeanInfo>> moduleSockets() {
        return Collections.unmodifiableMap(this.moduleSockets);
    }

    public ModuleGenerator putComponentModules(Map<String, List<ModuleInfoBuilder>> componentModuleBuilders) {
        componentModuleBuilders.entrySet().stream().forEach(e -> {
            if (this.componentModuleBuilders.containsKey(e.getKey())) {
                this.componentModuleBuilders.put((String)e.getKey(), Stream.concat(this.componentModuleBuilders.get(e.getKey()).stream(), ((List)e.getValue()).stream()).collect(Collectors.toList()));
            } else {
                this.componentModuleBuilders.put((String)e.getKey(), Collections.unmodifiableList((List)e.getValue()));
            }
        });
        return this;
    }

    public Map<String, List<ModuleInfoBuilder>> componentModules() {
        return Collections.unmodifiableMap(this.componentModuleBuilders);
    }

    public GenericCompilerOptions getOptions() {
        return this.options;
    }

    public boolean generateNextRound(RoundEnvironment roundEnv) {
        if (this.generatedModules.size() + this.faultyModules.size() == this.moduleBuilders.size()) {
            return false;
        }
        HashMap<String, ModuleInfo> roundModules = new HashMap<String, ModuleInfo>();
        HashMap<String, ModuleInfo> roundGeneratedModules = new HashMap<String, ModuleInfo>();
        HashSet<String> roundFaultyModules = new HashSet<String>();
        HashMap<String, PluginsExecutionResult> roundPluginExecutedModules = new HashMap<String, PluginsExecutionResult>();
        for (ModuleInfoBuilder moduleBuilder : this.moduleBuilders.values()) {
            String moduleName2 = moduleBuilder.getQualifiedName().toString();
            if (this.generatedModules.containsKey(moduleName2) || this.faultyModules.contains(moduleName2) || roundModules.containsKey(moduleBuilder.getQualifiedName().toString())) continue;
            this.generateModule(moduleBuilder, roundEnv, roundModules, roundGeneratedModules, roundFaultyModules, roundPluginExecutedModules);
        }
        if (roundGeneratedModules.isEmpty() && roundFaultyModules.isEmpty() && roundPluginExecutedModules.isEmpty()) {
            throw new IllegalStateException("Module generator round resulted in no module generation and no plugin execution. Unable to generate modules: " + this.moduleBuilders.keySet().stream().filter(moduleName -> !this.generatedModules.containsKey(moduleName)).collect(Collectors.joining(", ")));
        }
        this.generatedModules.putAll(roundGeneratedModules);
        this.faultyModules.addAll(roundFaultyModules);
        this.pluginsExecutedModules.putAll(roundPluginExecutedModules);
        return true;
    }

    private ModuleInfo generateModule(ModuleInfoBuilder moduleBuilder, RoundEnvironment roundEnv, Map<String, ModuleInfo> roundModules, Map<String, ModuleInfo> roundGeneratedModules, Set<String> roundFaultyModules, Map<String, PluginsExecutionResult> roundPluginExecutedModules) {
        PluginsExecutionResult pluginsExecutionResult;
        String moduleName = moduleBuilder.getQualifiedName().toString();
        ArrayList moduleInjectableBeans = new ArrayList();
        boolean generate = true;
        if (this.moduleBeans.containsKey(moduleName)) {
            moduleInjectableBeans.addAll(this.moduleBeans.get(moduleName));
            moduleBuilder.beans((ModuleBeanInfo[])this.moduleBeans.get(moduleName).stream().toArray(ModuleBeanInfo[]::new));
        }
        if (this.moduleSockets.containsKey(moduleName)) {
            moduleInjectableBeans.addAll(this.moduleSockets.get(moduleName));
            moduleBuilder.sockets((SocketBeanInfo[])this.moduleSockets.get(moduleName).stream().toArray(SocketBeanInfo[]::new));
        }
        ArrayList<ModuleInfo> currentComponentModules = new ArrayList<ModuleInfo>();
        if (this.componentModuleBuilders.containsKey(moduleName)) {
            for (ModuleInfoBuilder componentModuleBuilder : this.componentModuleBuilders.get(moduleName)) {
                ModuleInfo componentModule;
                String componentModuleName = componentModuleBuilder.getQualifiedName().toString();
                if (this.generatedModules.containsKey(componentModuleName)) {
                    componentModule = this.generatedModules.get(componentModuleName);
                    Arrays.stream(componentModule.getPublicBeans()).forEach(moduleInjectableBeans::add);
                    if (componentModule.isEmpty()) continue;
                    currentComponentModules.add(componentModule);
                    continue;
                }
                if (this.componentModules.containsKey(componentModuleName)) {
                    componentModule = this.componentModules.get(componentModuleName);
                    Arrays.stream(componentModule.getPublicBeans()).forEach(moduleInjectableBeans::add);
                    if (componentModule.isEmpty()) continue;
                    currentComponentModules.add(componentModule);
                    continue;
                }
                if (this.faultyModules.contains(componentModuleName)) {
                    roundFaultyModules.add(moduleName);
                    continue;
                }
                if (this.moduleBuilders.containsValue(componentModuleBuilder)) {
                    generate = false;
                    componentModule = null;
                    componentModule = roundModules.containsKey(componentModuleName) ? roundModules.get(componentModuleName) : this.generateModule(componentModuleBuilder, roundEnv, roundModules, roundGeneratedModules, roundFaultyModules, roundPluginExecutedModules);
                    if (componentModule == null) continue;
                    Arrays.stream(componentModule.getPublicBeans()).forEach(moduleInjectableBeans::add);
                    if (componentModule.isEmpty()) continue;
                    currentComponentModules.add(componentModule);
                    continue;
                }
                componentModule = componentModuleBuilder.build();
                this.componentModules.put(componentModuleName, componentModule);
                Arrays.stream(componentModule.getPublicBeans()).forEach(moduleInjectableBeans::add);
                if (componentModule.isEmpty()) continue;
                currentComponentModules.add(componentModule);
            }
            if (generate) {
                moduleBuilder.modules((ModuleInfo[])currentComponentModules.toArray(ModuleInfo[]::new));
            }
        }
        if ((pluginsExecutionResult = this.getPreviousPluginsExecution(moduleBuilder, roundPluginExecutedModules)) == null) {
            PluginsExecutionTask pluginExecutionTask = this.pluginsExecutor.getTask(moduleBuilder.getElement(), moduleBuilder.getQualifiedName(), moduleInjectableBeans, currentComponentModules);
            pluginExecutionTask.addRound(roundEnv);
            if (generate) {
                pluginsExecutionResult = pluginExecutionTask.call();
                roundPluginExecutedModules.put(moduleName, pluginsExecutionResult);
                generate = !pluginsExecutionResult.hasGeneratedSourceFiles();
            }
        }
        ModuleInfo moduleInfo = null;
        if (generate) {
            if (this.options.isVerbose()) {
                System.out.println("Generating module " + moduleBuilder.getQualifiedName().toString() + "...");
            }
            if ((moduleInfo = moduleBuilder.build()).isFaulty() || pluginsExecutionResult.hasError()) {
                roundFaultyModules.add(moduleName);
            } else {
                block39: {
                    Writer writer;
                    block37: {
                        if (this.options.isVerbose()) {
                            System.out.println(moduleInfo.accept(this.moduleDescriptorGenerator, ""));
                        }
                        if (this.options.isGenerateModuleDescriptor()) {
                            try {
                                FileObject moduleDescriptorFile;
                                try {
                                    moduleDescriptorFile = this.processingEnvironment.getFiler().createResource(StandardLocation.CLASS_OUTPUT, moduleInfo.getQualifiedName().getValue() + "/", "META-INF/inverno/core/" + moduleInfo.getQualifiedName().getValue() + "/module.yml", (Element[])this.moduleOriginatingElements.get(moduleName).stream().toArray(Element[]::new));
                                }
                                catch (FilerException e) {
                                    moduleDescriptorFile = this.processingEnvironment.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/inverno/core/" + moduleInfo.getQualifiedName().getValue() + "module.yml", (Element[])this.moduleOriginatingElements.get(moduleName).stream().toArray(Element[]::new));
                                }
                                writer = moduleDescriptorFile.openWriter();
                                try {
                                    writer.write(moduleInfo.accept(this.moduleDescriptorGenerator, ""));
                                    writer.flush();
                                }
                                finally {
                                    if (writer != null) {
                                        writer.close();
                                    }
                                }
                            }
                            catch (IOException e) {
                                this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Error generating Module descriptor " + String.valueOf(moduleInfo.getQualifiedName()) + ": " + e.getMessage());
                                if (!this.options.isDebug()) break block37;
                                e.printStackTrace();
                            }
                        }
                    }
                    if (moduleInfo.getBeans().length > 0 || moduleInfo.getModules().length > 0) {
                        try {
                            JavaFileObject moduleSourceFile = this.processingEnvironment.getFiler().createSourceFile(moduleInfo.getQualifiedName().getClassName(), (Element[])this.moduleOriginatingElements.get(moduleName).stream().toArray(Element[]::new));
                            writer = moduleSourceFile.openWriter();
                            try {
                                writer.write(moduleInfo.accept(this.moduleClassGenerator, new ModuleClassGenerationContext(this.processingEnvironment.getTypeUtils(), this.processingEnvironment.getElementUtils(), ModuleClassGenerationContext.GenerationMode.MODULE_CLASS)).toString());
                                writer.flush();
                            }
                            finally {
                                if (writer != null) {
                                    writer.close();
                                }
                            }
                            if (this.options.isVerbose()) {
                                System.out.println("Module " + String.valueOf(moduleInfo.getQualifiedName()) + " generated to " + String.valueOf(moduleSourceFile.toUri()) + "\n");
                            }
                        }
                        catch (IOException e) {
                            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error generating Module " + String.valueOf(moduleInfo.getQualifiedName()) + ": " + e.getMessage());
                            if (!this.options.isDebug()) break block39;
                            e.printStackTrace();
                        }
                    }
                }
                roundGeneratedModules.put(moduleName, moduleInfo);
            }
        }
        roundModules.put(moduleName, moduleInfo);
        return moduleInfo;
    }

    private PluginsExecutionResult getPreviousPluginsExecution(ModuleInfoBuilder moduleBuilder, Map<String, PluginsExecutionResult> roundPluginExecutedModules) {
        PluginsExecutionResult executionResult = this.pluginsExecutedModules.get(moduleBuilder.getQualifiedName().toString());
        if (executionResult == null) {
            executionResult = roundPluginExecutedModules.get(moduleBuilder.getQualifiedName().toString());
        }
        return executionResult;
    }
}

