/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler;

import io.inverno.core.compiler.spi.CompilerOptions;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public class GenericCompilerOptions
implements CompilerOptions {
    public static final String DEBUG = "inverno.debug";
    public static final String VERBOSE = "inverno.verbose";
    public static final String GENERATE_DESCRIPTOR = "inverno.generateDescriptor";
    private final Predicate<String> nameFilter;
    private final Map<String, String> processingEnvOptions;
    private final boolean debug;
    private final boolean verbose;
    private final boolean generateModuleDescriptor;

    public GenericCompilerOptions(Map<String, String> processingEnvOptions) {
        this.processingEnvOptions = processingEnvOptions;
        this.nameFilter = name -> true;
        this.debug = processingEnvOptions.containsKey(DEBUG) && (processingEnvOptions.get(DEBUG) == null || Boolean.parseBoolean(processingEnvOptions.get(DEBUG)));
        this.verbose = processingEnvOptions.containsKey(VERBOSE) && (processingEnvOptions.get(VERBOSE) == null || Boolean.parseBoolean(processingEnvOptions.get(VERBOSE)));
        this.generateModuleDescriptor = processingEnvOptions.containsKey(GENERATE_DESCRIPTOR) && (processingEnvOptions.get(GENERATE_DESCRIPTOR) == null || Boolean.parseBoolean(processingEnvOptions.get(GENERATE_DESCRIPTOR)));
    }

    private GenericCompilerOptions(GenericCompilerOptions parentOptions, Predicate<String> nameFilter) {
        this.processingEnvOptions = parentOptions.processingEnvOptions;
        this.nameFilter = nameFilter;
        this.debug = parentOptions.debug;
        this.verbose = parentOptions.verbose;
        this.generateModuleDescriptor = parentOptions.generateModuleDescriptor;
    }

    public GenericCompilerOptions withFilter(Predicate<String> namefilter) {
        return new GenericCompilerOptions(this, namefilter);
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isGenerateModuleDescriptor() {
        return this.generateModuleDescriptor;
    }

    @Override
    public boolean containsOption(String name) {
        if (this.nameFilter.test(name)) {
            return this.processingEnvOptions.containsKey(name);
        }
        return false;
    }

    @Override
    public Optional<String> getOption(String name) {
        if (this.nameFilter.test(name)) {
            return Optional.ofNullable(this.processingEnvOptions.get(name));
        }
        return Optional.empty();
    }

    @Override
    public boolean isOptionActivated(String name, boolean defaultActivation) {
        if (this.nameFilter.test(name)) {
            if (!this.processingEnvOptions.containsKey(name)) {
                return defaultActivation;
            }
            return this.getOption(name).map(Boolean::valueOf).orElse(true);
        }
        return defaultActivation;
    }
}

