/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.spi.support;

import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.QualifiedName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class AbstractSourceGenerationContext<A extends AbstractSourceGenerationContext<A, B>, B extends Enum<B>> {
    protected A parentGeneration;
    protected final Types typeUtils;
    protected final Elements elementUtils;
    protected B mode;
    protected final Map<String, String> imports;
    protected int indentDepth = 0;
    protected static final String DEFAULT_INDENT = "\t";
    protected String indent;
    protected ModuleQualifiedName moduleQualifiedName;
    protected Map<QualifiedName, String> fieldNames;

    public AbstractSourceGenerationContext(Types typeUtils, Elements elementUtils, B mode) {
        this(typeUtils, elementUtils, mode, DEFAULT_INDENT);
    }

    public AbstractSourceGenerationContext(Types typeUtils, Elements elementUtils, B mode, String indent) {
        this.imports = new HashMap<String, String>();
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.mode = mode;
        this.setIndent(indent);
        this.fieldNames = new HashMap<QualifiedName, String>();
    }

    protected AbstractSourceGenerationContext(A parentGeneration) {
        this.parentGeneration = parentGeneration;
        this.imports = ((AbstractSourceGenerationContext)parentGeneration).imports;
        this.typeUtils = ((AbstractSourceGenerationContext)parentGeneration).typeUtils;
        this.elementUtils = ((AbstractSourceGenerationContext)parentGeneration).elementUtils;
        this.mode = ((AbstractSourceGenerationContext)parentGeneration).getMode();
        this.setIndent(((AbstractSourceGenerationContext)parentGeneration).indent);
        this.indentDepth = ((AbstractSourceGenerationContext)parentGeneration).indentDepth;
        this.moduleQualifiedName = ((AbstractSourceGenerationContext)parentGeneration).moduleQualifiedName;
        this.fieldNames = ((AbstractSourceGenerationContext)parentGeneration).fieldNames;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public String indent(int depth) {
        Object repeatIndent = "";
        for (int i = 0; i < this.indentDepth + depth; ++i) {
            repeatIndent = (String)repeatIndent + this.indent;
        }
        return repeatIndent;
    }

    public abstract A withMode(B var1);

    public A withIndentDepthAdd(int delta) {
        return this.withIndentDepth(this.indentDepth + delta);
    }

    public abstract A withIndentDepth(int var1);

    public abstract A withModule(ModuleQualifiedName var1);

    public B getMode() {
        return this.mode;
    }

    public int getIndentDepth() {
        return this.indentDepth;
    }

    public ModuleQualifiedName getModule() {
        return this.moduleQualifiedName;
    }

    public Types getTypeUtils() {
        return this.typeUtils;
    }

    public Elements getElementUtils() {
        return this.elementUtils;
    }

    public void addImport(String className, String canonicalName) {
        if (!this.imports.containsKey(className)) {
            this.imports.put(className, canonicalName);
        }
    }

    public void removeImport(String className) {
        this.imports.remove(className);
    }

    public Set<String> getImports() {
        return new HashSet<String>(this.imports.values());
    }

    private void addImport(TypeMirror type) {
        if (type.getKind().equals((Object)TypeKind.ARRAY)) {
            this.addImport(((ArrayType)type).getComponentType());
        } else if (type.getKind().equals((Object)TypeKind.DECLARED)) {
            Element importElement = this.typeUtils.asElement(this.typeUtils.erasure(type));
            if (!this.imports.containsKey(importElement.getSimpleName().toString())) {
                this.imports.put(importElement.getSimpleName().toString(), importElement.toString());
            }
            for (TypeMirror typeMirror : ((DeclaredType)type).getTypeArguments()) {
                this.addImport(typeMirror);
            }
        } else if (type.getKind().equals((Object)TypeKind.WILDCARD)) {
            if (((WildcardType)type).getExtendsBound() != null) {
                this.addImport(((WildcardType)type).getExtendsBound());
            } else if (((WildcardType)type).getSuperBound() != null) {
                this.addImport(((WildcardType)type).getSuperBound());
            }
        }
    }

    private boolean isImported(TypeMirror type) {
        Element erasedElement = this.typeUtils.asElement(this.typeUtils.erasure(type));
        return this.imports.containsKey(erasedElement.getSimpleName().toString()) && this.imports.get(erasedElement.getSimpleName().toString()).equals(erasedElement.toString());
    }

    public String getTypeName(String canonicalName) {
        String packageName = canonicalName.lastIndexOf(".") != -1 ? canonicalName.substring(0, canonicalName.lastIndexOf(".")) : "";
        String className = canonicalName.substring(packageName.length() + 1);
        this.addImport(className, canonicalName);
        if (this.imports.containsKey(className) && this.imports.get(className).equals(canonicalName)) {
            return className;
        }
        return canonicalName;
    }

    public String getTypeName(TypeMirror type) {
        this.addImport(type);
        if (type.getKind().equals((Object)TypeKind.ARRAY)) {
            return this.getTypeName(((ArrayType)type).getComponentType()) + "[]";
        }
        if (type.getKind().equals((Object)TypeKind.DECLARED)) {
            String typeName;
            Element erasedElement = this.typeUtils.asElement(this.typeUtils.erasure(type));
            String string = typeName = this.isImported(type) ? erasedElement.getSimpleName().toString() : erasedElement.toString();
            if (((DeclaredType)type).getTypeArguments().size() > 0) {
                return typeName + "<" + ((DeclaredType)type).getTypeArguments().stream().map(t -> this.getTypeName((TypeMirror)t)).collect(Collectors.joining(", ")) + ">";
            }
            return typeName;
        }
        if (type.getKind().equals((Object)TypeKind.WILDCARD)) {
            if (((WildcardType)type).getExtendsBound() != null) {
                return "? extends " + this.getTypeName(((WildcardType)type).getExtendsBound());
            }
            if (((WildcardType)type).getSuperBound() != null) {
                return "? super " + this.getTypeName(((WildcardType)type).getSuperBound());
            }
            return "?";
        }
        return type.toString();
    }

    public String getFieldName(QualifiedName qName) {
        Object fieldName = this.fieldNames.get(qName);
        if (fieldName != null) {
            return fieldName;
        }
        String normalizedQName = qName.normalize();
        fieldName = normalizedQName;
        int index = 1;
        while (this.fieldNames.containsValue(fieldName)) {
            fieldName = normalizedQName + "_" + index;
            ++index;
        }
        this.fieldNames.put(qName, (String)fieldName);
        return fieldName;
    }

    public Collector<CharSequence, ?, StringBuilder> joining() {
        return Collector.of(StringBuilder::new, (stringBuilder, seq) -> stringBuilder.append((CharSequence)seq), StringBuilder::append, stringBuilder -> stringBuilder, new Collector.Characteristics[0]);
    }

    public Collector<CharSequence, ?, StringBuilder> joining(CharSequence delimiter) {
        return Collector.of(StringBuilder::new, (stringBuilder, seq) -> stringBuilder.append((CharSequence)seq).append(delimiter), StringBuilder::append, stringBuilder -> stringBuilder.length() > 0 ? stringBuilder.delete(stringBuilder.length() - delimiter.length(), stringBuilder.length()) : stringBuilder, new Collector.Characteristics[0]);
    }
}

