/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.wire;

import io.inverno.core.compiler.spi.BeanInfo;
import io.inverno.core.compiler.spi.ModuleBeanInfo;
import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.MultiSocketInfo;
import io.inverno.core.compiler.spi.OverridableBeanInfo;
import io.inverno.core.compiler.spi.SocketInfo;
import io.inverno.core.compiler.spi.WiringStrategy;
import java.util.Collection;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;

public class TypeWiringStrategy
implements WiringStrategy {
    private ProcessingEnvironment processingEnvironment;
    private ModuleQualifiedName moduleQName;

    public TypeWiringStrategy(ProcessingEnvironment processingEnvironment, ModuleQualifiedName moduleQName) {
        this.processingEnvironment = processingEnvironment;
        this.moduleQName = moduleQName;
    }

    @Override
    public boolean isWirable(BeanInfo bean, SocketInfo socket) {
        if (OverridableBeanInfo.class.isAssignableFrom(bean.getClass()) && ((OverridableBeanInfo)bean).getProvidedType() != null) {
            return this.isAssignable(((ModuleBeanInfo)bean).getProvidedType(), socket);
        }
        if (ModuleBeanInfo.class.isAssignableFrom(bean.getClass()) && !bean.getQualifiedName().getModuleQName().equals(this.moduleQName) && ((ModuleBeanInfo)bean).getProvidedType() != null) {
            return this.isAssignable(((ModuleBeanInfo)bean).getProvidedType(), socket);
        }
        return this.isAssignable(bean.getType(), socket);
    }

    public boolean isAssignable(TypeMirror type, SocketInfo socket) {
        if (type.getKind().equals((Object)TypeKind.WILDCARD)) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getExtendsBound() != null) {
                type = wildcardType.getExtendsBound();
            } else {
                return false;
            }
        }
        if (MultiSocketInfo.class.isAssignableFrom(socket.getClass())) {
            ArrayType socketArrayType;
            DeclaredType socketCollectionType = this.processingEnvironment.getTypeUtils().getDeclaredType(this.processingEnvironment.getElementUtils().getTypeElement(Collection.class.getCanonicalName()), socket.getType());
            if (!socket.getType().getKind().equals((Object)TypeKind.WILDCARD)) {
                socketArrayType = this.processingEnvironment.getTypeUtils().getArrayType(socket.getType());
            } else {
                WildcardType socketWildcardType = (WildcardType)socket.getType();
                socketArrayType = this.processingEnvironment.getTypeUtils().getArrayType(socketWildcardType.getExtendsBound() != null ? socketWildcardType.getExtendsBound() : socketWildcardType.getSuperBound());
            }
            return this.processingEnvironment.getTypeUtils().isAssignable(type, socket.getType()) || socketArrayType != null && this.processingEnvironment.getTypeUtils().isAssignable(type, socketArrayType) || this.processingEnvironment.getTypeUtils().isAssignable(type, socketCollectionType);
        }
        if (!socket.getType().getKind().equals((Object)TypeKind.WILDCARD)) {
            return this.processingEnvironment.getTypeUtils().isAssignable(type, socket.getType());
        }
        return false;
    }
}

