/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.spi;

import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.QualifiedName;
import io.inverno.core.compiler.spi.QualifiedNameFormatException;

public class BeanQualifiedName
extends QualifiedName {
    private ModuleQualifiedName moduleQName;
    private String beanName;

    public BeanQualifiedName(ModuleQualifiedName moduleQName, String beanName) throws QualifiedNameFormatException {
        super(moduleQName.getValue() + ":" + beanName);
        this.moduleQName = moduleQName;
        this.validateQualifiedNamePart(beanName);
        this.beanName = beanName;
    }

    @Override
    public String getSimpleValue() {
        return this.getBeanName();
    }

    public ModuleQualifiedName getModuleQName() {
        return this.moduleQName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public static BeanQualifiedName valueOf(String qname) throws QualifiedNameFormatException {
        int lastSeparatorIndex = qname.lastIndexOf(":");
        if (lastSeparatorIndex == -1) {
            throw new QualifiedNameFormatException("Invalid qname " + qname + ", was expecting: ModuleQualifiedName():<beanName>");
        }
        return new BeanQualifiedName(ModuleQualifiedName.valueOf(qname.substring(0, lastSeparatorIndex)), qname.substring(lastSeparatorIndex + 1));
    }
}

