/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.socket;

import io.inverno.core.annotation.Selector;
import io.inverno.core.compiler.socket.AbstractSocketBeanInfo;
import io.inverno.core.compiler.socket.CommonMultiSocketBeanInfo;
import io.inverno.core.compiler.socket.CommonSingleSocketBeanInfo;
import io.inverno.core.compiler.socket.SocketBeanInfoFactory;
import io.inverno.core.compiler.socket.SocketCompilationException;
import io.inverno.core.compiler.socket.WirableSocketBeanInfo;
import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.MultiSocketType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

class BinarySocketBeanInfoFactory
extends SocketBeanInfoFactory {
    private ModuleElement compiledModuleElement;
    private TypeMirror supplierType;
    private TypeMirror optionalType;
    private TypeMirror socketAnnotationType;

    public BinarySocketBeanInfoFactory(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement, ModuleElement compiledModuleElement) {
        super(processingEnvironment, moduleElement);
        this.compiledModuleElement = compiledModuleElement;
        this.supplierType = this.processingEnvironment.getTypeUtils().erasure(this.processingEnvironment.getElementUtils().getTypeElement(Supplier.class.getCanonicalName()).asType());
        this.optionalType = this.processingEnvironment.getTypeUtils().erasure(this.processingEnvironment.getElementUtils().getTypeElement(Optional.class.getCanonicalName()).asType());
        this.socketAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement("io.inverno.core.v1.Module.Socket").asType();
    }

    @Override
    public WirableSocketBeanInfo createSocketBean(Element element) throws SocketCompilationException {
        DeclaredType supplierType;
        TypeElement socketTypeElement;
        if (!element.getKind().equals((Object)ElementKind.PARAMETER)) {
            throw new IllegalArgumentException("Element must be a parameter");
        }
        VariableElement variableElement = (VariableElement)element;
        ExecutableElement socketElement = (ExecutableElement)variableElement.getEnclosingElement();
        if (!((TypeElement)socketElement.getEnclosingElement()).getQualifiedName().toString().equals(this.moduleQName.getClassName())) {
            throw new IllegalArgumentException("The specified element doesn't belong to module " + String.valueOf(this.moduleQName));
        }
        TypeMirror socketType = variableElement.asType();
        boolean optional = false;
        if (this.processingEnvironment.getTypeUtils().isSameType(this.processingEnvironment.getTypeUtils().erasure(socketType), this.optionalType)) {
            optional = true;
            socketType = ((DeclaredType)socketType).getTypeArguments().get(0);
        }
        if ((socketTypeElement = (TypeElement)this.processingEnvironment.getTypeUtils().asElement(socketType)).getKind() != ElementKind.INTERFACE) {
            throw new IllegalArgumentException("A socket bean must be an interface");
        }
        Optional<AnnotationMirror> socketAnnotation = variableElement.getAnnotationMirrors().stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.socketAnnotationType)).findFirst();
        if (!socketAnnotation.isPresent()) {
            throw new IllegalArgumentException("The specified element does not provide socket information");
        }
        Object socketName = null;
        Set<BeanQualifiedName> wiredBeanQNames = Set.of();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> value : this.processingEnvironment.getElementUtils().getElementValuesWithDefaults(socketAnnotation.get()).entrySet()) {
            switch (value.getKey().getSimpleName().toString()) {
                case "name": {
                    socketName = (String)value.getValue().getValue();
                    break;
                }
                case "wiredTo": {
                    wiredBeanQNames = ((List)value.getValue().getValue()).stream().map(v -> (String)v.getValue()).map(name -> new BeanQualifiedName(this.moduleQName, (String)name)).collect(Collectors.toSet());
                }
            }
        }
        if (this.processingEnvironment.getTypeUtils().isSameType(this.processingEnvironment.getTypeUtils().erasure(socketType), this.supplierType)) {
            supplierType = (DeclaredType)socketType;
            if (socketName == null || ((String)socketName).equals("")) {
                throw new IllegalArgumentException("A socket bean specified as a " + Supplier.class.getCanonicalName() + " must provide an explicit name");
            }
        } else {
            Optional<TypeMirror> supplierTypeInterface = socketTypeElement.getInterfaces().stream().filter(t -> this.processingEnvironment.getTypeUtils().isSameType(this.processingEnvironment.getTypeUtils().erasure((TypeMirror)t), this.supplierType)).findFirst();
            if (!supplierTypeInterface.isPresent()) {
                throw new IllegalArgumentException("A socket bean must be a " + Supplier.class.getCanonicalName() + " or directly extend " + Supplier.class.getCanonicalName());
            }
            supplierType = (DeclaredType)supplierTypeInterface.get();
        }
        TypeMirror beanType = null;
        beanType = supplierType.getTypeArguments().size() == 0 ? this.processingEnvironment.getElementUtils().getTypeElement(Object.class.getCanonicalName()).asType() : supplierType.getTypeArguments().get(0);
        if (socketName == null || ((String)socketName).equals("")) {
            socketName = socketTypeElement.getSimpleName().toString();
            socketName = Character.toLowerCase(((String)socketName).charAt(0)) + ((String)socketName).substring(1);
        }
        BeanQualifiedName socketQName = new BeanQualifiedName(this.moduleQName, (String)socketName);
        AnnotationMirror[] selectors = (AnnotationMirror[])element.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().asElement().getAnnotation(Selector.class) != null).toArray(AnnotationMirror[]::new);
        MultiSocketType multiType = this.getMultiType(beanType);
        AbstractSocketBeanInfo moduleSocketInfo = multiType != null ? new CommonMultiSocketBeanInfo(this.processingEnvironment, this.compiledModuleElement, socketQName, this.getComponentType(beanType), socketType, socketElement, selectors, optional, multiType) : new CommonSingleSocketBeanInfo(this.processingEnvironment, this.compiledModuleElement, socketQName, beanType, socketType, socketElement, selectors, optional);
        moduleSocketInfo.setWired(true);
        moduleSocketInfo.setWiredBeans(wiredBeanQNames);
        return moduleSocketInfo;
    }
}

