/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.module;

import io.inverno.core.compiler.socket.WirableSocketBeanInfo;
import io.inverno.core.compiler.spi.BeanInfo;
import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.ModuleBeanInfo;
import io.inverno.core.compiler.spi.ModuleBeanMultiSocketInfo;
import io.inverno.core.compiler.spi.ModuleBeanSingleSocketInfo;
import io.inverno.core.compiler.spi.ModuleBeanSocketInfo;
import io.inverno.core.compiler.spi.ModuleInfo;
import io.inverno.core.compiler.spi.ModuleInfoVisitor;
import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.MultiSocketBeanInfo;
import io.inverno.core.compiler.spi.MultiSocketInfo;
import io.inverno.core.compiler.spi.NestedBeanInfo;
import io.inverno.core.compiler.spi.OverridableBeanInfo;
import io.inverno.core.compiler.spi.OverridingSocketBeanInfo;
import io.inverno.core.compiler.spi.SingleSocketBeanInfo;
import io.inverno.core.compiler.spi.SingleSocketInfo;
import io.inverno.core.compiler.spi.SocketBeanInfo;
import io.inverno.core.compiler.spi.SocketInfo;
import io.inverno.core.compiler.spi.WrapperBeanInfo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

class ModuleBeanSocketWireResolver
implements ModuleInfoVisitor<Void, Set<BeanQualifiedName>> {
    private ModuleQualifiedName moduleQName;

    ModuleBeanSocketWireResolver() {
    }

    @Override
    public Void visit(ModuleInfo moduleInfo, Set<BeanQualifiedName> wiredBeans) {
        this.moduleQName = moduleInfo.getQualifiedName();
        Arrays.stream(moduleInfo.getBeans()).forEach(bean -> this.visit((ModuleBeanInfo)bean, (Set<BeanQualifiedName>)new HashSet<BeanQualifiedName>()));
        return null;
    }

    @Override
    public Void visit(BeanInfo beanInfo, Set<BeanQualifiedName> wiredBeans) {
        if (beanInfo == null) {
            return null;
        }
        if (NestedBeanInfo.class.isAssignableFrom(beanInfo.getClass())) {
            return this.visit((NestedBeanInfo)beanInfo, wiredBeans);
        }
        if (OverridableBeanInfo.class.isAssignableFrom(beanInfo.getClass())) {
            return this.visit((OverridableBeanInfo)beanInfo, wiredBeans);
        }
        if (ModuleBeanInfo.class.isAssignableFrom(beanInfo.getClass())) {
            return this.visit((ModuleBeanInfo)beanInfo, wiredBeans);
        }
        if (SocketBeanInfo.class.isAssignableFrom(beanInfo.getClass())) {
            return this.visit((SocketBeanInfo)beanInfo, wiredBeans);
        }
        return null;
    }

    @Override
    public Void visit(NestedBeanInfo nestedBeanInfo, Set<BeanQualifiedName> wiredBeans) {
        return this.visit(nestedBeanInfo.getProvidingBean(), wiredBeans);
    }

    @Override
    public Void visit(ModuleBeanInfo moduleBeanInfo, Set<BeanQualifiedName> wiredBeans) {
        wiredBeans.add(moduleBeanInfo.getQualifiedName());
        Arrays.stream(moduleBeanInfo.getSockets()).forEach(socket -> this.visit((ModuleBeanSocketInfo)socket, wiredBeans));
        return null;
    }

    @Override
    public Void visit(WrapperBeanInfo wrapperBeanInfo, Set<BeanQualifiedName> wiredBeans) {
        return this.visit((ModuleBeanInfo)wrapperBeanInfo, wiredBeans);
    }

    @Override
    public Void visit(OverridableBeanInfo overridableBeanInfo, Set<BeanQualifiedName> wiredBeans) {
        this.visit(overridableBeanInfo.getOverridingSocket(), wiredBeans);
        this.visit((ModuleBeanInfo)overridableBeanInfo, wiredBeans);
        return null;
    }

    @Override
    public Void visit(ModuleBeanSocketInfo beanSocketInfo, Set<BeanQualifiedName> wiredBeans) {
        if (ModuleBeanSingleSocketInfo.class.isAssignableFrom(beanSocketInfo.getClass())) {
            return this.visit((ModuleBeanSingleSocketInfo)beanSocketInfo, wiredBeans);
        }
        if (ModuleBeanMultiSocketInfo.class.isAssignableFrom(beanSocketInfo.getClass())) {
            return this.visit((ModuleBeanMultiSocketInfo)beanSocketInfo, wiredBeans);
        }
        return null;
    }

    @Override
    public Void visit(ModuleBeanSingleSocketInfo beanSingleSocketInfo, Set<BeanQualifiedName> wiredBeans) {
        if (beanSingleSocketInfo.getBean() != null) {
            this.visit(beanSingleSocketInfo.getBean(), wiredBeans);
        }
        return null;
    }

    @Override
    public Void visit(ModuleBeanMultiSocketInfo beanMultiSocketInfo, Set<BeanQualifiedName> wiredBeans) {
        if (beanMultiSocketInfo.getBeans() != null) {
            Arrays.stream(beanMultiSocketInfo.getBeans()).forEach(bean -> this.visit((BeanInfo)bean, wiredBeans));
        }
        return null;
    }

    @Override
    public Void visit(SocketBeanInfo moduleSocketInfo, Set<BeanQualifiedName> wiredBeans) {
        if (moduleSocketInfo.getQualifiedName().getModuleQName().equals(this.moduleQName)) {
            wiredBeans.addAll(Arrays.asList(moduleSocketInfo.getWiredBeans()));
            ((WirableSocketBeanInfo)moduleSocketInfo).setWiredBeans(wiredBeans.stream().filter(beanQName -> beanQName.getModuleQName().equals(this.moduleQName)).collect(Collectors.toSet()));
        } else {
            if (SingleSocketBeanInfo.class.isAssignableFrom(moduleSocketInfo.getClass())) {
                return this.visit((SingleSocketBeanInfo)moduleSocketInfo, wiredBeans);
            }
            if (MultiSocketBeanInfo.class.isAssignableFrom(moduleSocketInfo.getClass())) {
                return this.visit((MultiSocketBeanInfo)moduleSocketInfo, wiredBeans);
            }
        }
        return null;
    }

    @Override
    public Void visit(SingleSocketBeanInfo moduleSingleSocketInfo, Set<BeanQualifiedName> wiredBeans) {
        if (moduleSingleSocketInfo.getBean() != null) {
            this.visit(moduleSingleSocketInfo.getBean(), wiredBeans);
        }
        return null;
    }

    @Override
    public Void visit(MultiSocketBeanInfo moduleMultiSocketInfo, Set<BeanQualifiedName> wiredBeans) {
        if (moduleMultiSocketInfo.getBeans() != null) {
            Arrays.stream(moduleMultiSocketInfo.getBeans()).forEach(bean -> this.visit((BeanInfo)bean, wiredBeans));
        }
        return null;
    }

    @Override
    public Void visit(OverridingSocketBeanInfo overridingSocketBeanInfo, Set<BeanQualifiedName> wiredBeans) {
        return this.visit((SocketBeanInfo)overridingSocketBeanInfo, wiredBeans);
    }

    @Override
    public Void visit(SocketInfo socketInfo, Set<BeanQualifiedName> wiredBeans) {
        return null;
    }

    @Override
    public Void visit(SingleSocketInfo singleSocketInfo, Set<BeanQualifiedName> wiredBeans) {
        return null;
    }

    @Override
    public Void visit(MultiSocketInfo multiSocketInfo, Set<BeanQualifiedName> wiredBeans) {
        return null;
    }
}

