/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.module;

import io.inverno.core.annotation.Bean;
import io.inverno.core.compiler.module.AbstractModuleInfoBuilder;
import io.inverno.core.compiler.module.BinaryModuleInfo;
import io.inverno.core.compiler.spi.ModuleBeanInfo;
import io.inverno.core.compiler.spi.ModuleInfo;
import io.inverno.core.compiler.spi.ModuleInfoBuilder;
import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.SocketBeanInfo;
import java.util.Arrays;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ModuleElement;

class BinaryModuleInfoBuilder
extends AbstractModuleInfoBuilder {
    private ModuleBeanInfo[] beans = new ModuleBeanInfo[0];
    private SocketBeanInfo[] sockets = new SocketBeanInfo[0];

    public BinaryModuleInfoBuilder(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement) {
        super(processingEnvironment, moduleElement);
    }

    @Override
    public ModuleQualifiedName getQualifiedName() {
        return this.moduleQName;
    }

    @Override
    public ModuleInfoBuilder beans(ModuleBeanInfo[] beans) {
        if (beans == null) {
            this.beans = new ModuleBeanInfo[0];
        } else {
            if (Arrays.stream(beans).anyMatch(beanInfo -> !beanInfo.getVisibility().equals((Object)Bean.Visibility.PUBLIC))) {
                throw new IllegalArgumentException("Only public beans can be injected into a component module");
            }
            this.beans = beans;
        }
        return this;
    }

    @Override
    public ModuleInfoBuilder sockets(SocketBeanInfo[] sockets) {
        this.sockets = sockets != null ? sockets : new SocketBeanInfo[]{};
        return this;
    }

    @Override
    public ModuleInfoBuilder modules(ModuleInfo[] modules) {
        throw new UnsupportedOperationException("You can't inject modules into a component module");
    }

    @Override
    public ModuleInfo build() {
        return new BinaryModuleInfo(this.processingEnvironment, this.moduleElement, this.moduleQName, this.version, Arrays.asList(this.beans), Arrays.asList(this.sockets));
    }
}

