/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.common;

import io.inverno.core.compiler.spi.ReporterInfo;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.tools.Diagnostic;

public class GenericReporterInfo
implements ReporterInfo {
    protected ProcessingEnvironment processingEnvironment;
    private Element element;
    private AnnotationMirror annotation;
    private int errorCount = 0;
    private int warningCount = 0;

    public GenericReporterInfo(ProcessingEnvironment processingEnvironment, Element element) {
        this(processingEnvironment, element, null);
    }

    public GenericReporterInfo(ProcessingEnvironment processingEnvironment, Element element, AnnotationMirror annotation) {
        this.processingEnvironment = processingEnvironment;
        this.element = element;
        this.annotation = annotation;
    }

    public Element getElement() {
        return this.element;
    }

    public AnnotationMirror getAnnotation() {
        return this.annotation;
    }

    @Override
    public boolean hasError() {
        return this.errorCount > 0;
    }

    @Override
    public boolean hasWarning() {
        return this.warningCount > 0;
    }

    @Override
    public void error(String message) {
        if (this.element.getKind().equals((Object)ElementKind.MODULE)) {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, message, this.element);
        } else {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, message, this.element, this.annotation);
        }
        ++this.errorCount;
    }

    @Override
    public void warning(String message) {
        if (this.element.getKind().equals((Object)ElementKind.MODULE)) {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, message, this.element);
        } else {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, message, this.element, this.annotation);
        }
        ++this.warningCount;
    }
}

