/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.plugin;

import io.inverno.core.compiler.GenericCompilerOptions;
import io.inverno.core.compiler.plugin.GenericPluginExecution;
import io.inverno.core.compiler.plugin.PluginsExecutionResult;
import io.inverno.core.compiler.spi.BeanInfo;
import io.inverno.core.compiler.spi.ModuleInfo;
import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.plugin.CompilerPlugin;
import io.inverno.core.compiler.spi.plugin.PluginExecutionException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class PluginsExecutionTask
implements Callable<PluginsExecutionResult> {
    private final ProcessingEnvironment processingEnvironment;
    private final ModuleElement moduleElement;
    private final ModuleQualifiedName moduleQualifiedName;
    private final List<? extends BeanInfo> beans;
    private final List<? extends ModuleInfo> modules;
    private final GenericCompilerOptions options;
    private final Map<CompilerPlugin, Set<Element>> elementsByPlugins;

    PluginsExecutionTask(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement, ModuleQualifiedName module, GenericCompilerOptions options, Set<? extends CompilerPlugin> plugins, List<? extends BeanInfo> beans, List<? extends ModuleInfo> modules) {
        this.processingEnvironment = processingEnvironment;
        this.moduleElement = moduleElement;
        this.moduleQualifiedName = module;
        this.beans = beans;
        this.modules = modules;
        this.options = options;
        this.elementsByPlugins = plugins.stream().collect(Collectors.toMap(Function.identity(), plugin -> new HashSet()));
    }

    public ModuleQualifiedName getModule() {
        return this.moduleQualifiedName;
    }

    public void addRound(RoundEnvironment roundEnv) {
        this.elementsByPlugins.entrySet().forEach(entry -> {
            for (String supportedAnnotationType : ((CompilerPlugin)entry.getKey()).getSupportedAnnotationTypes()) {
                TypeElement pluginAnnotationTypeElement = this.processingEnvironment.getElementUtils().getTypeElement(supportedAnnotationType);
                if (pluginAnnotationTypeElement == null) continue;
                ((Set)entry.getValue()).addAll(roundEnv.getElementsAnnotatedWith(pluginAnnotationTypeElement).stream().map(element -> {
                    ModuleElement moduleElement = this.processingEnvironment.getElementUtils().getModuleOf((Element)element);
                    if (moduleElement == null) {
                        return null;
                    }
                    if (!moduleElement.getQualifiedName().toString().equals(this.moduleQualifiedName.toString())) {
                        return null;
                    }
                    return element;
                }).filter(Objects::nonNull).collect(Collectors.toSet()));
            }
        });
    }

    @Override
    public PluginsExecutionResult call() {
        if (this.options.isVerbose()) {
            System.out.println("Executing plugins for module " + this.moduleQualifiedName + "...");
        }
        PluginsExecutionResult result = new PluginsExecutionResult(this.elementsByPlugins.entrySet().stream().map(entry -> {
            if (this.options.isVerbose()) {
                System.out.print(" - " + ((CompilerPlugin)entry.getKey()).getClass().getCanonicalName() + " (" + ((Set)entry.getValue()).size() + " elements)... ");
            }
            if (((CompilerPlugin)entry.getKey()).canExecute(this.moduleElement)) {
                GenericPluginExecution execution = new GenericPluginExecution(this.processingEnvironment, this.moduleElement, this.moduleQualifiedName, (Set)entry.getValue(), this.beans, this.modules);
                try {
                    ((CompilerPlugin)entry.getKey()).execute(execution);
                    if (this.options.isVerbose()) {
                        if (execution.hasError()) {
                            System.out.println("[  KO  ]");
                        } else {
                            System.out.println("[  OK  ]");
                        }
                        if (execution.hasGeneratedSourceFiles()) {
                            System.out.println(execution.getGeneratedSourceFiles().stream().map(source -> "     - " + source.toUri().toString()).collect(Collectors.joining("\n")));
                        }
                        if (execution.hasGeneratedResourceFiles()) {
                            System.out.println(execution.getGeneratedResourceFiles().stream().map(source -> "     - " + source.toUri().toString()).collect(Collectors.joining("\n")));
                        }
                    }
                }
                catch (PluginExecutionException e) {
                    execution.setFailed(true);
                    if (this.options.isVerbose()) {
                        System.out.println("[  KO  ]");
                    }
                    this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Error executing plugin " + ((CompilerPlugin)entry.getKey()).getClass() + " for module " + this.moduleQualifiedName + ": " + e.getMessage());
                    if (this.options.isDebug()) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable t) {
                    execution.setFailed(true);
                    if (this.options.isVerbose()) {
                        System.out.println("[  KO  ]");
                    }
                    this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Fatal error executing plugin " + ((CompilerPlugin)entry.getKey()).getClass() + " for module " + this.moduleQualifiedName);
                    t.printStackTrace();
                }
                return execution;
            }
            if (this.options.isVerbose()) {
                System.out.println("[ SKIP ]");
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        if (this.options.isVerbose()) {
            System.out.println();
        }
        return result;
    }
}

