/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.socket;

import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.Selector;
import io.inverno.core.compiler.TypeErrorException;
import io.inverno.core.compiler.bean.NestedBeanInfoFactory;
import io.inverno.core.compiler.socket.CommonMultiSocketBeanInfo;
import io.inverno.core.compiler.socket.CommonSingleSocketBeanInfo;
import io.inverno.core.compiler.socket.SocketBeanInfoFactory;
import io.inverno.core.compiler.socket.SocketCompilationException;
import io.inverno.core.compiler.socket.WirableSocketBeanInfo;
import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.MultiSocketType;
import io.inverno.core.compiler.spi.QualifiedNameFormatException;
import io.inverno.core.compiler.spi.ReporterInfo;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

class CompiledSocketBeanInfoFactory
extends SocketBeanInfoFactory {
    private TypeMirror beanAnnotationType;
    private TypeMirror supplierType;
    private NestedBeanInfoFactory nestedBeanFactory;

    public CompiledSocketBeanInfoFactory(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement) {
        super(processingEnvironment, moduleElement);
        this.beanAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement(Bean.class.getCanonicalName()).asType();
        this.supplierType = this.processingEnvironment.getTypeUtils().erasure(this.processingEnvironment.getElementUtils().getTypeElement(Supplier.class.getCanonicalName()).asType());
        this.nestedBeanFactory = new NestedBeanInfoFactory(this.processingEnvironment);
    }

    @Override
    public WirableSocketBeanInfo createSocketBean(Element element) throws SocketCompilationException {
        if (!TypeElement.class.isAssignableFrom(element.getClass())) {
            throw new IllegalArgumentException("Element must be a TypeElement");
        }
        TypeElement typeElement = (TypeElement)element;
        for (Element moduleElement = element; moduleElement != null; moduleElement = moduleElement.getEnclosingElement()) {
            if (!(moduleElement instanceof ModuleElement) || moduleElement.equals(this.moduleElement)) continue;
            throw new IllegalArgumentException("The specified element doesn't belong to module " + this.moduleQName);
        }
        Optional<AnnotationMirror> annotation = this.processingEnvironment.getElementUtils().getAllAnnotationMirrors(element).stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.beanAnnotationType)).findFirst();
        if (!annotation.isPresent()) {
            throw new IllegalArgumentException("The specified element is not annotated with " + Bean.class.getSimpleName());
        }
        ReporterInfo beanReporter = this.getReporter(element, annotation.get());
        if (!element.getKind().equals((Object)ElementKind.INTERFACE)) {
            beanReporter.error("A socket bean must be an interface");
            throw new SocketCompilationException();
        }
        Optional<TypeMirror> supplierType = typeElement.getInterfaces().stream().filter(t -> this.processingEnvironment.getTypeUtils().isSameType(this.processingEnvironment.getTypeUtils().erasure((TypeMirror)t), this.supplierType)).findFirst();
        if (!supplierType.isPresent()) {
            beanReporter.error("A socket bean must extend " + Supplier.class.getCanonicalName());
            throw new SocketCompilationException();
        }
        Object socketName = null;
        Bean.Visibility visibility = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> value : this.processingEnvironment.getElementUtils().getElementValuesWithDefaults(annotation.get()).entrySet()) {
            switch (value.getKey().getSimpleName().toString()) {
                case "name": {
                    socketName = (String)value.getValue().getValue();
                    break;
                }
                case "visibility": {
                    visibility = Bean.Visibility.valueOf((String)value.getValue().getValue().toString());
                }
            }
        }
        if (!visibility.equals((Object)Bean.Visibility.PUBLIC)) {
            beanReporter.error("A socket bean must be public");
            throw new SocketCompilationException();
        }
        TypeMirror socketType = null;
        socketType = ((DeclaredType)supplierType.get()).getTypeArguments().size() == 0 ? this.processingEnvironment.getElementUtils().getTypeElement(Object.class.getCanonicalName()).asType() : ((DeclaredType)supplierType.get()).getTypeArguments().get(0);
        try {
            this.validateType(socketType);
        }
        catch (TypeErrorException e1) {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.WARNING, "Type " + e1.getType() + " could not be resolved.", element);
        }
        if (socketName == null || ((String)socketName).equals("")) {
            socketName = element.getSimpleName().toString();
            socketName = Character.toLowerCase(((String)socketName).charAt(0)) + ((String)socketName).substring(1);
        }
        BeanQualifiedName socketQName = null;
        try {
            socketQName = new BeanQualifiedName(this.moduleQName, (String)socketName);
        }
        catch (QualifiedNameFormatException e) {
            beanReporter.error("Invalid socket bean qualified name: " + e.getMessage());
            throw new SocketCompilationException();
        }
        AnnotationMirror[] selectors = (AnnotationMirror[])element.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().asElement().getAnnotation(Selector.class) != null).toArray(AnnotationMirror[]::new);
        MultiSocketType multiType = this.getMultiType(socketType);
        if (multiType != null) {
            return new CommonMultiSocketBeanInfo(this.processingEnvironment, typeElement, annotation.get(), socketQName, this.getComponentType(socketType), typeElement.asType(), selectors, true, multiType);
        }
        CommonSingleSocketBeanInfo socketBeanInfo = new CommonSingleSocketBeanInfo(this.processingEnvironment, typeElement, annotation.get(), socketQName, socketType, typeElement.asType(), selectors, true);
        socketBeanInfo.setNestedBeans(this.nestedBeanFactory.create(socketBeanInfo));
        return socketBeanInfo;
    }
}

