/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler;

import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.MultiSocketType;
import io.inverno.core.compiler.spi.support.AbstractSourceGenerationContext;
import java.util.function.Supplier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class ModuleClassGenerationContext
extends AbstractSourceGenerationContext<ModuleClassGenerationContext, GenerationMode> {
    private TypeMirror supplierType;

    public ModuleClassGenerationContext(Types typeUtils, Elements elementUtils, GenerationMode mode) {
        super(typeUtils, elementUtils, mode);
        this.supplierType = this.typeUtils.erasure(this.elementUtils.getTypeElement(Supplier.class.getCanonicalName()).asType());
    }

    private ModuleClassGenerationContext(ModuleClassGenerationContext parentGeneration) {
        super(parentGeneration);
        this.supplierType = this.typeUtils.erasure(this.elementUtils.getTypeElement(Supplier.class.getCanonicalName()).asType());
    }

    @Override
    public ModuleClassGenerationContext withMode(GenerationMode mode) {
        ModuleClassGenerationContext context = new ModuleClassGenerationContext(this);
        context.mode = mode;
        return context;
    }

    @Override
    public ModuleClassGenerationContext withIndentDepth(int indentDepth) {
        ModuleClassGenerationContext context = new ModuleClassGenerationContext(this);
        context.indentDepth = indentDepth;
        return context;
    }

    @Override
    public ModuleClassGenerationContext withModule(ModuleQualifiedName moduleQualifiedName) {
        ModuleClassGenerationContext context = new ModuleClassGenerationContext(this);
        context.moduleQualifiedName = moduleQualifiedName;
        return context;
    }

    public String getMultiTypeName(TypeMirror type, MultiSocketType multiType) {
        if (multiType.equals((Object)MultiSocketType.ARRAY)) {
            return this.getTypeName(this.getTypeUtils().getArrayType(type));
        }
        if (multiType.equals((Object)MultiSocketType.COLLECTION)) {
            return this.getTypeName(this.getTypeUtils().getDeclaredType(this.getElementUtils().getTypeElement("java.util.Collection"), type));
        }
        if (multiType.equals((Object)MultiSocketType.LIST)) {
            return this.getTypeName(this.getTypeUtils().getDeclaredType(this.getElementUtils().getTypeElement("java.util.List"), type));
        }
        if (multiType.equals((Object)MultiSocketType.SET)) {
            return this.getTypeName(this.getTypeUtils().getDeclaredType(this.getElementUtils().getTypeElement("java.util.Set"), type));
        }
        throw new IllegalArgumentException("Unexpected multi type: " + multiType);
    }

    public TypeMirror getSupplierSocketType(TypeMirror socketType) {
        if (this.typeUtils.isSameType(this.typeUtils.erasure(socketType), this.supplierType)) {
            return socketType;
        }
        return ((TypeElement)this.typeUtils.asElement(socketType)).getInterfaces().stream().filter(type -> this.typeUtils.isSameType(this.typeUtils.erasure((TypeMirror)type), this.supplierType)).findFirst().orElseThrow(() -> new IllegalStateException("Socket type does not extend " + Supplier.class.getCanonicalName()));
    }

    public static enum GenerationMode {
        MODULE_CLASS,
        MODULE_BUILDER_CLASS,
        MODULE_LINKER_CLASS,
        MODULE_IMPORT,
        BEAN_FIELD,
        BEAN_NEW,
        BEAN_ACCESSOR,
        BEAN_REFERENCE,
        SOCKET_PARAMETER,
        SOCKET_FIELD,
        SOCKET_ASSIGNMENT,
        SOCKET_INJECTOR,
        COMPONENT_MODULE_FIELD,
        COMPONENT_MODULE_NEW,
        COMPONENT_MODULE_BEAN_REFERENCE;

    }
}

