/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.wire;

import io.inverno.core.annotation.Wire;
import io.inverno.core.annotation.Wires;
import io.inverno.core.compiler.common.AbstractInfoFactory;
import io.inverno.core.compiler.spi.BeanInfo;
import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.BeanSocketQualifiedName;
import io.inverno.core.compiler.spi.ModuleBeanSocketInfo;
import io.inverno.core.compiler.spi.QualifiedNameFormatException;
import io.inverno.core.compiler.spi.ReporterInfo;
import io.inverno.core.compiler.spi.SocketBeanInfo;
import io.inverno.core.compiler.wire.ModuleBeanSocketWireInfo;
import io.inverno.core.compiler.wire.SocketBeanWireInfo;
import io.inverno.core.compiler.wire.WireInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.type.TypeMirror;

public class WireInfoFactory
extends AbstractInfoFactory {
    private Map<BeanQualifiedName, ? extends BeanInfo> beans;
    private Set<BeanSocketQualifiedName> beanSockets;
    private Map<BeanQualifiedName, ? extends SocketBeanInfo> requiredModuleSockets;
    private TypeMirror wireAnnotationType;
    private TypeMirror wiresAnnotationType;

    protected WireInfoFactory(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement, List<? extends BeanInfo> beans, List<? extends ModuleBeanSocketInfo> beanSockets, List<? extends SocketBeanInfo> requiredModuleSockets) {
        super(processingEnvironment, moduleElement);
        this.processingEnvironment = processingEnvironment;
        this.moduleElement = moduleElement;
        this.beans = beans.stream().collect(Collectors.toMap(beanInfo -> beanInfo.getQualifiedName(), Function.identity()));
        this.beanSockets = beanSockets.stream().map(ModuleBeanSocketInfo::getQualifiedName).collect(Collectors.toSet());
        this.requiredModuleSockets = requiredModuleSockets.stream().collect(Collectors.toMap(moduleSocketInfo -> moduleSocketInfo.getQualifiedName(), Function.identity()));
        this.wireAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement(Wire.class.getCanonicalName()).asType();
        this.wiresAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement(Wires.class.getCanonicalName()).asType();
    }

    public static WireInfoFactory create(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement, List<? extends BeanInfo> beans, List<? extends ModuleBeanSocketInfo> beanSockets, List<? extends SocketBeanInfo> requiredModuleSockets) {
        return new WireInfoFactory(processingEnvironment, moduleElement, beans, beanSockets, requiredModuleSockets);
    }

    public WireInfo<?> createWire(AnnotationMirror annotation) {
        Optional<AnnotationMirror> wiresOnModule;
        if (!this.processingEnvironment.getTypeUtils().isSameType(annotation.getAnnotationType(), this.wireAnnotationType)) {
            throw new IllegalArgumentException("The specified annotation is not a @" + Wire.class.getSimpleName() + " annotation");
        }
        Optional<AnnotationMirror> wireOnModule = this.moduleElement.getAnnotationMirrors().stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.wireAnnotationType)).findFirst();
        if (wireOnModule.isPresent() ? !wireOnModule.get().equals(annotation) : !(wiresOnModule = this.moduleElement.getAnnotationMirrors().stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.wiresAnnotationType)).findFirst()).isPresent() || !((Collection)wiresOnModule.get().getElementValues().values().iterator().next().getValue()).stream().map(v -> (AnnotationMirror)v.getValue()).anyMatch(a -> a.equals(annotation))) {
            throw new IllegalArgumentException("The specified @" + Wire.class.getSimpleName() + " annotation hasn't been declared on the module to build");
        }
        ReporterInfo wireReporter = this.getReporter(this.moduleElement, annotation);
        String[] beans = null;
        String into = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> value : this.processingEnvironment.getElementUtils().getElementValuesWithDefaults(annotation).entrySet()) {
            switch (value.getKey().getSimpleName().toString()) {
                case "beans": {
                    beans = (String[])((List)value.getValue().getValue()).stream().map(v -> v.getValue()).toArray(String[]::new);
                    break;
                }
                case "into": {
                    into = (String)value.getValue().getValue();
                }
            }
        }
        List beanQNamesList = Arrays.stream(beans).map(bean -> {
            try {
                return BeanQualifiedName.valueOf(bean);
            }
            catch (QualifiedNameFormatException e) {
                try {
                    return new BeanQualifiedName(this.moduleQName, (String)bean);
                }
                catch (QualifiedNameFormatException e1) {
                    wireReporter.error("Invalid bean qualified name: " + bean + ", expecting (<moduleName>):<beanName> with valid Java identifiers");
                    return null;
                }
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        String duplicateBeans = String.join((CharSequence)", ", beanQNamesList.stream().filter(beanQName -> Collections.frequency(beanQNamesList, beanQName) > 1).map(Object::toString).collect(Collectors.toSet()));
        if (duplicateBeans != null && !duplicateBeans.equals("")) {
            wireReporter.warning("The following beans are specified multiple times: " + duplicateBeans);
        }
        BeanQualifiedName[] beanQNames = (BeanQualifiedName[])new HashSet(beanQNamesList).stream().toArray(BeanQualifiedName[]::new);
        BeanSocketQualifiedName beanSocketQName = null;
        BeanQualifiedName moduleSocketQName = null;
        try {
            try {
                beanSocketQName = BeanSocketQualifiedName.valueOf(into);
            }
            catch (QualifiedNameFormatException e) {
                beanSocketQName = BeanSocketQualifiedName.valueOf(this.moduleQName, into);
            }
            if (!this.beanSockets.contains(beanSocketQName)) {
                beanSocketQName = null;
                throw new QualifiedNameFormatException();
            }
        }
        catch (QualifiedNameFormatException e) {
            try {
                moduleSocketQName = BeanQualifiedName.valueOf(into);
                if (moduleSocketQName.getModuleQName().equals(this.moduleQName)) {
                    wireReporter.error("You can't wire beans to a socket bean defined in the same module");
                    return null;
                }
            }
            catch (QualifiedNameFormatException e1) {
                wireReporter.error("Invalid socket qualified name: " + into + ", expecting (<moduleName>):<beanName>:<socketName> OR <moduleName>:<beanName> with valid Java identifiers");
                return null;
            }
        }
        if (beanSocketQName != null) {
            return new ModuleBeanSocketWireInfo(this.processingEnvironment, this.moduleElement, annotation, beanQNames, beanSocketQName);
        }
        if (!this.requiredModuleSockets.containsKey(moduleSocketQName)) {
            Arrays.stream(beanQNames).filter(beanQName -> !this.beans.containsKey(beanQName)).forEach(beanQName -> wireReporter.error("There's no bean named " + beanQName));
            wireReporter.error("There's no socket named: " + moduleSocketQName);
            return null;
        }
        return new SocketBeanWireInfo(this.processingEnvironment, this.moduleElement, annotation, beanQNames, moduleSocketQName);
    }
}

