/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.spi;

import io.inverno.core.compiler.spi.QualifiedName;
import io.inverno.core.compiler.spi.QualifiedNameFormatException;

public class ModuleQualifiedName
extends QualifiedName {
    private String moduleName;
    private String packageName;
    private String className;
    private String sourcePackageName;

    public ModuleQualifiedName(String packageName, String moduleName) throws QualifiedNameFormatException {
        this(packageName, moduleName, null, null);
    }

    public ModuleQualifiedName(String packageName, String moduleName, String className) throws QualifiedNameFormatException {
        this(packageName, moduleName, className, null);
    }

    public ModuleQualifiedName(String packageName, String moduleName, String className, String sourcePackageName) throws QualifiedNameFormatException {
        super((String)(packageName == null || packageName.equals("") ? "" : packageName + ".") + moduleName);
        this.packageName = packageName == null ? "" : packageName;
        this.moduleName = moduleName;
        this.className = className;
        this.sourcePackageName = sourcePackageName == null ? "" : sourcePackageName;
        this.validatePackageName(this.packageName);
        this.validatePackageName(this.sourcePackageName);
        this.validateQualifiedNamePart(this.moduleName);
    }

    private void validatePackageName(String packageName) throws QualifiedNameFormatException {
        if (!packageName.equals("")) {
            for (String packagePart : packageName.split("\\.")) {
                boolean start = true;
                for (char c : packagePart.toCharArray()) {
                    if (start) {
                        if (!Character.isJavaIdentifierStart(c)) {
                            throw new QualifiedNameFormatException("Package name must be a valid Java package name: " + packageName);
                        }
                        start = false;
                        continue;
                    }
                    if (Character.isJavaIdentifierPart(c)) continue;
                    throw new QualifiedNameFormatException("Package name must be a valid Java package name: " + packageName);
                }
            }
        }
    }

    public String getClassName() {
        if (this.className != null && !this.className.equals("")) {
            return this.className;
        }
        return this.getSourcePackageName() + "." + Character.toUpperCase(this.getModuleName().charAt(0)) + this.getModuleName().substring(1);
    }

    @Override
    public String getSimpleValue() {
        return this.getModuleName();
    }

    public String getSourcePackageName() {
        if (this.sourcePackageName != null && !this.sourcePackageName.equals("")) {
            return this.sourcePackageName;
        }
        return this.getValue();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public static ModuleQualifiedName valueOf(String qname) throws QualifiedNameFormatException {
        return ModuleQualifiedName.valueOf(qname, null);
    }

    public static ModuleQualifiedName valueOf(String qname, String className) throws QualifiedNameFormatException {
        return ModuleQualifiedName.valueOf(qname, className, null);
    }

    public static ModuleQualifiedName valueOf(String qname, String className, String sourcePackageName) throws QualifiedNameFormatException {
        int lastDotIndex = qname.lastIndexOf(".");
        if (lastDotIndex > -1) {
            return new ModuleQualifiedName(qname.substring(0, lastDotIndex), qname.substring(lastDotIndex + 1), className, sourcePackageName);
        }
        return new ModuleQualifiedName("", qname, className, sourcePackageName);
    }
}

