/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.socket;

import io.inverno.core.compiler.common.AbstractSocketInfoFactory;
import io.inverno.core.compiler.socket.BinarySocketBeanInfoFactory;
import io.inverno.core.compiler.socket.CompiledSocketBeanInfoFactory;
import io.inverno.core.compiler.socket.SocketCompilationException;
import io.inverno.core.compiler.socket.WirableSocketBeanInfo;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;

public abstract class SocketBeanInfoFactory
extends AbstractSocketInfoFactory {
    protected SocketBeanInfoFactory(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement) {
        super(processingEnvironment, moduleElement);
    }

    public static SocketBeanInfoFactory create(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement) {
        return new CompiledSocketBeanInfoFactory(processingEnvironment, moduleElement);
    }

    public static SocketBeanInfoFactory create(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement, ModuleElement requiredModuleElement, Integer version) {
        if (moduleElement.getDirectives().stream().noneMatch(directive -> directive.getKind().equals((Object)ModuleElement.DirectiveKind.REQUIRES) && ((ModuleElement.RequiresDirective)directive).getDependency().equals(requiredModuleElement))) {
            throw new IllegalArgumentException("The specified element is not required in module " + moduleElement.getQualifiedName().toString());
        }
        if (version == null) {
            throw new IllegalStateException("Version of required module can't be null");
        }
        switch (version) {
            case 1: {
                return new BinarySocketBeanInfoFactory(processingEnvironment, requiredModuleElement, moduleElement);
            }
        }
        throw new IllegalStateException("Unsupported version: " + version);
    }

    public abstract WirableSocketBeanInfo createSocketBean(Element var1) throws SocketCompilationException;
}

