/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.socket;

import io.inverno.core.compiler.common.AbstractBeanInfo;
import io.inverno.core.compiler.common.MutableSocketBeanInfo;
import io.inverno.core.compiler.socket.WirableSocketBeanInfo;
import io.inverno.core.compiler.spi.BeanQualifiedName;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

abstract class AbstractSocketBeanInfo
extends AbstractBeanInfo
implements MutableSocketBeanInfo,
WirableSocketBeanInfo {
    protected TypeMirror socketType;
    protected ExecutableElement socketElement;
    protected AnnotationMirror[] selectors;
    protected boolean optional;
    protected Set<BeanQualifiedName> wiredBeans;
    protected boolean wired;

    public AbstractSocketBeanInfo(ProcessingEnvironment processingEnvironment, Element element, BeanQualifiedName qname, TypeMirror type, TypeMirror socketType, ExecutableElement socketElement, AnnotationMirror[] selectors, boolean optional) {
        super(processingEnvironment, element, qname, type);
        this.socketType = socketType;
        this.socketElement = socketElement;
        this.selectors = selectors != null ? selectors : new AnnotationMirror[]{};
        this.optional = optional;
        this.wiredBeans = Collections.emptySet();
    }

    public AbstractSocketBeanInfo(ProcessingEnvironment processingEnvironment, Element element, AnnotationMirror annotation, BeanQualifiedName qname, TypeMirror type, TypeMirror socketType, AnnotationMirror[] selectors, boolean optional) {
        super(processingEnvironment, element, annotation, qname, type);
        this.socketType = socketType;
        this.selectors = selectors != null ? selectors : new AnnotationMirror[]{};
        this.optional = optional;
        this.wiredBeans = Collections.emptySet();
    }

    @Override
    public AnnotationMirror[] getSelectors() {
        return this.selectors;
    }

    @Override
    public TypeMirror getSocketType() {
        return this.socketType;
    }

    @Override
    public Optional<ExecutableElement> getSocketElement() {
        return Optional.ofNullable(this.socketElement);
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    @Override
    public void setWiredBeans(Set<BeanQualifiedName> wiredBeans) {
        this.wiredBeans = wiredBeans != null ? Collections.unmodifiableSet(wiredBeans) : Collections.emptySet();
    }

    @Override
    public BeanQualifiedName[] getWiredBeans() {
        return (BeanQualifiedName[])this.wiredBeans.stream().toArray(BeanQualifiedName[]::new);
    }

    @Override
    public void setWired(boolean wired) {
        this.wired = wired;
    }

    @Override
    public boolean isWired() {
        return this.wired;
    }
}

