/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.bean;

import io.inverno.core.annotation.NestedBean;
import io.inverno.core.compiler.bean.CommonNestedBeanInfo;
import io.inverno.core.compiler.spi.BeanInfo;
import io.inverno.core.compiler.spi.NestedBeanInfo;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;
import javax.tools.Diagnostic;

public class NestedBeanInfoFactory {
    private ProcessingEnvironment processingEnvironment;

    public NestedBeanInfoFactory(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
    }

    public List<? extends NestedBeanInfo> create(BeanInfo providingBean) {
        if (!(providingBean.getType() instanceof DeclaredType)) {
            return List.of();
        }
        DeclaredType type = (DeclaredType)providingBean.getType();
        return this.processingEnvironment.getElementUtils().getAllMembers((TypeElement)type.asElement()).stream().filter(e -> e.getAnnotation(NestedBean.class) != null).map(e -> (ExecutableElement)e).filter(e -> {
            boolean valid = true;
            if (e.getParameters().size() > 0) {
                this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Ignoring invalid " + NestedBean.class.getSimpleName() + " which should be defined as a no-argument method", (Element)e);
                valid = false;
            }
            if (e.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Ignoring invalid " + NestedBean.class.getSimpleName() + " which should be defined as a non-void method", (Element)e);
                valid = false;
            }
            return valid;
        }).map(e -> {
            ExecutableType ras;
            CommonNestedBeanInfo nestedBeanInfo = null;
            DeclaredType nestedBeanType = null;
            if (e.getReturnType() instanceof DeclaredType) {
                nestedBeanType = (DeclaredType)e.getReturnType();
            } else if (e.getReturnType() instanceof TypeVariable && (ras = (ExecutableType)this.processingEnvironment.getTypeUtils().asMemberOf(type, (Element)e)).getReturnType() instanceof DeclaredType) {
                nestedBeanType = (DeclaredType)ras.getReturnType();
            }
            if (nestedBeanType != null) {
                nestedBeanInfo = new CommonNestedBeanInfo(this.processingEnvironment, (ExecutableElement)e, providingBean, nestedBeanType);
            }
            return nestedBeanInfo;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

