/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.bean;

import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.BeanSocket;
import io.inverno.core.annotation.Destroy;
import io.inverno.core.annotation.Init;
import io.inverno.core.annotation.Overridable;
import io.inverno.core.annotation.Provide;
import io.inverno.core.annotation.Wrapper;
import io.inverno.core.compiler.TypeErrorException;
import io.inverno.core.compiler.bean.BeanCompilationException;
import io.inverno.core.compiler.bean.CommonModuleBeanInfo;
import io.inverno.core.compiler.bean.CompiledOverridableBeanInfo;
import io.inverno.core.compiler.bean.CompiledOverridingSocketBeanInfo;
import io.inverno.core.compiler.bean.CompiledWrapperBeanInfo;
import io.inverno.core.compiler.bean.ModuleBeanInfoFactory;
import io.inverno.core.compiler.bean.ModuleBeanSocketInfoFactory;
import io.inverno.core.compiler.bean.NestedBeanInfoFactory;
import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.BeanSocketQualifiedName;
import io.inverno.core.compiler.spi.ModuleBeanInfo;
import io.inverno.core.compiler.spi.ModuleBeanSocketInfo;
import io.inverno.core.compiler.spi.QualifiedNameFormatException;
import io.inverno.core.compiler.spi.ReporterInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

class CompiledModuleBeanInfoFactory
extends ModuleBeanInfoFactory {
    private TypeMirror beanAnnotationType;
    private TypeMirror provideAnnotationType;
    private TypeMirror wrapperAnnotationType;
    private TypeMirror overridableAnnotationType;
    private TypeMirror supplierType;
    private NestedBeanInfoFactory nestedBeanFactory;

    CompiledModuleBeanInfoFactory(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement) {
        super(processingEnvironment, moduleElement);
        this.beanAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement(Bean.class.getCanonicalName()).asType();
        this.provideAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement(Provide.class.getCanonicalName()).asType();
        this.wrapperAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement(Wrapper.class.getCanonicalName()).asType();
        this.overridableAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement(Overridable.class.getCanonicalName()).asType();
        this.supplierType = this.processingEnvironment.getTypeUtils().erasure(this.processingEnvironment.getElementUtils().getTypeElement(Supplier.class.getCanonicalName()).asType());
        this.nestedBeanFactory = new NestedBeanInfoFactory(this.processingEnvironment);
    }

    @Override
    public ModuleBeanInfo createBean(Element element) throws BeanCompilationException {
        CommonModuleBeanInfo moduleBeanInfo;
        List optionalSocketElements;
        List list;
        BeanQualifiedName beanQName;
        TypeElement typeElement;
        if (!TypeElement.class.isAssignableFrom(element.getClass())) {
            throw new IllegalArgumentException("Element must be a TypeElement");
        }
        if (!element.getKind().equals((Object)ElementKind.CLASS)) {
            throw new IllegalArgumentException("Element must be a Class");
        }
        for (Element moduleElement = typeElement = (TypeElement)element; moduleElement != null; moduleElement = moduleElement.getEnclosingElement()) {
            if (!(moduleElement instanceof ModuleElement) || moduleElement.equals(this.moduleElement)) continue;
            throw new IllegalArgumentException("The specified element doesn't belong to module " + this.moduleQName);
        }
        Optional<AnnotationMirror> beanAnnotation = typeElement.getAnnotationMirrors().stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.beanAnnotationType)).findFirst();
        if (!beanAnnotation.isPresent()) {
            throw new IllegalArgumentException("The specified element is not annotated with " + Bean.class.getSimpleName());
        }
        ReporterInfo beanReporter = this.getReporter(typeElement, beanAnnotation.get());
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            beanReporter.error("A bean must be a concrete class");
            throw new BeanCompilationException();
        }
        Object name = null;
        Bean.Visibility visibility = null;
        Bean.Strategy strategy = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> value : this.processingEnvironment.getElementUtils().getElementValuesWithDefaults(beanAnnotation.get()).entrySet()) {
            switch (value.getKey().getSimpleName().toString()) {
                case "name": {
                    name = (String)value.getValue().getValue();
                    break;
                }
                case "visibility": {
                    visibility = Bean.Visibility.valueOf((String)value.getValue().getValue().toString());
                    break;
                }
                case "strategy": {
                    strategy = Bean.Strategy.valueOf((String)value.getValue().getValue().toString());
                }
            }
        }
        if (name == null || ((String)name).equals("")) {
            name = typeElement.getSimpleName().toString();
            name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
        }
        try {
            beanQName = new BeanQualifiedName(this.moduleQName, (String)name);
        }
        catch (QualifiedNameFormatException e2) {
            beanReporter.error("Invalid bean qualified name: " + e2.getMessage());
            throw new BeanCompilationException();
        }
        TypeMirror beanType = typeElement.asType();
        TypeMirror providedType = null;
        Optional<AnnotationMirror> provideAnnotation = typeElement.getAnnotationMirrors().stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.provideAnnotationType)).findFirst();
        if (provideAnnotation.isPresent()) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> value : this.processingEnvironment.getElementUtils().getElementValuesWithDefaults(provideAnnotation.get()).entrySet()) {
                switch (value.getKey().getSimpleName().toString()) {
                    case "value": {
                        providedType = (TypeMirror)value.getValue().getValue();
                    }
                }
            }
        }
        List provideAnnotatedSuperTypes = this.processingEnvironment.getTypeUtils().directSupertypes(beanType).stream().filter(superType -> superType.getAnnotationMirrors().stream().anyMatch(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.provideAnnotationType))).collect(Collectors.toList());
        if (providedType != null && provideAnnotatedSuperTypes.size() == 1 || provideAnnotatedSuperTypes.size() > 1) {
            beanReporter.error("Bean " + beanQName + " can't provide multiple types");
        } else if (provideAnnotatedSuperTypes.size() == 1) {
            TypeMirror[] superTypeArguments = (TypeMirror[])((DeclaredType)provideAnnotatedSuperTypes.get(0)).getTypeArguments().stream().toArray(TypeMirror[]::new);
            TypeElement superTypeElement = (TypeElement)((DeclaredType)this.processingEnvironment.getTypeUtils().erasure((TypeMirror)provideAnnotatedSuperTypes.get(0))).asElement();
            providedType = this.processingEnvironment.getTypeUtils().getDeclaredType(superTypeElement, superTypeArguments);
            provideAnnotation = ((TypeMirror)provideAnnotatedSuperTypes.get(0)).getAnnotationMirrors().stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.provideAnnotationType)).findFirst();
        }
        List<ExecutableElement> initElements = typeElement.getEnclosedElements().stream().filter(e -> e.getAnnotation(Init.class) != null).map(e -> (ExecutableElement)e).filter(e -> {
            if (e.getParameters().size() > 0) {
                this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Invalid " + Init.class.getSimpleName() + " method which should be a no-argument method, it will be ignored", (Element)e);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        List<ExecutableElement> destroyElements = typeElement.getEnclosedElements().stream().filter(e -> e.getAnnotation(Destroy.class) != null).map(e -> (ExecutableElement)e).filter(e -> {
            if (e.getParameters().size() > 0) {
                this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Invalid " + Destroy.class.getSimpleName() + " method which should be a no-argument method, it will be ignored", (Element)e);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        ArrayList beanSocketInfos = new ArrayList();
        HashMap requiredSocketByName = new HashMap();
        ModuleBeanSocketInfoFactory beanSocketFactory = ModuleBeanSocketInfoFactory.create(this.processingEnvironment, this.moduleElement, beanQName);
        ExecutableElement constructorSocketElement = null;
        List constructorSocketElements = typeElement.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.CONSTRUCTOR)).filter(e -> e.getModifiers().stream().anyMatch(m -> m.equals((Object)Modifier.PUBLIC))).map(e -> (ExecutableElement)e).collect(Collectors.toList());
        if (constructorSocketElements.size() == 0) {
            beanReporter.error("No public constructor defined in bean " + beanQName);
        } else if (constructorSocketElements.size() == 1) {
            constructorSocketElement = (ExecutableElement)constructorSocketElements.get(0);
        } else if ((constructorSocketElements = constructorSocketElements.stream().filter(e -> e.getAnnotation(BeanSocket.class) != null).collect(Collectors.toList())).size() == 0) {
            beanReporter.error("Multiple constructors are defined in module bean " + beanQName + ", consider specifying a " + BeanSocket.class.getSimpleName() + " on the one to select");
        } else if (constructorSocketElements.size() == 1) {
            constructorSocketElement = (ExecutableElement)constructorSocketElements.get(0);
        } else {
            beanReporter.error("Multiple constructors annotated with " + BeanSocket.class.getSimpleName() + " are defined in module bean " + beanQName + " which is not permitted");
        }
        if (constructorSocketElement != null) {
            for (VariableElement variableElement : constructorSocketElement.getParameters()) {
                try {
                    beanSocketFactory.createBeanSocket(variableElement).ifPresent(requiredBeanSocket -> {
                        requiredSocketByName.put(requiredBeanSocket.getQualifiedName().getName(), requiredBeanSocket);
                        beanSocketInfos.add(requiredBeanSocket);
                    });
                }
                catch (TypeErrorException e1) {
                    beanReporter.error("Invalid required socket " + variableElement.getSimpleName().toString() + " : Type " + e1.getType() + " could not be resolved");
                }
            }
        }
        if ((list = (optionalSocketElements = typeElement.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.METHOD) && e.getSimpleName().toString().startsWith("set")).filter(e -> e.getModifiers().stream().anyMatch(m -> m.equals((Object)Modifier.PUBLIC))).map(e -> (ExecutableElement)e).collect(Collectors.toList())).stream().filter(e -> e.getAnnotation(BeanSocket.class) != null).collect(Collectors.toList())).size() > 0) {
            optionalSocketElements = list;
        }
        Predicate<ModuleBeanSocketInfo> requiredSocketConflictPredicate = optionalBeanSocketInfo -> {
            if (requiredSocketByName.containsKey(optionalBeanSocketInfo.getQualifiedName().getName())) {
                ((ModuleBeanSocketInfo)requiredSocketByName.get(optionalBeanSocketInfo.getQualifiedName().getName())).error("Required socket name is conflicting with an optional socket: " + optionalBeanSocketInfo.getQualifiedName().getName());
                optionalBeanSocketInfo.error("Optional socket name is conflicting with a required socket: " + optionalBeanSocketInfo.getQualifiedName().getName());
                return false;
            }
            return true;
        };
        for (List<ExecutableElement> socketElementsBySocketName : optionalSocketElements.stream().collect(Collectors.groupingBy(ExecutableElement::getSimpleName)).values()) {
            if (socketElementsBySocketName.size() > 1) {
                ArrayList optionalModuleSocketInfos = new ArrayList();
                for (ExecutableElement socketElement : socketElementsBySocketName) {
                    try {
                        beanSocketFactory.createBeanSocket(socketElement.getParameters().get(0)).ifPresent(optionalModuleSocketInfos::add);
                    }
                    catch (TypeErrorException e1) {
                        this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Ignoring invalid optional socket: Type " + e1.getType() + " could not be resolved", socketElement);
                    }
                }
                Map<BeanSocketQualifiedName, List<ModuleBeanSocketInfo>> socketInfosByName = optionalModuleSocketInfos.stream().collect(Collectors.groupingBy(ModuleBeanSocketInfo::getQualifiedName));
                socketInfosByName.values().stream().filter(socketInfos -> socketInfos.size() > 1).forEach(socketInfos -> socketInfos.forEach(socketInfo -> socketInfo.error("Optional socket name is conflicting with another optional socket: " + socketInfo.getQualifiedName().getName())));
                socketInfosByName.values().stream().filter(socketInfos -> socketInfos.size() == 1).map(socketInfos -> (ModuleBeanSocketInfo)socketInfos.get(0)).filter(requiredSocketConflictPredicate).forEach(beanSocketInfos::add);
                continue;
            }
            try {
                beanSocketFactory.createBeanSocket(socketElementsBySocketName.get(0).getParameters().get(0)).filter(requiredSocketConflictPredicate).ifPresent(beanSocketInfos::add);
            }
            catch (TypeErrorException e1) {
                this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Ignoring invalid optional socket: Type " + e1.getType() + " could not be resolved", socketElementsBySocketName.get(0));
            }
        }
        Optional<AnnotationMirror> wrapperAnnotation = this.processingEnvironment.getElementUtils().getAllAnnotationMirrors(typeElement).stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.wrapperAnnotationType)).findFirst();
        TypeMirror wrapperType = null;
        if (wrapperAnnotation.isPresent()) {
            wrapperType = beanType;
            Optional<TypeMirror> supplierType = typeElement.getInterfaces().stream().filter(t -> this.processingEnvironment.getTypeUtils().isSameType(this.processingEnvironment.getTypeUtils().erasure((TypeMirror)t), this.supplierType)).findFirst();
            if (supplierType.isPresent()) {
                beanType = ((DeclaredType)supplierType.get()).getTypeArguments().size() == 0 ? this.processingEnvironment.getElementUtils().getTypeElement(Object.class.getCanonicalName()).asType() : ((DeclaredType)supplierType.get()).getTypeArguments().get(0);
            } else {
                beanReporter.error("A wrapper bean element must extend " + Supplier.class.getCanonicalName());
            }
            moduleBeanInfo = new CompiledWrapperBeanInfo(this.processingEnvironment, typeElement, beanAnnotation.get(), beanQName, wrapperType, beanType, providedType, visibility, strategy, initElements, destroyElements, beanSocketInfos);
        } else {
            moduleBeanInfo = new CommonModuleBeanInfo(this.processingEnvironment, typeElement, beanAnnotation.get(), beanQName, beanType, providedType, visibility, strategy, initElements, destroyElements, beanSocketInfos);
        }
        if (moduleBeanInfo.getProvidedType() != null && !this.processingEnvironment.getTypeUtils().isAssignable(moduleBeanInfo.getType(), moduleBeanInfo.getProvidedType())) {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Type " + providedType + " is incompatible with bean type " + moduleBeanInfo.getType(), typeElement, provideAnnotation.get());
            throw new BeanCompilationException();
        }
        ModuleBeanInfo resultModuleBeanInfo = moduleBeanInfo;
        Optional<AnnotationMirror> overridableAnnotation = this.processingEnvironment.getElementUtils().getAllAnnotationMirrors(typeElement).stream().filter(a -> this.processingEnvironment.getTypeUtils().isSameType(a.getAnnotationType(), this.overridableAnnotationType)).findFirst();
        if (overridableAnnotation.isPresent()) {
            CompiledOverridingSocketBeanInfo socketInfo = new CompiledOverridingSocketBeanInfo(this.processingEnvironment, typeElement, overridableAnnotation.get(), (BeanQualifiedName)moduleBeanInfo.getQualifiedName(), moduleBeanInfo.getType());
            resultModuleBeanInfo = new CompiledOverridableBeanInfo(moduleBeanInfo, socketInfo);
        }
        moduleBeanInfo.setNestedBeanInfos(this.nestedBeanFactory.create(resultModuleBeanInfo));
        if (beanReporter.hasError()) {
            throw new BeanCompilationException();
        }
        return resultModuleBeanInfo;
    }
}

