/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.bean;

import io.inverno.core.annotation.Bean;
import io.inverno.core.compiler.common.AbstractBeanInfo;
import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.ModuleBeanInfo;
import io.inverno.core.compiler.spi.ModuleBeanSocketInfo;
import io.inverno.core.compiler.spi.NestedBeanInfo;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

class CommonModuleBeanInfo
extends AbstractBeanInfo
implements ModuleBeanInfo {
    private Bean.Visibility visibility;
    private Bean.Strategy strategy;
    private List<ExecutableElement> initElements;
    private List<ExecutableElement> destroyElements;
    private List<? extends NestedBeanInfo> nestedBeanInfos;
    private List<? extends ModuleBeanSocketInfo> socketInfos;
    private TypeMirror providedType;

    public CommonModuleBeanInfo(ProcessingEnvironment processingEnvironment, Element element, AnnotationMirror annotation, BeanQualifiedName qname, TypeMirror type, TypeMirror providedType, List<? extends ModuleBeanSocketInfo> beanSocketInfos) {
        this(processingEnvironment, element, annotation, qname, type, providedType, Bean.Visibility.PUBLIC, Bean.Strategy.SINGLETON, null, null, beanSocketInfos);
    }

    public CommonModuleBeanInfo(ProcessingEnvironment processingEnvironment, Element element, AnnotationMirror annotation, BeanQualifiedName qname, TypeMirror type, TypeMirror providedType, Bean.Visibility visibility, Bean.Strategy strategy, List<ExecutableElement> initElements, List<ExecutableElement> destroyElements, List<? extends ModuleBeanSocketInfo> beanSocketInfos) {
        super(processingEnvironment, element, annotation, qname, type);
        this.providedType = providedType;
        this.visibility = visibility != null ? visibility : Bean.Visibility.PUBLIC;
        this.strategy = strategy != null ? strategy : Bean.Strategy.SINGLETON;
        this.initElements = initElements != null ? Collections.unmodifiableList(initElements) : Collections.emptyList();
        this.destroyElements = destroyElements != null ? Collections.unmodifiableList(destroyElements) : Collections.emptyList();
        this.nestedBeanInfos = Collections.emptyList();
        this.socketInfos = beanSocketInfos != null ? Collections.unmodifiableList(beanSocketInfos) : Collections.emptyList();
    }

    @Override
    public TypeMirror getProvidedType() {
        return this.providedType;
    }

    @Override
    public Bean.Strategy getStrategy() {
        return this.strategy;
    }

    @Override
    public Bean.Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public ExecutableElement[] getInitElements() {
        return (ExecutableElement[])this.initElements.stream().toArray(ExecutableElement[]::new);
    }

    @Override
    public ExecutableElement[] getDestroyElements() {
        return (ExecutableElement[])this.destroyElements.stream().toArray(ExecutableElement[]::new);
    }

    @Override
    public ModuleBeanSocketInfo[] getSockets() {
        return (ModuleBeanSocketInfo[])this.socketInfos.stream().toArray(ModuleBeanSocketInfo[]::new);
    }

    @Override
    public ModuleBeanSocketInfo[] getRequiredSockets() {
        return (ModuleBeanSocketInfo[])this.socketInfos.stream().filter(socketInfo -> !socketInfo.isOptional()).toArray(ModuleBeanSocketInfo[]::new);
    }

    @Override
    public ModuleBeanSocketInfo[] getOptionalSockets() {
        return (ModuleBeanSocketInfo[])this.socketInfos.stream().filter(socketInfo -> socketInfo.isOptional()).toArray(ModuleBeanSocketInfo[]::new);
    }

    void setNestedBeanInfos(List<? extends NestedBeanInfo> nestedBeanInfos) {
        this.nestedBeanInfos = nestedBeanInfos != null ? Collections.unmodifiableList(nestedBeanInfos) : Collections.emptyList();
    }

    @Override
    public NestedBeanInfo[] getNestedBeans() {
        return (NestedBeanInfo[])this.nestedBeanInfos.stream().toArray(NestedBeanInfo[]::new);
    }
}

