/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.wire;

import io.inverno.core.annotation.Wire;
import io.inverno.core.compiler.spi.BeanInfo;
import io.inverno.core.compiler.spi.BeanQualifiedName;
import io.inverno.core.compiler.spi.ModuleBeanSocketInfo;
import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.MultiSocketInfo;
import io.inverno.core.compiler.spi.QualifiedName;
import io.inverno.core.compiler.spi.SingleSocketInfo;
import io.inverno.core.compiler.spi.SocketInfo;
import io.inverno.core.compiler.spi.WiringStrategy;
import io.inverno.core.compiler.wire.AnnotationSelectorWiringStrategy;
import io.inverno.core.compiler.wire.TypeWiringStrategy;
import io.inverno.core.compiler.wire.WireInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;

public class SocketResolver {
    private ProcessingEnvironment processingEnvironment;
    private ModuleQualifiedName moduleQName;
    private List<? extends BeanInfo> beans;
    private Map<BeanQualifiedName, List<BeanInfo>> beansByQName;
    private List<WiringStrategy> selectorWiringStrategies;

    public SocketResolver(ProcessingEnvironment processingEnvironment, ModuleQualifiedName moduleQName, List<? extends BeanInfo> beans) {
        this.processingEnvironment = processingEnvironment;
        this.moduleQName = moduleQName;
        this.beans = beans;
        this.beansByQName = beans.stream().collect(Collectors.groupingBy(bean -> bean.getQualifiedName()));
        this.selectorWiringStrategies = List.of(new TypeWiringStrategy(this.processingEnvironment, this.moduleQName), new AnnotationSelectorWiringStrategy(this.processingEnvironment));
    }

    private boolean isWirable(BeanInfo bean, SocketInfo socket) {
        return this.selectorWiringStrategies.stream().allMatch(strategy -> strategy.isWirable(bean, socket));
    }

    private BeanInfo[] resolveByExplicitWiring(SocketInfo socket, WireInfo<?> wire) {
        ArrayList<BeanInfo> result = new ArrayList<BeanInfo>();
        for (BeanQualifiedName wiredBeanQName : wire.getBeans()) {
            if (this.beansByQName.containsKey(wiredBeanQName)) {
                List<BeanInfo> beans = this.beansByQName.get(wiredBeanQName);
                if (beans.size() > 1) {
                    wire.error("Can't wire different beans with same name " + wiredBeanQName + " into " + socket.getQualifiedName());
                    continue;
                }
                BeanInfo bean = beans.get(0);
                if (this.isWirable(bean, socket)) {
                    result.add(bean);
                    continue;
                }
                wire.error("Bean " + bean.getQualifiedName() + " of type " + bean.getType() + " is not wirable into socket " + socket.getQualifiedName() + " of type " + socket.getType());
                continue;
            }
            wire.error("There's no bean named " + wiredBeanQName + " that can be wired to " + socket.getQualifiedName());
        }
        return (BeanInfo[])result.stream().toArray(BeanInfo[]::new);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BeanInfo[] resolve(MultiSocketInfo socket, List<? extends WireInfo<?>> socketWires) {
        BeanInfo[] result = null;
        if (socketWires != null) {
            List wires = socketWires.stream().filter(wire -> ((QualifiedName)wire.getInto()).equals(socket.getQualifiedName())).collect(Collectors.toList());
            if (wires.size() == 1) {
                WireInfo wire2 = (WireInfo)wires.get(0);
                BeanInfo[] explicitWiredBeans = this.resolveByExplicitWiring(socket, wire2);
                if (explicitWiredBeans.length <= 0) return null;
                result = explicitWiredBeans;
            } else if (wires.size() > 1) {
                Iterator iterator = wires.iterator();
                while (iterator.hasNext()) {
                    WireInfo wire3 = (WireInfo)iterator.next();
                    wire3.error("Multiple wires targeting socket " + socket.getQualifiedName() + " were found");
                }
                return null;
            }
        }
        if (result == null) {
            List matchingBeans = this.beans.stream().filter(beanInfo -> this.isWirable((BeanInfo)beanInfo, socket)).collect(Collectors.toList());
            if (matchingBeans.size() == 0) {
                if (!socket.isOptional()) {
                    socket.error("No bean was found matching required socket " + socket.getQualifiedName() + " of type " + socket.getType() + ", consider defining a bean or socket bean matching the socket in module " + this.moduleQName);
                    return null;
                } else {
                    socket.warning("No bean was found matching optional socket " + socket.getQualifiedName() + " of type " + socket.getType() + ", socket will be empty");
                }
                return null;
            }
            result = (BeanInfo[])matchingBeans.stream().toArray(BeanInfo[]::new);
        }
        if (!(socket instanceof ModuleBeanSocketInfo)) return result;
        return (BeanInfo[])Arrays.stream(result).filter(beanInfo -> !beanInfo.getQualifiedName().equals(((ModuleBeanSocketInfo)((Object)socket)).getQualifiedName().getBeanQName())).toArray(BeanInfo[]::new);
    }

    /*
     * Enabled aggressive block sorting
     */
    public BeanInfo resolve(SingleSocketInfo socket, List<? extends WireInfo<?>> socketWires) {
        BeanInfo result = null;
        if (socketWires != null) {
            List wires = socketWires.stream().filter(wire -> ((QualifiedName)wire.getInto()).equals(socket.getQualifiedName())).collect(Collectors.toList());
            if (wires.size() == 1) {
                WireInfo wire2 = (WireInfo)wires.get(0);
                if (wire2.getBeans().length > 1) {
                    ((WireInfo)wires.get(0)).error("Can't wire multiple beans in single socket " + socket.getQualifiedName());
                    return null;
                }
                BeanInfo[] explicitWiredBeans = this.resolveByExplicitWiring(socket, wire2);
                if (explicitWiredBeans.length != 1) {
                    if (explicitWiredBeans.length <= 1) return null;
                    wire2.error("Can't wire multiple beans in single socket " + socket.getQualifiedName());
                    return null;
                }
                result = explicitWiredBeans[0];
            } else if (wires.size() > 1) {
                Iterator wire2 = wires.iterator();
                while (wire2.hasNext()) {
                    WireInfo wire3 = (WireInfo)wire2.next();
                    wire3.error("Multiple wires targeting socket " + socket.getQualifiedName() + " were found");
                }
                return null;
            }
        }
        if (result != null) return result;
        List matchingBeans = this.beans.stream().filter(beanInfo -> this.isWirable((BeanInfo)beanInfo, socket) && (!(socket instanceof ModuleBeanSocketInfo) || !beanInfo.getQualifiedName().equals(((ModuleBeanSocketInfo)((Object)socket)).getQualifiedName().getBeanQName()))).collect(Collectors.toList());
        if (matchingBeans.size() == 0) {
            if (!socket.isOptional()) {
                socket.error("No bean was found matching required socket " + socket.getQualifiedName() + " of type " + socket.getType() + ", consider defining a bean or a socket bean matching the socket in module " + this.moduleQName);
                return null;
            }
            socket.warning("No bean was found matching optional socket " + socket.getQualifiedName() + " of type " + socket.getType() + ", socket will be null");
            return null;
        }
        if (matchingBeans.size() <= 1) return (BeanInfo)matchingBeans.get(0);
        StringBuilder message = new StringBuilder();
        message.append("Multiple beans matching socket " + socket.getQualifiedName() + " were found\n");
        message.append(matchingBeans.stream().map(matchingBean -> "- " + matchingBean.getQualifiedName() + " of type " + matchingBean.getType() + "\n").collect(Collectors.joining()));
        message.append("\nConsider specifying an explicit wiring in module " + this.moduleQName + " (eg. @" + Wire.class.getCanonicalName() + "(beans=\"" + ((BeanInfo)matchingBeans.get(0)).getQualifiedName() + "\", into=\"" + socket.getQualifiedName() + "\") )\n ");
        socket.error(message.toString());
        return null;
    }
}

