/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.module;

import io.inverno.core.compiler.module.BinaryModuleInfoBuilder;
import io.inverno.core.compiler.module.CompiledModuleInfoBuilder;
import io.inverno.core.compiler.spi.ModuleInfoBuilder;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ModuleElement;

public abstract class ModuleInfoBuilderFactory {
    public static ModuleInfoBuilder createModuleBuilder(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement) {
        return new CompiledModuleInfoBuilder(processingEnvironment, moduleElement);
    }

    public static ModuleInfoBuilder createModuleBuilder(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement, ModuleElement requiredModuleElement, Integer version) {
        if (moduleElement.getDirectives().stream().noneMatch(directive -> directive.getKind().equals((Object)ModuleElement.DirectiveKind.REQUIRES) && ((ModuleElement.RequiresDirective)directive).getDependency().equals(requiredModuleElement))) {
            throw new IllegalArgumentException("The specified element is not required in module " + moduleElement.getQualifiedName().toString());
        }
        if (version == null) {
            throw new IllegalStateException("Version of required module can't be null");
        }
        switch (version) {
            case 1: {
                return new BinaryModuleInfoBuilder(processingEnvironment, requiredModuleElement);
            }
        }
        throw new IllegalStateException("Unsupported version: " + version);
    }
}

