/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.core.compiler.module;

import io.inverno.core.annotation.Wire;
import io.inverno.core.annotation.Wires;
import io.inverno.core.compiler.common.MutableMultiSocketInfo;
import io.inverno.core.compiler.common.MutableSingleSocketInfo;
import io.inverno.core.compiler.common.MutableSocketBeanInfo;
import io.inverno.core.compiler.cycle.BeanCycleDetector;
import io.inverno.core.compiler.module.AbstractModuleInfoBuilder;
import io.inverno.core.compiler.module.CompiledModuleInfo;
import io.inverno.core.compiler.module.ModuleBeanSocketWireResolver;
import io.inverno.core.compiler.socket.WirableSocketBeanInfo;
import io.inverno.core.compiler.spi.BeanInfo;
import io.inverno.core.compiler.spi.Info;
import io.inverno.core.compiler.spi.ModuleBeanInfo;
import io.inverno.core.compiler.spi.ModuleBeanSocketInfo;
import io.inverno.core.compiler.spi.ModuleInfo;
import io.inverno.core.compiler.spi.ModuleInfoBuilder;
import io.inverno.core.compiler.spi.ModuleQualifiedName;
import io.inverno.core.compiler.spi.MultiSocketInfo;
import io.inverno.core.compiler.spi.NestedBeanInfo;
import io.inverno.core.compiler.spi.QualifiedName;
import io.inverno.core.compiler.spi.SingleSocketInfo;
import io.inverno.core.compiler.spi.SocketBeanInfo;
import io.inverno.core.compiler.spi.SocketInfo;
import io.inverno.core.compiler.wire.SocketResolver;
import io.inverno.core.compiler.wire.WireInfo;
import io.inverno.core.compiler.wire.WireInfoFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

class CompiledModuleInfoBuilder
extends AbstractModuleInfoBuilder {
    private ModuleBeanInfo[] beans;
    private SocketBeanInfo[] sockets;
    private ModuleInfo[] modules;
    private ModuleBeanSocketWireResolver moduleSocketWiredBeansResolver = new ModuleBeanSocketWireResolver();

    public CompiledModuleInfoBuilder(ProcessingEnvironment processingEnvironment, ModuleElement moduleElement) {
        super(processingEnvironment, moduleElement);
        this.beans = new ModuleBeanInfo[0];
        this.sockets = new SocketBeanInfo[0];
        this.modules = new ModuleInfo[0];
    }

    @Override
    public ModuleQualifiedName getQualifiedName() {
        return this.moduleQName;
    }

    @Override
    public ModuleInfoBuilder beans(ModuleBeanInfo[] beans) {
        this.beans = beans != null ? beans : new ModuleBeanInfo[]{};
        return this;
    }

    @Override
    public ModuleInfoBuilder sockets(SocketBeanInfo[] sockets) {
        this.sockets = sockets != null ? sockets : new SocketBeanInfo[]{};
        Arrays.stream(this.sockets).forEach(socket -> ((MutableSocketBeanInfo)socket).setOptional(true));
        return this;
    }

    @Override
    public ModuleInfoBuilder modules(ModuleInfo[] modules) {
        this.modules = modules != null ? modules : new ModuleInfo[]{};
        return this;
    }

    @Override
    public ModuleInfo build() {
        boolean hasNameConflicts = this.checkNameConflicts();
        boolean socketsResolved = this.resolveSockets();
        boolean hasBeanCycles = this.checkBeanCycles();
        CompiledModuleInfo moduleInfo = new CompiledModuleInfo(this.processingEnvironment, this.moduleElement, this.moduleAnnotation, this.moduleQName, this.version, Arrays.asList(this.beans), Arrays.asList(this.sockets), Arrays.asList(this.modules));
        moduleInfo.setFaulty(hasNameConflicts || hasBeanCycles || !socketsResolved);
        if (!hasBeanCycles) {
            moduleInfo.accept(this.moduleSocketWiredBeansResolver, null);
        }
        this.checkUnwiredSockets();
        return moduleInfo;
    }

    private boolean checkNameConflicts() {
        ArrayList<BeanInfo> moduleBeanInfos = new ArrayList<BeanInfo>();
        moduleBeanInfos.addAll(Arrays.asList(this.beans));
        moduleBeanInfos.addAll(Arrays.stream(this.beans).flatMap(beanInfo -> this.extractNestedBeans((BeanInfo)beanInfo)).collect(Collectors.toList()));
        moduleBeanInfos.addAll(Arrays.asList(this.sockets));
        moduleBeanInfos.addAll(Arrays.stream(this.sockets).flatMap(socketInfo -> this.extractNestedBeans((BeanInfo)socketInfo)).collect(Collectors.toList()));
        Map<String, List<BeanInfo>> beansByName = moduleBeanInfos.stream().collect(Collectors.groupingBy(beanInfo -> beanInfo.getQualifiedName().getBeanName()));
        List moduleNames = Arrays.stream(this.modules).map(moduleInfo -> moduleInfo.getQualifiedName().getValue()).collect(Collectors.toList());
        boolean hasConflicts = false;
        for (Map.Entry<String, List<BeanInfo>> e : beansByName.entrySet()) {
            if (e.getValue().size() > 1) {
                e.getValue().stream().forEach(beanInfo -> beanInfo.error("Multiple beans with name " + (String)e.getKey() + " exist in module " + this.moduleQName));
                hasConflicts = true;
            }
            if (!moduleNames.contains(e.getKey())) continue;
            e.getValue().stream().forEach(beanInfo -> beanInfo.error("Bean is conflicting with module: " + (String)e.getKey()));
            hasConflicts = true;
        }
        return hasConflicts;
    }

    private List<WireInfo<?>> extractWireInfos() {
        ArrayList result = new ArrayList();
        List<ModuleBeanInfo> wirableBeans = new ArrayList<ModuleBeanInfo>();
        wirableBeans.addAll(Arrays.asList(this.beans));
        wirableBeans.addAll(Arrays.stream(this.beans).flatMap(beanInfo -> this.extractNestedBeans((BeanInfo)beanInfo)).collect(Collectors.toList()));
        wirableBeans.addAll(Arrays.stream(this.sockets).collect(Collectors.toList()));
        wirableBeans.addAll(Arrays.stream(this.sockets).flatMap(socketInfo -> this.extractNestedBeans((BeanInfo)socketInfo)).collect(Collectors.toList()));
        wirableBeans.addAll(Arrays.stream(this.modules).flatMap(moduleInfo -> Arrays.stream(moduleInfo.getPublicBeans())).collect(Collectors.toList()));
        wirableBeans = wirableBeans.stream().collect(Collectors.groupingBy(BeanInfo::getQualifiedName)).entrySet().stream().filter(e -> ((List)e.getValue()).size() == 1).map(e -> (BeanInfo)((List)e.getValue()).get(0)).collect(Collectors.toList());
        List beanSockets = Arrays.stream(this.beans).flatMap(beanInfo -> Arrays.stream(beanInfo.getSockets())).collect(Collectors.toList());
        List requiredModuleSockets = Arrays.stream(this.modules).flatMap(moduleInfo -> Arrays.stream(moduleInfo.getSockets())).collect(Collectors.toList());
        WireInfoFactory wireInfoFactory = WireInfoFactory.create(this.processingEnvironment, this.moduleElement, wirableBeans, beanSockets, requiredModuleSockets);
        TypeMirror wireAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement(Wire.class.getCanonicalName()).asType();
        TypeMirror wiresAnnotationType = this.processingEnvironment.getElementUtils().getTypeElement(Wires.class.getCanonicalName()).asType();
        Map<DeclaredType, List<AnnotationMirror>> annotationsByType = this.moduleElement.getAnnotationMirrors().stream().collect(Collectors.groupingBy(a -> a.getAnnotationType()));
        annotationsByType.entrySet().stream().forEach(e -> ((List)e.getValue()).stream().forEach(annotation -> {
            if (this.processingEnvironment.getTypeUtils().isSameType((TypeMirror)e.getKey(), wireAnnotationType)) {
                WireInfo<?> wire = wireInfoFactory.createWire((AnnotationMirror)annotation);
                if (wire != null) {
                    result.add(wire);
                }
            } else if (this.processingEnvironment.getTypeUtils().isSameType((TypeMirror)e.getKey(), wiresAnnotationType)) {
                ((Collection)annotation.getElementValues().values().iterator().next().getValue()).stream().forEach(value -> {
                    WireInfo<?> wire = wireInfoFactory.createWire((AnnotationMirror)value.getValue());
                    if (wire != null) {
                        result.add(wire);
                    }
                });
            }
        }));
        return result;
    }

    private boolean resolveSockets() {
        BeanInfo resolvedBean;
        BeanInfo[] resolvedBeans;
        boolean resolved = true;
        Map<QualifiedName, List<WireInfo>> wiresByBeanQName = this.extractWireInfos().stream().collect(Collectors.groupingBy(wire -> wire.getInto()));
        ArrayList<BeanInfo> resolverBeans = new ArrayList<BeanInfo>();
        resolverBeans.addAll(Arrays.asList(this.beans));
        resolverBeans.addAll(Arrays.stream(this.beans).flatMap(beanInfo -> this.extractNestedBeans((BeanInfo)beanInfo)).collect(Collectors.toList()));
        resolverBeans.addAll(Arrays.asList(this.sockets));
        resolverBeans.addAll(Arrays.stream(this.sockets).flatMap(socketInfo -> this.extractNestedBeans((BeanInfo)socketInfo)).collect(Collectors.toList()));
        resolverBeans.addAll(Arrays.stream(this.modules).flatMap(moduleInfo -> Arrays.stream(moduleInfo.getBeans())).collect(Collectors.toList()));
        SocketResolver socketResolver = new SocketResolver(this.processingEnvironment, this.moduleQName, resolverBeans);
        BiConsumer<BeanInfo, SocketInfo> resolvedBeanPostProcessor = (beanInfo, socketInfo) -> {
            if (beanInfo != null) {
                BeanInfo actualBeanInfo = beanInfo;
                while (actualBeanInfo instanceof NestedBeanInfo) {
                    actualBeanInfo = ((NestedBeanInfo)actualBeanInfo).getProvidingBean();
                }
                if (actualBeanInfo instanceof SocketBeanInfo) {
                    ((MutableSocketBeanInfo)actualBeanInfo).setOptional(socketInfo.isOptional());
                    ((WirableSocketBeanInfo)actualBeanInfo).setWired(true);
                }
            }
        };
        for (ModuleBeanInfo moduleBeanInfo : this.beans) {
            for (ModuleBeanSocketInfo moduleBeanSocketInfo : moduleBeanInfo.getSockets()) {
                if (MultiSocketInfo.class.isAssignableFrom(moduleBeanSocketInfo.getClass())) {
                    resolvedBeans = socketResolver.resolve((MultiSocketInfo)((Object)moduleBeanSocketInfo), wiresByBeanQName.get(moduleBeanSocketInfo.getQualifiedName()));
                    ((MutableMultiSocketInfo)((Object)moduleBeanSocketInfo)).setBeans(resolvedBeans);
                    if (resolvedBeans != null) {
                        Arrays.stream(resolvedBeans).forEach(resolvedBeanInfo -> resolvedBeanPostProcessor.accept((BeanInfo)resolvedBeanInfo, moduleBeanSocketInfo));
                    }
                } else if (SingleSocketInfo.class.isAssignableFrom(moduleBeanSocketInfo.getClass())) {
                    resolvedBean = socketResolver.resolve((SingleSocketInfo)((Object)moduleBeanSocketInfo), wiresByBeanQName.get(moduleBeanSocketInfo.getQualifiedName()));
                    ((MutableSingleSocketInfo)((Object)moduleBeanSocketInfo)).setBean(resolvedBean);
                    resolvedBeanPostProcessor.accept(resolvedBean, moduleBeanSocketInfo);
                } else {
                    moduleBeanSocketInfo.error("Unable to resolve socket");
                }
                resolved = resolved ? moduleBeanSocketInfo.isOptional() || moduleBeanSocketInfo.isResolved() : false;
            }
        }
        for (Info info : this.modules) {
            resolverBeans.clear();
            resolverBeans.addAll(Arrays.asList(this.beans));
            resolverBeans.addAll(Arrays.stream(this.beans).flatMap(beanInfo -> this.extractNestedBeans((BeanInfo)beanInfo)).collect(Collectors.toList()));
            resolverBeans.addAll(Arrays.asList(this.sockets));
            resolverBeans.addAll(Arrays.stream(this.sockets).flatMap(socketInfo -> this.extractNestedBeans((BeanInfo)socketInfo)).collect(Collectors.toList()));
            resolverBeans.addAll(Arrays.stream(this.modules).filter(arg_0 -> CompiledModuleInfoBuilder.lambda$resolveSockets$26((ModuleInfo)info, arg_0)).flatMap(moduleInfo2 -> Arrays.stream(moduleInfo2.getBeans())).collect(Collectors.toList()));
            socketResolver = new SocketResolver(this.processingEnvironment, this.moduleQName, resolverBeans);
            for (SocketInfo socketInfo2 : info.getSockets()) {
                if (MultiSocketInfo.class.isAssignableFrom(socketInfo2.getClass())) {
                    resolvedBeans = socketResolver.resolve((MultiSocketInfo)socketInfo2, wiresByBeanQName.get(socketInfo2.getQualifiedName()));
                    ((MutableMultiSocketInfo)socketInfo2).setBeans(resolvedBeans);
                    if (resolvedBeans != null) {
                        Arrays.stream(resolvedBeans).forEach(arg_0 -> CompiledModuleInfoBuilder.lambda$resolveSockets$28(resolvedBeanPostProcessor, (SocketBeanInfo)socketInfo2, arg_0));
                    }
                } else if (SingleSocketInfo.class.isAssignableFrom(socketInfo2.getClass())) {
                    resolvedBean = socketResolver.resolve((SingleSocketInfo)socketInfo2, wiresByBeanQName.get(socketInfo2.getQualifiedName()));
                    ((MutableSingleSocketInfo)socketInfo2).setBean(resolvedBean);
                    resolvedBeanPostProcessor.accept(resolvedBean, socketInfo2);
                }
                resolved = resolved ? socketInfo2.isOptional() || socketInfo2.isResolved() : false;
            }
        }
        return resolved;
    }

    private void checkUnwiredSockets() {
        Arrays.stream(this.sockets).filter(socketBean -> !socketBean.isWired()).forEach(socketBean -> socketBean.warning("Ignoring socket bean which is not wired"));
    }

    private boolean checkBeanCycles() {
        BeanCycleDetector detector = new BeanCycleDetector(this.moduleQName, Stream.concat(Arrays.stream(this.beans), Arrays.stream(this.sockets)).collect(Collectors.toList()));
        List<List<BeanCycleDetector.CycleInfo>> beanCycles = detector.findCycles();
        for (List<BeanCycleDetector.CycleInfo> cycle : beanCycles) {
            StringBuilder messageBuilder = new StringBuilder();
            int maxBeanQNameLength = cycle.stream().filter(cycleInfo -> cycleInfo.getSocketInfo() == null || !SocketBeanInfo.class.isAssignableFrom(cycleInfo.getSocketInfo().getClass())).mapToInt(cycleInfo -> cycleInfo.getBeanInfo().getQualifiedName().getValue().length()).max().getAsInt();
            char[] maxPad = new char[Math.floorDiv(maxBeanQNameLength, 2) + 4];
            Arrays.fill(maxPad, '\u2500');
            messageBuilder.append('\u250c').append(maxPad).append("\u2510\n");
            Arrays.fill(maxPad, ' ');
            messageBuilder.append('\u2502').append(maxPad).append("\u2502\n");
            boolean isWiredTo = false;
            for (int i = 0; i < cycle.size(); ++i) {
                boolean isOpaqueSocket;
                BeanCycleDetector.CycleInfo cycleInfo2 = cycle.get(i);
                if (NestedBeanInfo.class.isAssignableFrom(cycleInfo2.getBeanInfo().getClass())) {
                    String beanName = cycleInfo2.getBeanInfo().getQualifiedName().getValue();
                    Arrays.fill(maxPad, ' ');
                    String arrowLine = String.valueOf(maxPad) + "\u25bc";
                    String linkLine = String.valueOf(maxPad) + "\u2502";
                    String nestedLine = linkLine + " (nested)";
                    char[] pad = new char[maxPad.length - Math.floorDiv(beanName.length(), 2)];
                    Arrays.fill(pad, ' ');
                    messageBuilder.append("\u2502").append(pad).append(beanName).append("\n");
                    messageBuilder.append("\u2502").append(linkLine).append("\n");
                    messageBuilder.append("\u2502").append(nestedLine).append("\n");
                    messageBuilder.append("\u2502").append(linkLine).append("\n");
                    if (i >= cycle.size() - 1) continue;
                    messageBuilder.append("\u2502").append(arrowLine).append("\n");
                    continue;
                }
                boolean isSocketBean = SocketBeanInfo.class.isAssignableFrom(cycleInfo2.getSocketInfo().getClass());
                boolean bl = isOpaqueSocket = isSocketBean && isWiredTo;
                isWiredTo = ModuleBeanSocketInfo.class.isAssignableFrom(cycleInfo2.getSocketInfo().getClass()) ? !((ModuleBeanSocketInfo)cycleInfo2.getSocketInfo()).getQualifiedName().getBeanQName().equals(cycleInfo2.getBeanInfo().getQualifiedName()) : false;
                String beanName = cycleInfo2.getBeanInfo().getQualifiedName().getValue();
                Arrays.fill(maxPad, ' ');
                String linkLine = String.valueOf(maxPad) + (isSocketBean ? (char)'\u250a' : '\u2502');
                String dependencyLine = (isOpaqueSocket ? String.valueOf(maxPad).substring(0, maxPad.length - 1) + "(\u2504)" : linkLine) + " " + cycleInfo2.getSocketInfo().getQualifiedName().getValue();
                Arrays.fill(maxPad, ' ');
                String arrowLine = String.valueOf(maxPad) + "\u25bc";
                if (!isSocketBean) {
                    char[] pad = new char[maxPad.length - Math.floorDiv(beanName.length(), 2)];
                    Arrays.fill(pad, ' ');
                    messageBuilder.append("\u2502").append(pad).append(beanName).append("\n");
                }
                if (isWiredTo) continue;
                messageBuilder.append("\u2502").append(linkLine).append("\n");
                messageBuilder.append("\u2502").append(dependencyLine).append("\n");
                messageBuilder.append("\u2502").append(linkLine).append("\n");
                if (i >= cycle.size() - 1) continue;
                messageBuilder.append("\u2502").append(arrowLine).append("\n");
            }
            Arrays.fill(maxPad, '\u2500');
            messageBuilder.append('\u2514').append(maxPad).append("\u2518 \n");
            CharSequence[] messageLines = messageBuilder.toString().split("\n");
            messageLines[Math.floorDiv((int)messageLines.length, (int)2)] = "\u25b2" + messageLines[Math.floorDiv(messageLines.length, 2)].substring(1);
            String message = String.join((CharSequence)"\n", messageLines);
            cycle.stream().filter(cycleInfo -> cycleInfo.getBeanInfo().getQualifiedName().getModuleQName().equals(this.moduleQName)).filter(cycleInfo -> !NestedBeanInfo.class.isAssignableFrom(cycleInfo.getBeanInfo().getClass()) || !NestedBeanInfo.class.isAssignableFrom(((NestedBeanInfo)cycleInfo.getBeanInfo()).getProvidingBean().getClass())).forEach(cycleInfo -> cycleInfo.getBeanInfo().error("Bean " + cycleInfo.getBeanInfo().getQualifiedName() + " forms a cycle in module " + this.moduleQName + "\n" + message));
        }
        return beanCycles.size() > 0;
    }

    private Stream<NestedBeanInfo> extractNestedBeans(BeanInfo beanInfo) {
        return Arrays.stream(beanInfo.getNestedBeans()).flatMap(nestedBeanInfo -> Stream.concat(Stream.of(nestedBeanInfo), this.extractNestedBeans((BeanInfo)nestedBeanInfo)));
    }

    private static /* synthetic */ void lambda$resolveSockets$28(BiConsumer resolvedBeanPostProcessor, SocketBeanInfo socket, BeanInfo resolvedBeanInfo) {
        resolvedBeanPostProcessor.accept(resolvedBeanInfo, socket);
    }

    private static /* synthetic */ boolean lambda$resolveSockets$26(ModuleInfo moduleInfo, ModuleInfo moduleInfo2) {
        return !moduleInfo2.equals(moduleInfo);
    }
}

