/*
 * Decompiled with CFR 0.152.
 */
package io.instacount.client.model.shardedcounters.inputs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.instacount.client.model.shardedcounters.inputs.ShardedCounterStatusInput;
import java.beans.ConstructorProperties;
import lombok.NonNull;

public abstract class AbstractCounterInput {
    @JsonProperty(value="name")
    @NonNull
    private final String name;
    @JsonProperty(value="description")
    @NonNull
    private final Optional<String> optDescription;
    @JsonProperty(value="numShards")
    @NonNull
    private final int numShards;
    @JsonProperty(value="status")
    @NonNull
    private final ShardedCounterStatusInput counterStatusInput;

    public AbstractCounterInput(String name) {
        this.name = this.validateCounterName(name);
        this.optDescription = Optional.absent();
        this.numShards = 3;
        this.counterStatusInput = ShardedCounterStatusInput.AVAILABLE;
    }

    public AbstractCounterInput(String name, String description) {
        this.name = this.validateCounterName(name);
        this.optDescription = Optional.of((Object)description);
        this.numShards = 3;
        this.counterStatusInput = ShardedCounterStatusInput.AVAILABLE;
    }

    protected String validateCounterName(String counterName) {
        Preconditions.checkNotNull((Object)counterName);
        Preconditions.checkArgument((counterName.length() > 0 ? 1 : 0) != 0);
        return counterName;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public Optional<String> getOptDescription() {
        return this.optDescription;
    }

    @NonNull
    public int getNumShards() {
        return this.numShards;
    }

    @NonNull
    public ShardedCounterStatusInput getCounterStatusInput() {
        return this.counterStatusInput;
    }

    @ConstructorProperties(value={"name", "optDescription", "numShards", "counterStatusInput"})
    public AbstractCounterInput(@NonNull String name, @NonNull Optional<String> optDescription, @NonNull int numShards, @NonNull ShardedCounterStatusInput counterStatusInput) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (optDescription == null) {
            throw new NullPointerException("optDescription");
        }
        if (counterStatusInput == null) {
            throw new NullPointerException("counterStatusInput");
        }
        this.name = name;
        this.optDescription = optDescription;
        this.numShards = numShards;
        this.counterStatusInput = counterStatusInput;
    }

    public String toString() {
        return "AbstractCounterInput(name=" + this.getName() + ", optDescription=" + this.getOptDescription() + ", numShards=" + this.getNumShards() + ", counterStatusInput=" + (Object)((Object)this.getCounterStatusInput()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractCounterInput)) {
            return false;
        }
        AbstractCounterInput other = (AbstractCounterInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<String> this$optDescription = this.getOptDescription();
        Optional<String> other$optDescription = other.getOptDescription();
        if (this$optDescription == null ? other$optDescription != null : !this$optDescription.equals(other$optDescription)) {
            return false;
        }
        if (this.getNumShards() != other.getNumShards()) {
            return false;
        }
        ShardedCounterStatusInput this$counterStatusInput = this.getCounterStatusInput();
        ShardedCounterStatusInput other$counterStatusInput = other.getCounterStatusInput();
        return !(this$counterStatusInput == null ? other$counterStatusInput != null : !((Object)((Object)this$counterStatusInput)).equals((Object)other$counterStatusInput));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractCounterInput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<String> $optDescription = this.getOptDescription();
        result = result * 59 + ($optDescription == null ? 43 : $optDescription.hashCode());
        result = result * 59 + this.getNumShards();
        ShardedCounterStatusInput $counterStatusInput = this.getCounterStatusInput();
        result = result * 59 + ($counterStatusInput == null ? 43 : ((Object)((Object)$counterStatusInput)).hashCode());
        return result;
    }
}

