/*
 * Decompiled with CFR 0.152.
 */
package io.instacount.client.model.shardedcounters;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import io.instacount.client.model.shardedcounters.meta.ShardedCounterMeta;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import lombok.NonNull;
import org.joda.time.DateTime;

public class ShardedCounter {
    @JsonProperty(value="meta")
    @NonNull
    private final ShardedCounterMeta meta;
    @JsonProperty(value="name")
    @NonNull
    private final String name;
    @JsonProperty(value="description")
    @NonNull
    private final Optional<String> optDescription;
    @JsonProperty(value="numShards")
    @NonNull
    private final Integer numShards;
    @JsonProperty(value="status")
    @NonNull
    private final CounterStatus counterStatus;
    @JsonProperty(value="created")
    @NonNull
    private final DateTime createdDateTime;
    @JsonProperty(value="count")
    @NonNull
    private final BigInteger count;

    private ShardedCounter() {
        this.meta = null;
        this.name = null;
        this.optDescription = null;
        this.numShards = null;
        this.counterStatus = null;
        this.createdDateTime = null;
        this.count = null;
    }

    @NonNull
    public ShardedCounterMeta getMeta() {
        return this.meta;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public Optional<String> getOptDescription() {
        return this.optDescription;
    }

    @NonNull
    public Integer getNumShards() {
        return this.numShards;
    }

    @NonNull
    public CounterStatus getCounterStatus() {
        return this.counterStatus;
    }

    @NonNull
    public DateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    @NonNull
    public BigInteger getCount() {
        return this.count;
    }

    @ConstructorProperties(value={"meta", "name", "optDescription", "numShards", "counterStatus", "createdDateTime", "count"})
    public ShardedCounter(@NonNull ShardedCounterMeta meta, @NonNull String name, @NonNull Optional<String> optDescription, @NonNull Integer numShards, @NonNull CounterStatus counterStatus, @NonNull DateTime createdDateTime, @NonNull BigInteger count) {
        if (meta == null) {
            throw new NullPointerException("meta");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (optDescription == null) {
            throw new NullPointerException("optDescription");
        }
        if (numShards == null) {
            throw new NullPointerException("numShards");
        }
        if (counterStatus == null) {
            throw new NullPointerException("counterStatus");
        }
        if (createdDateTime == null) {
            throw new NullPointerException("createdDateTime");
        }
        if (count == null) {
            throw new NullPointerException("count");
        }
        this.meta = meta;
        this.name = name;
        this.optDescription = optDescription;
        this.numShards = numShards;
        this.counterStatus = counterStatus;
        this.createdDateTime = createdDateTime;
        this.count = count;
    }

    public String toString() {
        return "ShardedCounter(meta=" + (Object)((Object)this.getMeta()) + ", name=" + this.getName() + ", optDescription=" + this.getOptDescription() + ", numShards=" + this.getNumShards() + ", counterStatus=" + (Object)((Object)this.getCounterStatus()) + ", createdDateTime=" + this.getCreatedDateTime() + ", count=" + this.getCount() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardedCounter)) {
            return false;
        }
        ShardedCounter other = (ShardedCounter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ShardedCounterMeta this$meta = this.getMeta();
        ShardedCounterMeta other$meta = other.getMeta();
        if (this$meta == null ? other$meta != null : !((Object)((Object)this$meta)).equals((Object)other$meta)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<String> this$optDescription = this.getOptDescription();
        Optional<String> other$optDescription = other.getOptDescription();
        if (this$optDescription == null ? other$optDescription != null : !this$optDescription.equals(other$optDescription)) {
            return false;
        }
        Integer this$numShards = this.getNumShards();
        Integer other$numShards = other.getNumShards();
        if (this$numShards == null ? other$numShards != null : !((Object)this$numShards).equals(other$numShards)) {
            return false;
        }
        CounterStatus this$counterStatus = this.getCounterStatus();
        CounterStatus other$counterStatus = other.getCounterStatus();
        if (this$counterStatus == null ? other$counterStatus != null : !((Object)((Object)this$counterStatus)).equals((Object)other$counterStatus)) {
            return false;
        }
        DateTime this$createdDateTime = this.getCreatedDateTime();
        DateTime other$createdDateTime = other.getCreatedDateTime();
        if (this$createdDateTime == null ? other$createdDateTime != null : !this$createdDateTime.equals(other$createdDateTime)) {
            return false;
        }
        BigInteger this$count = this.getCount();
        BigInteger other$count = other.getCount();
        return !(this$count == null ? other$count != null : !((Object)this$count).equals(other$count));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardedCounter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ShardedCounterMeta $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)((Object)$meta)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<String> $optDescription = this.getOptDescription();
        result = result * 59 + ($optDescription == null ? 43 : $optDescription.hashCode());
        Integer $numShards = this.getNumShards();
        result = result * 59 + ($numShards == null ? 43 : ((Object)$numShards).hashCode());
        CounterStatus $counterStatus = this.getCounterStatus();
        result = result * 59 + ($counterStatus == null ? 43 : ((Object)((Object)$counterStatus)).hashCode());
        DateTime $createdDateTime = this.getCreatedDateTime();
        result = result * 59 + ($createdDateTime == null ? 43 : $createdDateTime.hashCode());
        BigInteger $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        return result;
    }

    public static enum CounterStatus {
        AVAILABLE,
        READ_ONLY_COUNT,
        EXPANDING_SHARDS,
        CONTRACTING_SHARDS,
        RESETTING,
        DELETING;

    }
}

